/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class URLEncodedUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static String PARAMETER_SEPARATOR = "&";
    private static String NAME_VALUE_SEPARATOR = "=";

    private void $$robo$$org_apache_http_client_utils_URLEncodedUtils$__constructor__() {
    }

    private static final List<NameValuePair> $$robo$$org_apache_http_client_utils_URLEncodedUtils$parse(URI uri, String encoding) {
        List<NameValuePair> result = Collections.emptyList();
        String query = uri.getRawQuery();
        if (query != null && query.length() > 0) {
            result = new ArrayList<NameValuePair>();
            URLEncodedUtils.parse(result, new Scanner(query), encoding);
        }
        return result;
    }

    private static final List<NameValuePair> $$robo$$org_apache_http_client_utils_URLEncodedUtils$parse(HttpEntity entity) throws IOException {
        List<NameValuePair> result = Collections.emptyList();
        if (URLEncodedUtils.isEncoded(entity)) {
            String content = EntityUtils.toString(entity);
            Header encoding = entity.getContentEncoding();
            if (content != null && content.length() > 0) {
                result = new ArrayList<NameValuePair>();
                URLEncodedUtils.parse(result, new Scanner(content), encoding != null ? encoding.getValue() : null);
            }
        }
        return result;
    }

    private static final boolean $$robo$$org_apache_http_client_utils_URLEncodedUtils$isEncoded(HttpEntity entity) {
        Header contentType = entity.getContentType();
        return contentType != null && contentType.getValue().equalsIgnoreCase("application/x-www-form-urlencoded");
    }

    private static final void $$robo$$org_apache_http_client_utils_URLEncodedUtils$parse(List<NameValuePair> parameters, Scanner scanner, String encoding) {
        scanner.useDelimiter("&");
        while (scanner.hasNext()) {
            String[] nameValue = scanner.next().split("=");
            if (nameValue.length == 0 || nameValue.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String name = URLEncodedUtils.decode(nameValue[0], encoding);
            String value = null;
            if (nameValue.length == 2) {
                value = URLEncodedUtils.decode(nameValue[1], encoding);
            }
            parameters.add(new BasicNameValuePair(name, value));
        }
    }

    private static final String $$robo$$org_apache_http_client_utils_URLEncodedUtils$format(List<? extends NameValuePair> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedValue;
            String encodedName = URLEncodedUtils.encode(nameValuePair.getName(), encoding);
            String value = nameValuePair.getValue();
            String string2 = encodedValue = value != null ? URLEncodedUtils.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static final String $$robo$$org_apache_http_client_utils_URLEncodedUtils$decode(String content, String encoding) {
        try {
            return URLDecoder.decode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    private static final String $$robo$$org_apache_http_client_utils_URLEncodedUtils$encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_client_utils_URLEncodedUtils$__constructor__();
    }

    public URLEncodedUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_client_utils_URLEncodedUtils$__constructor__(), 0, this);
    }

    public static List<NameValuePair> parse(URI uRI, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$org_apache_http_client_utils_URLEncodedUtils$parse(java.net.URI java.lang.String ), 0, (URI)uRI, (String)string2);
    }

    public static List<NameValuePair> parse(HttpEntity httpEntity) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$org_apache_http_client_utils_URLEncodedUtils$parse(org.apache.http.HttpEntity ), 0, (HttpEntity)httpEntity);
    }

    public static boolean isEncoded(HttpEntity httpEntity) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEncoded", $$robo$$org_apache_http_client_utils_URLEncodedUtils$isEncoded(org.apache.http.HttpEntity ), 0, (HttpEntity)httpEntity);
    }

    public static void parse(List<NameValuePair> list, Scanner scanner, String string2) {
        InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$org_apache_http_client_utils_URLEncodedUtils$parse(java.util.List<org.apache.http.NameValuePair> java.util.Scanner java.lang.String ), 0, list, (Scanner)scanner, (String)string2);
    }

    public static String format(List<? extends NameValuePair> list, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("format", $$robo$$org_apache_http_client_utils_URLEncodedUtils$format(java.util.List<? extends org.apache.http.NameValuePair> java.lang.String ), 0, list, (String)string2);
    }

    private static String decode(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$org_apache_http_client_utils_URLEncodedUtils$decode(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static String encode(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$org_apache_http_client_utils_URLEncodedUtils$encode(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (URLEncodedUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

