/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.EofSensorWatcher;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EofSensorInputStream
extends InputStream
implements ConnectionReleaseTrigger,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected InputStream wrappedStream;
    private boolean selfClosed;
    private EofSensorWatcher eofWatcher;

    private void $$robo$$org_apache_http_conn_EofSensorInputStream$__constructor__(InputStream in, EofSensorWatcher watcher) {
        if (in == null) {
            throw new IllegalArgumentException("Wrapped stream may not be null.");
        }
        this.wrappedStream = in;
        this.selfClosed = false;
        this.eofWatcher = watcher;
    }

    private final boolean $$robo$$org_apache_http_conn_EofSensorInputStream$isReadAllowed() throws IOException {
        if (this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.wrappedStream != null;
    }

    private final int $$robo$$org_apache_http_conn_EofSensorInputStream$read() throws IOException {
        int l = -1;
        if (this.isReadAllowed()) {
            try {
                l = this.wrappedStream.read();
                this.checkEOF(l);
            }
            catch (IOException ex) {
                this.checkAbort();
                throw ex;
            }
        }
        return l;
    }

    private final int $$robo$$org_apache_http_conn_EofSensorInputStream$read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        if (this.isReadAllowed()) {
            try {
                l = this.wrappedStream.read(b, off, len);
                this.checkEOF(l);
            }
            catch (IOException ex) {
                this.checkAbort();
                throw ex;
            }
        }
        return l;
    }

    private final int $$robo$$org_apache_http_conn_EofSensorInputStream$read(byte[] b) throws IOException {
        int l = -1;
        if (this.isReadAllowed()) {
            try {
                l = this.wrappedStream.read(b);
                this.checkEOF(l);
            }
            catch (IOException ex) {
                this.checkAbort();
                throw ex;
            }
        }
        return l;
    }

    private final int $$robo$$org_apache_http_conn_EofSensorInputStream$available() throws IOException {
        int a = 0;
        if (this.isReadAllowed()) {
            try {
                a = this.wrappedStream.available();
            }
            catch (IOException ex) {
                this.checkAbort();
                throw ex;
            }
        }
        return a;
    }

    private final void $$robo$$org_apache_http_conn_EofSensorInputStream$close() throws IOException {
        this.selfClosed = true;
        this.checkClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_conn_EofSensorInputStream$checkEOF(int eof) throws IOException {
        if (this.wrappedStream != null && eof < 0) {
            try {
                boolean scws = true;
                if (this.eofWatcher != null) {
                    scws = this.eofWatcher.eofDetected(this.wrappedStream);
                }
                if (scws) {
                    this.wrappedStream.close();
                }
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_conn_EofSensorInputStream$checkClose() throws IOException {
        if (this.wrappedStream != null) {
            try {
                boolean scws = true;
                if (this.eofWatcher != null) {
                    scws = this.eofWatcher.streamClosed(this.wrappedStream);
                }
                if (scws) {
                    this.wrappedStream.close();
                }
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_conn_EofSensorInputStream$checkAbort() throws IOException {
        if (this.wrappedStream != null) {
            try {
                boolean scws = true;
                if (this.eofWatcher != null) {
                    scws = this.eofWatcher.streamAbort(this.wrappedStream);
                }
                if (scws) {
                    this.wrappedStream.close();
                }
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    private final void $$robo$$org_apache_http_conn_EofSensorInputStream$releaseConnection() throws IOException {
        this.close();
    }

    private final void $$robo$$org_apache_http_conn_EofSensorInputStream$abortConnection() throws IOException {
        this.selfClosed = true;
        this.checkAbort();
    }

    private void __constructor__(InputStream inputStream, EofSensorWatcher eofSensorWatcher) {
        this.$$robo$$org_apache_http_conn_EofSensorInputStream$__constructor__(inputStream, eofSensorWatcher);
    }

    public EofSensorInputStream(InputStream inputStream, EofSensorWatcher eofSensorWatcher) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_EofSensorInputStream$__constructor__(java.io.InputStream org.apache.http.conn.EofSensorWatcher ), 0, this, inputStream, eofSensorWatcher);
    }

    protected boolean isReadAllowed() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isReadAllowed", $$robo$$org_apache_http_conn_EofSensorInputStream$isReadAllowed(), 0, this);
    }

    @Override
    public int read() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_conn_EofSensorInputStream$read(), 0, this);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_conn_EofSensorInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_conn_EofSensorInputStream$read(byte[] ), 0, this, byArray);
    }

    @Override
    public int available() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$org_apache_http_conn_EofSensorInputStream$available(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_conn_EofSensorInputStream$close(), 0, this);
    }

    protected void checkEOF(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("checkEOF", $$robo$$org_apache_http_conn_EofSensorInputStream$checkEOF(int ), 0, this, n);
    }

    protected void checkClose() throws IOException {
        InvokeDynamicSupport.bootstrap("checkClose", $$robo$$org_apache_http_conn_EofSensorInputStream$checkClose(), 0, this);
    }

    protected void checkAbort() throws IOException {
        InvokeDynamicSupport.bootstrap("checkAbort", $$robo$$org_apache_http_conn_EofSensorInputStream$checkAbort(), 0, this);
    }

    @Override
    public void releaseConnection() throws IOException {
        InvokeDynamicSupport.bootstrap("releaseConnection", $$robo$$org_apache_http_conn_EofSensorInputStream$releaseConnection(), 0, this);
    }

    @Override
    public void abortConnection() throws IOException {
        InvokeDynamicSupport.bootstrap("abortConnection", $$robo$$org_apache_http_conn_EofSensorInputStream$abortConnection(), 0, this);
    }

    public /* synthetic */ EofSensorInputStream() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EofSensorInputStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

