/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MultihomePlainSocketFactory
implements SocketFactory,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static MultihomePlainSocketFactory DEFAULT_FACTORY;

    private static final MultihomePlainSocketFactory $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$getSocketFactory() {
        return DEFAULT_FACTORY;
    }

    private void $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$__constructor__() {
    }

    private final Socket $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$createSocket() {
        return new Socket();
    }

    private final Socket $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket();
        }
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            InetSocketAddress isa = new InetSocketAddress(localAddress, localPort);
            sock.bind(isa);
        }
        int timeout = HttpConnectionParams.getConnectionTimeout(params);
        InetAddress[] inetadrs = InetAddress.getAllByName(host);
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(inetadrs.length);
        addresses.addAll(Arrays.asList(inetadrs));
        Collections.shuffle(addresses);
        IOException lastEx = null;
        for (InetAddress address : addresses) {
            try {
                sock.connect(new InetSocketAddress(address, port), timeout);
                break;
            }
            catch (SocketTimeoutException ex) {
                throw ex;
            }
            catch (IOException ex) {
                sock = new Socket();
                lastEx = ex;
            }
        }
        if (lastEx != null) {
            throw lastEx;
        }
        return sock;
    }

    private final boolean $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (sock.getClass() != Socket.class) {
            throw new IllegalArgumentException("Socket not created by this factory.");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }

    private final boolean $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$equals(Object obj) {
        return obj == this;
    }

    private final int $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$hashCode() {
        return PlainSocketFactory.class.hashCode();
    }

    static void __staticInitializer__() {
        DEFAULT_FACTORY = new MultihomePlainSocketFactory();
    }

    public static MultihomePlainSocketFactory getSocketFactory() {
        return InvokeDynamicSupport.bootstrapStatic("getSocketFactory", $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$getSocketFactory(), 0);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_conn_MultihomePlainSocketFactory$__constructor__();
    }

    private MultihomePlainSocketFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$__constructor__(), 0, this);
    }

    @Override
    public Socket createSocket() {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$createSocket(), 0, this);
    }

    @Override
    public Socket connectSocket(Socket socket, String string2, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException {
        return InvokeDynamicSupport.bootstrap("connectSocket", $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$connectSocket(java.net.Socket java.lang.String int java.net.InetAddress int org.apache.http.params.HttpParams ), 0, this, socket, string2, n, inetAddress, n2, httpParams);
    }

    @Override
    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$isSecure(java.net.Socket ), 0, this, socket);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$org_apache_http_conn_MultihomePlainSocketFactory$hashCode(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MultihomePlainSocketFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultihomePlainSocketFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

