/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import com.google.errorprone.annotations.DoNotMock;
import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.RouteInfo;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class HttpRoute
implements RouteInfo,
Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HttpHost targetHost;
    private InetAddress localAddress;
    private HttpHost[] proxyChain;
    private RouteInfo.TunnelType tunnelled;
    private RouteInfo.LayerType layered;
    private boolean secure;

    private void $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(InetAddress local, HttpHost target, HttpHost[] proxies, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
        if (target == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (tunnelled == RouteInfo.TunnelType.TUNNELLED && proxies == null) {
            throw new IllegalArgumentException("Proxy required if tunnelled.");
        }
        if (tunnelled == null) {
            tunnelled = RouteInfo.TunnelType.PLAIN;
        }
        if (layered == null) {
            layered = RouteInfo.LayerType.PLAIN;
        }
        this.targetHost = target;
        this.localAddress = local;
        this.proxyChain = proxies;
        this.secure = secure;
        this.tunnelled = tunnelled;
        this.layered = layered;
    }

    private void $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(HttpHost target, InetAddress local, HttpHost[] proxies, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
    }

    private void $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(HttpHost target, InetAddress local, HttpHost proxy, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
    }

    private void $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(HttpHost target, InetAddress local, boolean secure) {
    }

    private void $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(HttpHost target) {
    }

    private void $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(HttpHost target, InetAddress local, HttpHost proxy, boolean secure) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
    }

    private static final HttpHost[] $$robo$$org_apache_http_conn_routing_HttpRoute$toChain(HttpHost proxy) {
        if (proxy == null) {
            return null;
        }
        return new HttpHost[]{proxy};
    }

    private static final HttpHost[] $$robo$$org_apache_http_conn_routing_HttpRoute$toChain(HttpHost[] proxies) {
        if (proxies == null || proxies.length < 1) {
            return null;
        }
        for (HttpHost proxy : proxies) {
            if (proxy != null) continue;
            throw new IllegalArgumentException("Proxy chain may not contain null elements.");
        }
        HttpHost[] result = new HttpHost[proxies.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)proxies, (int)0, (Object)result, (int)0, (int)proxies.length);
        return result;
    }

    private final HttpHost $$robo$$org_apache_http_conn_routing_HttpRoute$getTargetHost() {
        return this.targetHost;
    }

    private final InetAddress $$robo$$org_apache_http_conn_routing_HttpRoute$getLocalAddress() {
        return this.localAddress;
    }

    private final int $$robo$$org_apache_http_conn_routing_HttpRoute$getHopCount() {
        return this.proxyChain == null ? 1 : this.proxyChain.length + 1;
    }

    private final HttpHost $$robo$$org_apache_http_conn_routing_HttpRoute$getHopTarget(int hop) {
        if (hop < 0) {
            throw new IllegalArgumentException("Hop index must not be negative: " + hop);
        }
        int hopcount = this.getHopCount();
        if (hop >= hopcount) {
            throw new IllegalArgumentException("Hop index " + hop + " exceeds route length " + hopcount);
        }
        HttpHost result = null;
        result = hop < hopcount - 1 ? this.proxyChain[hop] : this.targetHost;
        return result;
    }

    private final HttpHost $$robo$$org_apache_http_conn_routing_HttpRoute$getProxyHost() {
        return this.proxyChain == null ? null : this.proxyChain[0];
    }

    private final RouteInfo.TunnelType $$robo$$org_apache_http_conn_routing_HttpRoute$getTunnelType() {
        return this.tunnelled;
    }

    private final boolean $$robo$$org_apache_http_conn_routing_HttpRoute$isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    private final RouteInfo.LayerType $$robo$$org_apache_http_conn_routing_HttpRoute$getLayerType() {
        return this.layered;
    }

    private final boolean $$robo$$org_apache_http_conn_routing_HttpRoute$isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    private final boolean $$robo$$org_apache_http_conn_routing_HttpRoute$isSecure() {
        return this.secure;
    }

    private final boolean $$robo$$org_apache_http_conn_routing_HttpRoute$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRoute)) {
            return false;
        }
        HttpRoute that = (HttpRoute)o;
        boolean equal = this.targetHost.equals(that.targetHost);
        equal &= this.localAddress == that.localAddress || this.localAddress != null && this.localAddress.equals(that.localAddress);
        equal &= this.proxyChain == that.proxyChain || this.proxyChain != null && that.proxyChain != null && this.proxyChain.length == that.proxyChain.length;
        if ((equal &= this.secure == that.secure && this.tunnelled == that.tunnelled && this.layered == that.layered) && this.proxyChain != null) {
            for (int i = 0; equal && i < this.proxyChain.length; ++i) {
                equal = this.proxyChain[i].equals(that.proxyChain[i]);
            }
        }
        return equal;
    }

    private final int $$robo$$org_apache_http_conn_routing_HttpRoute$hashCode() {
        int hc = this.targetHost.hashCode();
        if (this.localAddress != null) {
            hc ^= this.localAddress.hashCode();
        }
        if (this.proxyChain != null) {
            hc ^= this.proxyChain.length;
            for (HttpHost aProxyChain : this.proxyChain) {
                hc ^= aProxyChain.hashCode();
            }
        }
        if (this.secure) {
            hc ^= 0x11111111;
        }
        hc ^= this.tunnelled.hashCode();
        return hc ^= this.layered.hashCode();
    }

    private final String $$robo$$org_apache_http_conn_routing_HttpRoute$toString() {
        StringBuilder cab = new StringBuilder(50 + this.getHopCount() * 30);
        cab.append("HttpRoute[");
        if (this.localAddress != null) {
            cab.append(this.localAddress);
            cab.append("->");
        }
        cab.append('{');
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            cab.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            cab.append('l');
        }
        if (this.secure) {
            cab.append('s');
        }
        cab.append("}->");
        if (this.proxyChain != null) {
            for (HttpHost aProxyChain : this.proxyChain) {
                cab.append(aProxyChain);
                cab.append("->");
            }
        }
        cab.append(this.targetHost);
        cab.append(']');
        return cab.toString();
    }

    private final Object $$robo$$org_apache_http_conn_routing_HttpRoute$clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void __constructor__(InetAddress inetAddress, HttpHost httpHost, HttpHost[] httpHostArray, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this.$$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(inetAddress, httpHost, httpHostArray, bl, tunnelType, layerType);
    }

    private HttpRoute(InetAddress inetAddress, HttpHost httpHost, HttpHost[] httpHostArray, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(java.net.InetAddress org.apache.http.HttpHost org.apache.http.HttpHost[] boolean org.apache.http.conn.routing.RouteInfo$TunnelType org.apache.http.conn.routing.RouteInfo$LayerType ), 0, this, inetAddress, httpHost, httpHostArray, bl, tunnelType, layerType);
    }

    private void __constructor__(HttpHost httpHost, InetAddress inetAddress, HttpHost[] httpHostArray, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this.$$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(httpHost, inetAddress, httpHostArray, bl, tunnelType, layerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost[] httpHostArray, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(inetAddress, httpHost, HttpRoute.toChain(httpHostArray), bl, tunnelType, layerType);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(org.apache.http.HttpHost java.net.InetAddress org.apache.http.HttpHost[] boolean org.apache.http.conn.routing.RouteInfo$TunnelType org.apache.http.conn.routing.RouteInfo$LayerType ), 0, this, httpHost, inetAddress, httpHostArray, bl, tunnelType, layerType);
    }

    private void __constructor__(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this.$$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(httpHost, inetAddress, httpHost2, bl, tunnelType, layerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl, RouteInfo.TunnelType tunnelType, RouteInfo.LayerType layerType) {
        this(inetAddress, httpHost, HttpRoute.toChain(httpHost2), bl, tunnelType, layerType);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(org.apache.http.HttpHost java.net.InetAddress org.apache.http.HttpHost boolean org.apache.http.conn.routing.RouteInfo$TunnelType org.apache.http.conn.routing.RouteInfo$LayerType ), 0, this, httpHost, inetAddress, httpHost2, bl, tunnelType, layerType);
    }

    private void __constructor__(HttpHost httpHost, InetAddress inetAddress, boolean bl) {
        this.$$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(httpHost, inetAddress, bl);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, boolean bl) {
        this(inetAddress, httpHost, null, bl, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(org.apache.http.HttpHost java.net.InetAddress boolean ), 0, this, httpHost, inetAddress, bl);
    }

    private void __constructor__(HttpHost httpHost) {
        this.$$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(httpHost);
    }

    public HttpRoute(HttpHost httpHost) {
        this(null, httpHost, null, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(org.apache.http.HttpHost ), 0, this, httpHost);
    }

    private void __constructor__(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl) {
        this.$$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(httpHost, inetAddress, httpHost2, bl);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl) {
        this(inetAddress, httpHost, HttpRoute.toChain(httpHost2), bl, bl ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN, bl ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_HttpRoute$__constructor__(org.apache.http.HttpHost java.net.InetAddress org.apache.http.HttpHost boolean ), 0, this, httpHost, inetAddress, httpHost2, bl);
    }

    private static HttpHost[] toChain(HttpHost httpHost) {
        return InvokeDynamicSupport.bootstrapStatic("toChain", $$robo$$org_apache_http_conn_routing_HttpRoute$toChain(org.apache.http.HttpHost ), 0, (HttpHost)httpHost);
    }

    private static HttpHost[] toChain(HttpHost[] httpHostArray) {
        return InvokeDynamicSupport.bootstrapStatic("toChain", $$robo$$org_apache_http_conn_routing_HttpRoute$toChain(org.apache.http.HttpHost[] ), 0, (HttpHost[])httpHostArray);
    }

    @Override
    public HttpHost getTargetHost() {
        return InvokeDynamicSupport.bootstrap("getTargetHost", $$robo$$org_apache_http_conn_routing_HttpRoute$getTargetHost(), 0, this);
    }

    @Override
    public InetAddress getLocalAddress() {
        return InvokeDynamicSupport.bootstrap("getLocalAddress", $$robo$$org_apache_http_conn_routing_HttpRoute$getLocalAddress(), 0, this);
    }

    @Override
    public int getHopCount() {
        return (int)InvokeDynamicSupport.bootstrap("getHopCount", $$robo$$org_apache_http_conn_routing_HttpRoute$getHopCount(), 0, this);
    }

    @Override
    public HttpHost getHopTarget(int n) {
        return InvokeDynamicSupport.bootstrap("getHopTarget", $$robo$$org_apache_http_conn_routing_HttpRoute$getHopTarget(int ), 0, this, n);
    }

    @Override
    public HttpHost getProxyHost() {
        return InvokeDynamicSupport.bootstrap("getProxyHost", $$robo$$org_apache_http_conn_routing_HttpRoute$getProxyHost(), 0, this);
    }

    @Override
    public RouteInfo.TunnelType getTunnelType() {
        return InvokeDynamicSupport.bootstrap("getTunnelType", $$robo$$org_apache_http_conn_routing_HttpRoute$getTunnelType(), 0, this);
    }

    @Override
    public boolean isTunnelled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTunnelled", $$robo$$org_apache_http_conn_routing_HttpRoute$isTunnelled(), 0, this);
    }

    @Override
    public RouteInfo.LayerType getLayerType() {
        return InvokeDynamicSupport.bootstrap("getLayerType", $$robo$$org_apache_http_conn_routing_HttpRoute$getLayerType(), 0, this);
    }

    @Override
    public boolean isLayered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayered", $$robo$$org_apache_http_conn_routing_HttpRoute$isLayered(), 0, this);
    }

    @Override
    public boolean isSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$org_apache_http_conn_routing_HttpRoute$isSecure(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$org_apache_http_conn_routing_HttpRoute$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$org_apache_http_conn_routing_HttpRoute$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$org_apache_http_conn_routing_HttpRoute$toString(), 0, this);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$org_apache_http_conn_routing_HttpRoute$clone(), 0, this);
    }

    public /* synthetic */ HttpRoute() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpRoute)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

