/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import com.google.errorprone.annotations.DoNotMock;
import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RouteTracker
implements RouteInfo,
Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HttpHost targetHost;
    private InetAddress localAddress;
    private boolean connected;
    private HttpHost[] proxyChain;
    private RouteInfo.TunnelType tunnelled;
    private RouteInfo.LayerType layered;
    private boolean secure;

    private void $$robo$$org_apache_http_conn_routing_RouteTracker$__constructor__(HttpHost target, InetAddress local) {
        if (target == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        this.targetHost = target;
        this.localAddress = local;
        this.tunnelled = RouteInfo.TunnelType.PLAIN;
        this.layered = RouteInfo.LayerType.PLAIN;
    }

    private void $$robo$$org_apache_http_conn_routing_RouteTracker$__constructor__(HttpRoute route) {
    }

    private final void $$robo$$org_apache_http_conn_routing_RouteTracker$connectTarget(boolean secure) {
        if (this.connected) {
            throw new IllegalStateException("Already connected.");
        }
        this.connected = true;
        this.secure = secure;
    }

    private final void $$robo$$org_apache_http_conn_routing_RouteTracker$connectProxy(HttpHost proxy, boolean secure) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
        if (this.connected) {
            throw new IllegalStateException("Already connected.");
        }
        this.connected = true;
        this.proxyChain = new HttpHost[]{proxy};
        this.secure = secure;
    }

    private final void $$robo$$org_apache_http_conn_routing_RouteTracker$tunnelTarget(boolean secure) {
        if (!this.connected) {
            throw new IllegalStateException("No tunnel unless connected.");
        }
        if (this.proxyChain == null) {
            throw new IllegalStateException("No tunnel without proxy.");
        }
        this.tunnelled = RouteInfo.TunnelType.TUNNELLED;
        this.secure = secure;
    }

    private final void $$robo$$org_apache_http_conn_routing_RouteTracker$tunnelProxy(HttpHost proxy, boolean secure) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy host may not be null.");
        }
        if (!this.connected) {
            throw new IllegalStateException("No tunnel unless connected.");
        }
        if (this.proxyChain == null) {
            throw new IllegalStateException("No proxy tunnel without proxy.");
        }
        HttpHost[] proxies = new HttpHost[this.proxyChain.length + 1];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.proxyChain, (int)0, (Object)proxies, (int)0, (int)this.proxyChain.length);
        proxies[proxies.length - 1] = proxy;
        this.proxyChain = proxies;
        this.secure = secure;
    }

    private final void $$robo$$org_apache_http_conn_routing_RouteTracker$layerProtocol(boolean secure) {
        if (!this.connected) {
            throw new IllegalStateException("No layered protocol unless connected.");
        }
        this.layered = RouteInfo.LayerType.LAYERED;
        this.secure = secure;
    }

    private final HttpHost $$robo$$org_apache_http_conn_routing_RouteTracker$getTargetHost() {
        return this.targetHost;
    }

    private final InetAddress $$robo$$org_apache_http_conn_routing_RouteTracker$getLocalAddress() {
        return this.localAddress;
    }

    private final int $$robo$$org_apache_http_conn_routing_RouteTracker$getHopCount() {
        int hops = 0;
        if (this.connected) {
            hops = this.proxyChain == null ? 1 : this.proxyChain.length + 1;
        }
        return hops;
    }

    private final HttpHost $$robo$$org_apache_http_conn_routing_RouteTracker$getHopTarget(int hop) {
        if (hop < 0) {
            throw new IllegalArgumentException("Hop index must not be negative: " + hop);
        }
        int hopcount = this.getHopCount();
        if (hop >= hopcount) {
            throw new IllegalArgumentException("Hop index " + hop + " exceeds tracked route length " + hopcount + ".");
        }
        HttpHost result = null;
        result = hop < hopcount - 1 ? this.proxyChain[hop] : this.targetHost;
        return result;
    }

    private final HttpHost $$robo$$org_apache_http_conn_routing_RouteTracker$getProxyHost() {
        return this.proxyChain == null ? null : this.proxyChain[0];
    }

    private final boolean $$robo$$org_apache_http_conn_routing_RouteTracker$isConnected() {
        return this.connected;
    }

    private final RouteInfo.TunnelType $$robo$$org_apache_http_conn_routing_RouteTracker$getTunnelType() {
        return this.tunnelled;
    }

    private final boolean $$robo$$org_apache_http_conn_routing_RouteTracker$isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    private final RouteInfo.LayerType $$robo$$org_apache_http_conn_routing_RouteTracker$getLayerType() {
        return this.layered;
    }

    private final boolean $$robo$$org_apache_http_conn_routing_RouteTracker$isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    private final boolean $$robo$$org_apache_http_conn_routing_RouteTracker$isSecure() {
        return this.secure;
    }

    private final HttpRoute $$robo$$org_apache_http_conn_routing_RouteTracker$toRoute() {
        return !this.connected ? null : new HttpRoute(this.targetHost, this.localAddress, this.proxyChain, this.secure, this.tunnelled, this.layered);
    }

    private final boolean $$robo$$org_apache_http_conn_routing_RouteTracker$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouteTracker)) {
            return false;
        }
        RouteTracker that = (RouteTracker)o;
        boolean equal = this.targetHost.equals(that.targetHost);
        equal &= this.localAddress == that.localAddress || this.localAddress != null && this.localAddress.equals(that.localAddress);
        equal &= this.proxyChain == that.proxyChain || this.proxyChain != null && that.proxyChain != null && this.proxyChain.length == that.proxyChain.length;
        if ((equal &= this.connected == that.connected && this.secure == that.secure && this.tunnelled == that.tunnelled && this.layered == that.layered) && this.proxyChain != null) {
            for (int i = 0; equal && i < this.proxyChain.length; ++i) {
                equal = this.proxyChain[i].equals(that.proxyChain[i]);
            }
        }
        return equal;
    }

    private final int $$robo$$org_apache_http_conn_routing_RouteTracker$hashCode() {
        int hc = this.targetHost.hashCode();
        if (this.localAddress != null) {
            hc ^= this.localAddress.hashCode();
        }
        if (this.proxyChain != null) {
            hc ^= this.proxyChain.length;
            for (int i = 0; i < this.proxyChain.length; ++i) {
                hc ^= this.proxyChain[i].hashCode();
            }
        }
        if (this.connected) {
            hc ^= 0x11111111;
        }
        if (this.secure) {
            hc ^= 0x22222222;
        }
        hc ^= this.tunnelled.hashCode();
        return hc ^= this.layered.hashCode();
    }

    private final String $$robo$$org_apache_http_conn_routing_RouteTracker$toString() {
        StringBuilder cab = new StringBuilder(50 + this.getHopCount() * 30);
        cab.append("RouteTracker[");
        if (this.localAddress != null) {
            cab.append(this.localAddress);
            cab.append("->");
        }
        cab.append('{');
        if (this.connected) {
            cab.append('c');
        }
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            cab.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            cab.append('l');
        }
        if (this.secure) {
            cab.append('s');
        }
        cab.append("}->");
        if (this.proxyChain != null) {
            for (int i = 0; i < this.proxyChain.length; ++i) {
                cab.append(this.proxyChain[i]);
                cab.append("->");
            }
        }
        cab.append(this.targetHost);
        cab.append(']');
        return cab.toString();
    }

    private final Object $$robo$$org_apache_http_conn_routing_RouteTracker$clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void __constructor__(HttpHost httpHost, InetAddress inetAddress) {
        this.$$robo$$org_apache_http_conn_routing_RouteTracker$__constructor__(httpHost, inetAddress);
    }

    public RouteTracker(HttpHost httpHost, InetAddress inetAddress) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_RouteTracker$__constructor__(org.apache.http.HttpHost java.net.InetAddress ), 0, this, httpHost, inetAddress);
    }

    private void __constructor__(HttpRoute httpRoute) {
        this.$$robo$$org_apache_http_conn_routing_RouteTracker$__constructor__(httpRoute);
    }

    public RouteTracker(HttpRoute httpRoute) {
        this(httpRoute.getTargetHost(), httpRoute.getLocalAddress());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_routing_RouteTracker$__constructor__(org.apache.http.conn.routing.HttpRoute ), 0, this, httpRoute);
    }

    public void connectTarget(boolean bl) {
        InvokeDynamicSupport.bootstrap("connectTarget", $$robo$$org_apache_http_conn_routing_RouteTracker$connectTarget(boolean ), 0, this, bl);
    }

    public void connectProxy(HttpHost httpHost, boolean bl) {
        InvokeDynamicSupport.bootstrap("connectProxy", $$robo$$org_apache_http_conn_routing_RouteTracker$connectProxy(org.apache.http.HttpHost boolean ), 0, this, httpHost, bl);
    }

    public void tunnelTarget(boolean bl) {
        InvokeDynamicSupport.bootstrap("tunnelTarget", $$robo$$org_apache_http_conn_routing_RouteTracker$tunnelTarget(boolean ), 0, this, bl);
    }

    public void tunnelProxy(HttpHost httpHost, boolean bl) {
        InvokeDynamicSupport.bootstrap("tunnelProxy", $$robo$$org_apache_http_conn_routing_RouteTracker$tunnelProxy(org.apache.http.HttpHost boolean ), 0, this, httpHost, bl);
    }

    public void layerProtocol(boolean bl) {
        InvokeDynamicSupport.bootstrap("layerProtocol", $$robo$$org_apache_http_conn_routing_RouteTracker$layerProtocol(boolean ), 0, this, bl);
    }

    @Override
    public HttpHost getTargetHost() {
        return InvokeDynamicSupport.bootstrap("getTargetHost", $$robo$$org_apache_http_conn_routing_RouteTracker$getTargetHost(), 0, this);
    }

    @Override
    public InetAddress getLocalAddress() {
        return InvokeDynamicSupport.bootstrap("getLocalAddress", $$robo$$org_apache_http_conn_routing_RouteTracker$getLocalAddress(), 0, this);
    }

    @Override
    public int getHopCount() {
        return (int)InvokeDynamicSupport.bootstrap("getHopCount", $$robo$$org_apache_http_conn_routing_RouteTracker$getHopCount(), 0, this);
    }

    @Override
    public HttpHost getHopTarget(int n) {
        return InvokeDynamicSupport.bootstrap("getHopTarget", $$robo$$org_apache_http_conn_routing_RouteTracker$getHopTarget(int ), 0, this, n);
    }

    @Override
    public HttpHost getProxyHost() {
        return InvokeDynamicSupport.bootstrap("getProxyHost", $$robo$$org_apache_http_conn_routing_RouteTracker$getProxyHost(), 0, this);
    }

    public boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$org_apache_http_conn_routing_RouteTracker$isConnected(), 0, this);
    }

    @Override
    public RouteInfo.TunnelType getTunnelType() {
        return InvokeDynamicSupport.bootstrap("getTunnelType", $$robo$$org_apache_http_conn_routing_RouteTracker$getTunnelType(), 0, this);
    }

    @Override
    public boolean isTunnelled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTunnelled", $$robo$$org_apache_http_conn_routing_RouteTracker$isTunnelled(), 0, this);
    }

    @Override
    public RouteInfo.LayerType getLayerType() {
        return InvokeDynamicSupport.bootstrap("getLayerType", $$robo$$org_apache_http_conn_routing_RouteTracker$getLayerType(), 0, this);
    }

    @Override
    public boolean isLayered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayered", $$robo$$org_apache_http_conn_routing_RouteTracker$isLayered(), 0, this);
    }

    @Override
    public boolean isSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$org_apache_http_conn_routing_RouteTracker$isSecure(), 0, this);
    }

    public HttpRoute toRoute() {
        return InvokeDynamicSupport.bootstrap("toRoute", $$robo$$org_apache_http_conn_routing_RouteTracker$toRoute(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$org_apache_http_conn_routing_RouteTracker$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$org_apache_http_conn_routing_RouteTracker$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$org_apache_http_conn_routing_RouteTracker$toString(), 0, this);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$org_apache_http_conn_routing_RouteTracker$clone(), 0, this);
    }

    public /* synthetic */ RouteTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

