/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.scheme;

import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PlainSocketFactory
implements SocketFactory,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static PlainSocketFactory DEFAULT_FACTORY;
    private HostNameResolver nameResolver;

    private static final PlainSocketFactory $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$getSocketFactory() {
        return DEFAULT_FACTORY;
    }

    private void $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$__constructor__(HostNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    private void $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$__constructor__() {
    }

    private final Socket $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$createSocket() {
        return new Socket();
    }

    private final Socket $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket();
        }
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            InetSocketAddress isa = new InetSocketAddress(localAddress, localPort);
            sock.bind(isa);
        }
        int timeout = HttpConnectionParams.getConnectionTimeout(params);
        InetSocketAddress remoteAddress = this.nameResolver != null ? new InetSocketAddress(this.nameResolver.resolve(host), port) : new InetSocketAddress(host, port);
        try {
            sock.connect(remoteAddress, timeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return sock;
    }

    private final boolean $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (sock.getClass() != Socket.class) {
            throw new IllegalArgumentException("Socket not created by this factory.");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return false;
    }

    private final boolean $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$equals(Object obj) {
        return obj == this;
    }

    private final int $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$hashCode() {
        return PlainSocketFactory.class.hashCode();
    }

    static void __staticInitializer__() {
        DEFAULT_FACTORY = new PlainSocketFactory();
    }

    public static PlainSocketFactory getSocketFactory() {
        return InvokeDynamicSupport.bootstrapStatic("getSocketFactory", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$getSocketFactory(), 0);
    }

    private void __constructor__(HostNameResolver hostNameResolver) {
        this.$$robo$$org_apache_http_conn_scheme_PlainSocketFactory$__constructor__(hostNameResolver);
    }

    public PlainSocketFactory(HostNameResolver hostNameResolver) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$__constructor__(org.apache.http.conn.scheme.HostNameResolver ), 0, this, hostNameResolver);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_conn_scheme_PlainSocketFactory$__constructor__();
    }

    public PlainSocketFactory() {
        this(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$__constructor__(), 0, this);
    }

    @Override
    public Socket createSocket() {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$createSocket(), 0, this);
    }

    @Override
    public Socket connectSocket(Socket socket, String string2, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException {
        return InvokeDynamicSupport.bootstrap("connectSocket", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$connectSocket(java.net.Socket java.lang.String int java.net.InetAddress int org.apache.http.params.HttpParams ), 0, this, socket, string2, n, inetAddress, n2, httpParams);
    }

    @Override
    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$isSecure(java.net.Socket ), 0, this, socket);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$org_apache_http_conn_scheme_PlainSocketFactory$hashCode(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(PlainSocketFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlainSocketFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

