/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.scheme;

import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.util.LangUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Scheme
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String name;
    private SocketFactory socketFactory;
    private int defaultPort;
    private boolean layered;
    private String stringRep;

    private void $$robo$$org_apache_http_conn_scheme_Scheme$__constructor__(String name, SocketFactory factory, int port) {
        if (name == null) {
            throw new IllegalArgumentException("Scheme name may not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Socket factory may not be null");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Port is invalid: " + port);
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.socketFactory = factory;
        this.defaultPort = port;
        this.layered = factory instanceof LayeredSocketFactory;
    }

    private final int $$robo$$org_apache_http_conn_scheme_Scheme$getDefaultPort() {
        return this.defaultPort;
    }

    private final SocketFactory $$robo$$org_apache_http_conn_scheme_Scheme$getSocketFactory() {
        return this.socketFactory;
    }

    private final String $$robo$$org_apache_http_conn_scheme_Scheme$getName() {
        return this.name;
    }

    private final boolean $$robo$$org_apache_http_conn_scheme_Scheme$isLayered() {
        return this.layered;
    }

    private final int $$robo$$org_apache_http_conn_scheme_Scheme$resolvePort(int port) {
        return port <= 0 || port > 65535 ? this.defaultPort : port;
    }

    private final String $$robo$$org_apache_http_conn_scheme_Scheme$toString() {
        if (this.stringRep == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name);
            buffer.append(':');
            buffer.append(Integer.toString(this.defaultPort));
            this.stringRep = buffer.toString();
        }
        return this.stringRep;
    }

    private final boolean $$robo$$org_apache_http_conn_scheme_Scheme$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Scheme)) {
            return false;
        }
        Scheme s = (Scheme)obj;
        return this.name.equals(s.name) && this.defaultPort == s.defaultPort && this.layered == s.layered && this.socketFactory.equals(s.socketFactory);
    }

    private final int $$robo$$org_apache_http_conn_scheme_Scheme$hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.defaultPort);
        hash = LangUtils.hashCode(hash, this.name);
        hash = LangUtils.hashCode(hash, this.layered);
        hash = LangUtils.hashCode(hash, this.socketFactory);
        return hash;
    }

    private void __constructor__(String string2, SocketFactory socketFactory, int n) {
        this.$$robo$$org_apache_http_conn_scheme_Scheme$__constructor__(string2, socketFactory, n);
    }

    public Scheme(String string2, SocketFactory socketFactory, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_scheme_Scheme$__constructor__(java.lang.String org.apache.http.conn.scheme.SocketFactory int ), 0, this, string2, socketFactory, n);
    }

    public int getDefaultPort() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultPort", $$robo$$org_apache_http_conn_scheme_Scheme$getDefaultPort(), 0, this);
    }

    public SocketFactory getSocketFactory() {
        return InvokeDynamicSupport.bootstrap("getSocketFactory", $$robo$$org_apache_http_conn_scheme_Scheme$getSocketFactory(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$org_apache_http_conn_scheme_Scheme$getName(), 0, this);
    }

    public boolean isLayered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayered", $$robo$$org_apache_http_conn_scheme_Scheme$isLayered(), 0, this);
    }

    public int resolvePort(int n) {
        return (int)InvokeDynamicSupport.bootstrap("resolvePort", $$robo$$org_apache_http_conn_scheme_Scheme$resolvePort(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$org_apache_http_conn_scheme_Scheme$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$org_apache_http_conn_scheme_Scheme$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$org_apache_http_conn_scheme_Scheme$hashCode(), 0, this);
    }

    public /* synthetic */ Scheme() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Scheme)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

