/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.scheme;

import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.conn.scheme.Scheme;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SchemeRegistry
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Map<String, Scheme> registeredSchemes;

    private void $$robo$$org_apache_http_conn_scheme_SchemeRegistry$__constructor__() {
        this.registeredSchemes = new LinkedHashMap<String, Scheme>();
    }

    private final synchronized Scheme $$robo$$org_apache_http_conn_scheme_SchemeRegistry$getScheme(String name) {
        Scheme found = this.get(name);
        if (found == null) {
            throw new IllegalStateException("Scheme '" + name + "' not registered.");
        }
        return found;
    }

    private final synchronized Scheme $$robo$$org_apache_http_conn_scheme_SchemeRegistry$getScheme(HttpHost host) {
        if (host == null) {
            throw new IllegalArgumentException("Host must not be null.");
        }
        return this.getScheme(host.getSchemeName());
    }

    private final synchronized Scheme $$robo$$org_apache_http_conn_scheme_SchemeRegistry$get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme found = this.registeredSchemes.get(name);
        return found;
    }

    private final synchronized Scheme $$robo$$org_apache_http_conn_scheme_SchemeRegistry$register(Scheme sch) {
        if (sch == null) {
            throw new IllegalArgumentException("Scheme must not be null.");
        }
        Scheme old = this.registeredSchemes.put(sch.getName(), sch);
        return old;
    }

    private final synchronized Scheme $$robo$$org_apache_http_conn_scheme_SchemeRegistry$unregister(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        Scheme gone = this.registeredSchemes.remove(name);
        return gone;
    }

    private final synchronized List<String> $$robo$$org_apache_http_conn_scheme_SchemeRegistry$getSchemeNames() {
        return new ArrayList<String>(this.registeredSchemes.keySet());
    }

    private final synchronized void $$robo$$org_apache_http_conn_scheme_SchemeRegistry$setItems(Map<String, Scheme> map) {
        if (map == null) {
            return;
        }
        this.registeredSchemes.clear();
        this.registeredSchemes.putAll(map);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_conn_scheme_SchemeRegistry$__constructor__();
    }

    public SchemeRegistry() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$__constructor__(), 0, this);
    }

    public synchronized Scheme getScheme(String string2) {
        return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$getScheme(java.lang.String ), 0, this, string2);
    }

    public synchronized Scheme getScheme(HttpHost httpHost) {
        return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$getScheme(org.apache.http.HttpHost ), 0, this, httpHost);
    }

    public synchronized Scheme get(String string2) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$get(java.lang.String ), 0, this, string2);
    }

    public synchronized Scheme register(Scheme scheme) {
        return InvokeDynamicSupport.bootstrap("register", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$register(org.apache.http.conn.scheme.Scheme ), 0, this, scheme);
    }

    public synchronized Scheme unregister(String string2) {
        return InvokeDynamicSupport.bootstrap("unregister", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$unregister(java.lang.String ), 0, this, string2);
    }

    public synchronized List<String> getSchemeNames() {
        return InvokeDynamicSupport.bootstrap("getSchemeNames", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$getSchemeNames(), 0, this);
    }

    public synchronized void setItems(Map<String, Scheme> map) {
        InvokeDynamicSupport.bootstrap("setItems", $$robo$$org_apache_http_conn_scheme_SchemeRegistry$setItems(java.util.Map<java.lang.String, org.apache.http.conn.scheme.Scheme> ), 0, this, map);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SchemeRegistry)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

