/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.DistinguishedNameParser;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.conn.util.InetAddressUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractVerifier
implements X509HostnameVerifier,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String[] BAD_COUNTRY_2LDS;

    private void $$robo$$org_apache_http_conn_ssl_AbstractVerifier$__constructor__() {
    }

    private final void $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(String host, SSLSocket ssl) throws IOException {
        if (host == null) {
            throw new NullPointerException("host to verify is null");
        }
        SSLSession session = ssl.getSession();
        Certificate[] certs = session.getPeerCertificates();
        X509Certificate x509 = (X509Certificate)certs[0];
        this.verify(host, x509);
    }

    private final boolean $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(String host, SSLSession session) {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)certs[0];
            this.verify(host, x509);
            return true;
        }
        catch (SSLException e) {
            return false;
        }
    }

    private final void $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(String host, X509Certificate cert) throws SSLException {
        String[] cns = AbstractVerifier.getCNs(cert);
        String[] subjectAlts = AbstractVerifier.getDNSSubjectAlts(cert);
        this.verify(host, cns, subjectAlts);
    }

    private final void $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(String host, String[] cns, String[] subjectAlts, boolean strictWithSubDomains) throws SSLException {
        LinkedList<String> names = new LinkedList<String>();
        if (cns != null && cns.length > 0 && cns[0] != null) {
            names.add(cns[0]);
        }
        if (subjectAlts != null) {
            for (String subjectAlt : subjectAlts) {
                if (subjectAlt == null) continue;
                names.add(subjectAlt);
            }
        }
        if (names.isEmpty()) {
            String msg = "Certificate for <" + host + "> doesn't contain CN or DNS subjectAlt";
            throw new SSLException(msg);
        }
        StringBuffer buf = new StringBuffer();
        String hostName = host.trim().toLowerCase(Locale.ENGLISH);
        boolean match = false;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            boolean doWildcard;
            String cn = (String)it.next();
            cn = cn.toLowerCase(Locale.ENGLISH);
            buf.append(" <");
            buf.append(cn);
            buf.append('>');
            if (it.hasNext()) {
                buf.append(" OR");
            }
            boolean bl = doWildcard = cn.startsWith("*.") && cn.indexOf(46, 2) != -1 && AbstractVerifier.acceptableCountryWildcard(cn) && !InetAddressUtils.isIPv4Address(host);
            if (doWildcard) {
                match = hostName.endsWith(cn.substring(1));
                if (match && strictWithSubDomains) {
                    match = AbstractVerifier.countDots(hostName) == AbstractVerifier.countDots(cn);
                }
            } else {
                match = hostName.equals(cn);
            }
            if (!match) continue;
            break;
        }
        if (!match) {
            throw new SSLException("hostname in certificate didn't match: <" + host + "> !=" + buf);
        }
    }

    private static final boolean $$robo$$org_apache_http_conn_ssl_AbstractVerifier$acceptableCountryWildcard(String cn) {
        int cnLen = cn.length();
        if (cnLen >= 7 && cnLen <= 9 && cn.charAt(cnLen - 3) == '.') {
            String s = cn.substring(2, cnLen - 3);
            int x = Arrays.binarySearch(BAD_COUNTRY_2LDS, s);
            return x < 0;
        }
        return true;
    }

    private static final String[] $$robo$$org_apache_http_conn_ssl_AbstractVerifier$getCNs(X509Certificate cert) {
        DistinguishedNameParser dnParser = new DistinguishedNameParser(cert.getSubjectX500Principal());
        List<String> cnList = dnParser.getAllMostSpecificFirst("cn");
        if (!cnList.isEmpty()) {
            String[] cns = new String[cnList.size()];
            cnList.toArray(cns);
            return cns;
        }
        return null;
    }

    private static final String[] $$robo$$org_apache_http_conn_ssl_AbstractVerifier$getDNSSubjectAlts(X509Certificate cert) {
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            Logger.getLogger(AbstractVerifier.class.getName()).log(Level.FINE, "Error parsing certificate.", cpe);
        }
        if (c != null) {
            for (List<?> aC : c) {
                List<?> list = aC;
                int type = (Integer)list.get(0);
                if (type != 2) continue;
                String s = (String)list.get(1);
                subjectAltList.add(s);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return null;
    }

    private static final int $$robo$$org_apache_http_conn_ssl_AbstractVerifier$countDots(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    static void __staticInitializer__() {
        BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
        Arrays.sort(BAD_COUNTRY_2LDS);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_conn_ssl_AbstractVerifier$__constructor__();
    }

    public AbstractVerifier() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$__constructor__(), 0, this);
    }

    @Override
    public void verify(String string2, SSLSocket sSLSocket) throws IOException {
        InvokeDynamicSupport.bootstrap("verify", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(java.lang.String javax.net.ssl.SSLSocket ), 0, this, string2, sSLSocket);
    }

    @Override
    public boolean verify(String string2, SSLSession sSLSession) {
        return (boolean)InvokeDynamicSupport.bootstrap("verify", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(java.lang.String javax.net.ssl.SSLSession ), 0, this, string2, sSLSession);
    }

    @Override
    public void verify(String string2, X509Certificate x509Certificate) throws SSLException {
        InvokeDynamicSupport.bootstrap("verify", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(java.lang.String java.security.cert.X509Certificate ), 0, this, string2, x509Certificate);
    }

    public void verify(String string2, String[] stringArray, String[] stringArray2, boolean bl) throws SSLException {
        InvokeDynamicSupport.bootstrap("verify", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$verify(java.lang.String java.lang.String[] java.lang.String[] boolean ), 0, this, string2, stringArray, stringArray2, bl);
    }

    public static boolean acceptableCountryWildcard(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("acceptableCountryWildcard", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$acceptableCountryWildcard(java.lang.String ), 0, (String)string2);
    }

    public static String[] getCNs(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrapStatic("getCNs", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$getCNs(java.security.cert.X509Certificate ), 0, (X509Certificate)x509Certificate);
    }

    public static String[] getDNSSubjectAlts(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrapStatic("getDNSSubjectAlts", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$getDNSSubjectAlts(java.security.cert.X509Certificate ), 0, (X509Certificate)x509Certificate);
    }

    public static int countDots(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countDots", $$robo$$org_apache_http_conn_ssl_AbstractVerifier$countDots(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(AbstractVerifier.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractVerifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

