/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SSLSocketFactory
implements LayeredSocketFactory,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TLS = "TLS";
    public static String SSL = "SSL";
    public static String SSLV2 = "SSLv2";
    public static X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER;
    public static X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    public static X509HostnameVerifier STRICT_HOSTNAME_VERIFIER;
    private SSLContext sslcontext;
    private javax.net.ssl.SSLSocketFactory socketfactory;
    private HostNameResolver nameResolver;
    private X509HostnameVerifier hostnameVerifier;

    private static final SSLSocketFactory $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$getSocketFactory() {
        return NoPreloadHolder.DEFAULT_FACTORY;
    }

    private void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(String algorithm, KeyStore keystore, String keystorePassword, KeyStore truststore, SecureRandom random, HostNameResolver nameResolver) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this.hostnameVerifier = BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        if (algorithm == null) {
            algorithm = "TLS";
        }
        KeyManager[] keymanagers = null;
        if (keystore != null) {
            keymanagers = SSLSocketFactory.createKeyManagers(keystore, keystorePassword);
        }
        TrustManager[] trustmanagers = null;
        if (truststore != null) {
            trustmanagers = SSLSocketFactory.createTrustManagers(truststore);
        }
        this.sslcontext = SSLContext.getInstance(algorithm);
        this.sslcontext.init(keymanagers, trustmanagers, random);
        this.socketfactory = this.sslcontext.getSocketFactory();
        this.nameResolver = nameResolver;
    }

    private void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(KeyStore keystore, String keystorePassword, KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
    }

    private void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(KeyStore keystore, String keystorePassword) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
    }

    private void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
    }

    private void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(javax.net.ssl.SSLSocketFactory socketfactory) {
        this.hostnameVerifier = BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        this.sslcontext = null;
        this.socketfactory = socketfactory;
        this.nameResolver = null;
    }

    private void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__() {
        this.hostnameVerifier = BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        this.sslcontext = null;
        this.socketfactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        this.nameResolver = null;
    }

    private static final KeyManager[] $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createKeyManagers(KeyStore keystore, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }

    private static final TrustManager[] $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createTrustManagers(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(keystore);
        return tmfactory.getTrustManagers();
    }

    private final Socket $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createSocket() throws IOException {
        return (SSLSocket)this.socketfactory.createSocket();
    }

    private final Socket $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null.");
        }
        SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket());
        if (localAddress != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            InetSocketAddress isa = new InetSocketAddress(localAddress, localPort);
            sslsock.bind(isa);
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout(params);
        int soTimeout = HttpConnectionParams.getSoTimeout(params);
        InetSocketAddress remoteAddress = this.nameResolver != null ? new InetSocketAddress(this.nameResolver.resolve(host), port) : new InetSocketAddress(host, port);
        sslsock.connect(remoteAddress, connTimeout);
        sslsock.setSoTimeout(soTimeout);
        try {
            this.hostnameVerifier.verify(host, sslsock);
        }
        catch (IOException iox) {
            try {
                sslsock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iox;
        }
        return sslsock;
    }

    private final boolean $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null.");
        }
        if (!(sock instanceof SSLSocket)) {
            throw new IllegalArgumentException("Socket not created by this factory.");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed.");
        }
        return true;
    }

    private final Socket $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.socketfactory.createSocket(socket, host, port, autoClose);
        this.hostnameVerifier.verify(host, sslSocket);
        return sslSocket;
    }

    private final void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("Hostname verifier may not be null");
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    private final X509HostnameVerifier $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    private /* synthetic */ void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
        BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
        STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    }

    public static SSLSocketFactory getSocketFactory() {
        return InvokeDynamicSupport.bootstrapStatic("getSocketFactory", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$getSocketFactory(), 0);
    }

    private void __constructor__(String string2, KeyStore keyStore, String string3, KeyStore keyStore2, SecureRandom secureRandom, HostNameResolver hostNameResolver) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(string2, keyStore, string3, keyStore2, secureRandom, hostNameResolver);
    }

    public SSLSocketFactory(String string2, KeyStore keyStore, String string3, KeyStore keyStore2, SecureRandom secureRandom, HostNameResolver hostNameResolver) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(java.lang.String java.security.KeyStore java.lang.String java.security.KeyStore java.security.SecureRandom org.apache.http.conn.scheme.HostNameResolver ), 0, this, string2, keyStore, string3, keyStore2, secureRandom, hostNameResolver);
    }

    private void __constructor__(KeyStore keyStore, String string2, KeyStore keyStore2) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(keyStore, string2, keyStore2);
    }

    public SSLSocketFactory(KeyStore keyStore, String string2, KeyStore keyStore2) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this("TLS", keyStore, string2, keyStore2, null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(java.security.KeyStore java.lang.String java.security.KeyStore ), 0, this, keyStore, string2, keyStore2);
    }

    private void __constructor__(KeyStore keyStore, String string2) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(keyStore, string2);
    }

    public SSLSocketFactory(KeyStore keyStore, String string2) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this("TLS", keyStore, string2, null, null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(java.security.KeyStore java.lang.String ), 0, this, keyStore, string2);
    }

    private void __constructor__(KeyStore keyStore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(keyStore);
    }

    public SSLSocketFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this("TLS", null, null, keyStore, null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(java.security.KeyStore ), 0, this, keyStore);
    }

    private void __constructor__(javax.net.ssl.SSLSocketFactory sSLSocketFactory) {
        this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(sSLSocketFactory);
    }

    public SSLSocketFactory(javax.net.ssl.SSLSocketFactory sSLSocketFactory) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(javax.net.ssl.SSLSocketFactory ), 0, this, sSLSocketFactory);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__();
    }

    private SSLSocketFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(), 0, this);
    }

    private static KeyManager[] createKeyManagers(KeyStore keyStore, String string2) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrapStatic("createKeyManagers", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createKeyManagers(java.security.KeyStore java.lang.String ), 0, (KeyStore)keyStore, (String)string2);
    }

    private static TrustManager[] createTrustManagers(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        return InvokeDynamicSupport.bootstrapStatic("createTrustManagers", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createTrustManagers(java.security.KeyStore ), 0, (KeyStore)keyStore);
    }

    @Override
    public Socket createSocket() throws IOException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createSocket(), 0, this);
    }

    @Override
    public Socket connectSocket(Socket socket, String string2, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException {
        return InvokeDynamicSupport.bootstrap("connectSocket", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$connectSocket(java.net.Socket java.lang.String int java.net.InetAddress int org.apache.http.params.HttpParams ), 0, this, socket, string2, n, inetAddress, n2, httpParams);
    }

    @Override
    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$isSecure(java.net.Socket ), 0, this, socket);
    }

    @Override
    public Socket createSocket(Socket socket, String string2, int n, boolean bl) throws IOException, UnknownHostException {
        return InvokeDynamicSupport.bootstrap("createSocket", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$createSocket(java.net.Socket java.lang.String int boolean ), 0, this, socket, string2, n, bl);
    }

    public void setHostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        InvokeDynamicSupport.bootstrap("setHostnameVerifier", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$setHostnameVerifier(org.apache.http.conn.ssl.X509HostnameVerifier ), 0, this, x509HostnameVerifier);
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return InvokeDynamicSupport.bootstrap("getHostnameVerifier", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory$getHostnameVerifier(), 0, this);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory$__constructor__(var1_1);
    }

    static {
        RobolectricInternals.classInitializing(SSLSocketFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SSLSocketFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NoPreloadHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static SSLSocketFactory DEFAULT_FACTORY;

        private void $$robo$$org_apache_http_conn_ssl_SSLSocketFactory_NoPreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            DEFAULT_FACTORY = new SSLSocketFactory();
        }

        private void __constructor__() {
            this.$$robo$$org_apache_http_conn_ssl_SSLSocketFactory_NoPreloadHolder$__constructor__();
        }

        private NoPreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_conn_ssl_SSLSocketFactory_NoPreloadHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NoPreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

