/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CookieSpecRegistry
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Map<String, CookieSpecFactory> registeredSpecs;

    private void $$robo$$org_apache_http_cookie_CookieSpecRegistry$__constructor__() {
        this.registeredSpecs = new LinkedHashMap<String, CookieSpecFactory>();
    }

    private final synchronized void $$robo$$org_apache_http_cookie_CookieSpecRegistry$register(String name, CookieSpecFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Cookie spec factory may not be null");
        }
        this.registeredSpecs.put(name.toLowerCase(Locale.ENGLISH), factory);
    }

    private final synchronized void $$robo$$org_apache_http_cookie_CookieSpecRegistry$unregister(String id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        this.registeredSpecs.remove(id2.toLowerCase(Locale.ENGLISH));
    }

    private final synchronized CookieSpec $$robo$$org_apache_http_cookie_CookieSpecRegistry$getCookieSpec(String name, HttpParams params) throws IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        CookieSpecFactory factory = this.registeredSpecs.get(name.toLowerCase(Locale.ENGLISH));
        if (factory != null) {
            return factory.newInstance(params);
        }
        throw new IllegalStateException("Unsupported cookie spec: " + name);
    }

    private final synchronized CookieSpec $$robo$$org_apache_http_cookie_CookieSpecRegistry$getCookieSpec(String name) throws IllegalStateException {
        return this.getCookieSpec(name, null);
    }

    private final synchronized List<String> $$robo$$org_apache_http_cookie_CookieSpecRegistry$getSpecNames() {
        return new ArrayList<String>(this.registeredSpecs.keySet());
    }

    private final synchronized void $$robo$$org_apache_http_cookie_CookieSpecRegistry$setItems(Map<String, CookieSpecFactory> map) {
        if (map == null) {
            return;
        }
        this.registeredSpecs.clear();
        this.registeredSpecs.putAll(map);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_cookie_CookieSpecRegistry$__constructor__();
    }

    public CookieSpecRegistry() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_cookie_CookieSpecRegistry$__constructor__(), 0, this);
    }

    public synchronized void register(String string2, CookieSpecFactory cookieSpecFactory) {
        InvokeDynamicSupport.bootstrap("register", $$robo$$org_apache_http_cookie_CookieSpecRegistry$register(java.lang.String org.apache.http.cookie.CookieSpecFactory ), 0, this, string2, cookieSpecFactory);
    }

    public synchronized void unregister(String string2) {
        InvokeDynamicSupport.bootstrap("unregister", $$robo$$org_apache_http_cookie_CookieSpecRegistry$unregister(java.lang.String ), 0, this, string2);
    }

    public synchronized CookieSpec getCookieSpec(String string2, HttpParams httpParams) throws IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getCookieSpec", $$robo$$org_apache_http_cookie_CookieSpecRegistry$getCookieSpec(java.lang.String org.apache.http.params.HttpParams ), 0, this, string2, httpParams);
    }

    public synchronized CookieSpec getCookieSpec(String string2) throws IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getCookieSpec", $$robo$$org_apache_http_cookie_CookieSpecRegistry$getCookieSpec(java.lang.String ), 0, this, string2);
    }

    public synchronized List<String> getSpecNames() {
        return InvokeDynamicSupport.bootstrap("getSpecNames", $$robo$$org_apache_http_cookie_CookieSpecRegistry$getSpecNames(), 0, this);
    }

    public synchronized void setItems(Map<String, CookieSpecFactory> map) {
        InvokeDynamicSupport.bootstrap("setItems", $$robo$$org_apache_http_cookie_CookieSpecRegistry$setItems(java.util.Map<java.lang.String, org.apache.http.cookie.CookieSpecFactory> ), 0, this, map);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CookieSpecRegistry)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

