/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.EntityDeserializer;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.HttpRequestWriter;
import org.apache.http.impl.io.HttpResponseParser;
import org.apache.http.impl.io.SocketInputBuffer;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractHttpClientConnection
implements HttpClientConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private EntitySerializer entityserializer;
    private EntityDeserializer entitydeserializer;
    private SessionInputBuffer inbuffer;
    private SessionOutputBuffer outbuffer;
    private HttpMessageParser responseParser;
    private HttpMessageWriter requestWriter;
    private HttpConnectionMetricsImpl metrics;

    private void $$robo$$org_apache_http_impl_AbstractHttpClientConnection$__constructor__() {
        this.inbuffer = null;
        this.outbuffer = null;
        this.responseParser = null;
        this.requestWriter = null;
        this.metrics = null;
        this.entityserializer = this.createEntitySerializer();
        this.entitydeserializer = this.createEntityDeserializer();
    }

    protected abstract void assertOpen() throws IllegalStateException;

    private final EntityDeserializer $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    private final EntitySerializer $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    private final HttpResponseFactory $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createHttpResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    private final HttpMessageParser $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new HttpResponseParser(buffer, null, responseFactory, params);
    }

    private final HttpMessageWriter $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new HttpRequestWriter(buffer, null, params);
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpClientConnection$init(SessionInputBuffer inbuffer, SessionOutputBuffer outbuffer, HttpParams params) {
        if (inbuffer == null) {
            throw new IllegalArgumentException("Input session buffer may not be null");
        }
        if (outbuffer == null) {
            throw new IllegalArgumentException("Output session buffer may not be null");
        }
        this.inbuffer = inbuffer;
        this.outbuffer = outbuffer;
        this.responseParser = this.createResponseParser(inbuffer, this.createHttpResponseFactory(), params);
        this.requestWriter = this.createRequestWriter(outbuffer, params);
        this.metrics = new HttpConnectionMetricsImpl(inbuffer.getMetrics(), outbuffer.getMetrics());
    }

    private final boolean $$robo$$org_apache_http_impl_AbstractHttpClientConnection$isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        return this.inbuffer.isDataAvailable(timeout);
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpClientConnection$sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        this.requestWriter.write(request);
        this.metrics.incrementRequestCount();
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpClientConnection$sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, request, request.getEntity());
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpClientConnection$doFlush() throws IOException {
        this.outbuffer.flush();
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpClientConnection$flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    private final HttpResponse $$robo$$org_apache_http_impl_AbstractHttpClientConnection$receiveResponseHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpResponse response = (HttpResponse)this.responseParser.parse();
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
        return response;
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpClientConnection$receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.inbuffer, response);
        response.setEntity(entity);
    }

    private final boolean $$robo$$org_apache_http_impl_AbstractHttpClientConnection$isStale() {
        if (!this.isOpen()) {
            return true;
        }
        try {
            if (this.inbuffer instanceof SocketInputBuffer) {
                return ((SocketInputBuffer)this.inbuffer).isStale();
            }
            this.inbuffer.isDataAvailable(1);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private final HttpConnectionMetrics $$robo$$org_apache_http_impl_AbstractHttpClientConnection$getMetrics() {
        return this.metrics;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_AbstractHttpClientConnection$__constructor__();
    }

    public AbstractHttpClientConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$__constructor__(), 0, this);
    }

    protected EntityDeserializer createEntityDeserializer() {
        return InvokeDynamicSupport.bootstrap("createEntityDeserializer", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createEntityDeserializer(), 0, this);
    }

    protected EntitySerializer createEntitySerializer() {
        return InvokeDynamicSupport.bootstrap("createEntitySerializer", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createEntitySerializer(), 0, this);
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return InvokeDynamicSupport.bootstrap("createHttpResponseFactory", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createHttpResponseFactory(), 0, this);
    }

    protected HttpMessageParser createResponseParser(SessionInputBuffer sessionInputBuffer, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        return InvokeDynamicSupport.bootstrap("createResponseParser", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createResponseParser(org.apache.http.io.SessionInputBuffer org.apache.http.HttpResponseFactory org.apache.http.params.HttpParams ), 0, this, sessionInputBuffer, httpResponseFactory, httpParams);
    }

    protected HttpMessageWriter createRequestWriter(SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        return InvokeDynamicSupport.bootstrap("createRequestWriter", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$createRequestWriter(org.apache.http.io.SessionOutputBuffer org.apache.http.params.HttpParams ), 0, this, sessionOutputBuffer, httpParams);
    }

    protected void init(SessionInputBuffer sessionInputBuffer, SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$init(org.apache.http.io.SessionInputBuffer org.apache.http.io.SessionOutputBuffer org.apache.http.params.HttpParams ), 0, this, sessionInputBuffer, sessionOutputBuffer, httpParams);
    }

    @Override
    public boolean isResponseAvailable(int n) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isResponseAvailable", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$isResponseAvailable(int ), 0, this, n);
    }

    @Override
    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequestHeader", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$sendRequestHeader(org.apache.http.HttpRequest ), 0, this, httpRequest);
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequestEntity", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$sendRequestEntity(org.apache.http.HttpEntityEnclosingRequest ), 0, this, httpEntityEnclosingRequest);
    }

    protected void doFlush() throws IOException {
        InvokeDynamicSupport.bootstrap("doFlush", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$doFlush(), 0, this);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$flush(), 0, this);
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("receiveResponseHeader", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$receiveResponseHeader(), 0, this);
    }

    @Override
    public void receiveResponseEntity(HttpResponse httpResponse) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("receiveResponseEntity", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$receiveResponseEntity(org.apache.http.HttpResponse ), 0, this, httpResponse);
    }

    @Override
    public boolean isStale() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStale", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$isStale(), 0, this);
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$org_apache_http_impl_AbstractHttpClientConnection$getMetrics(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractHttpClientConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

