/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.impl.entity.EntityDeserializer;
import org.apache.http.impl.entity.EntitySerializer;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.HttpRequestParser;
import org.apache.http.impl.io.HttpResponseWriter;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractHttpServerConnection
implements HttpServerConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private EntitySerializer entityserializer;
    private EntityDeserializer entitydeserializer;
    private SessionInputBuffer inbuffer;
    private SessionOutputBuffer outbuffer;
    private HttpMessageParser requestParser;
    private HttpMessageWriter responseWriter;
    private HttpConnectionMetricsImpl metrics;

    private void $$robo$$org_apache_http_impl_AbstractHttpServerConnection$__constructor__() {
        this.inbuffer = null;
        this.outbuffer = null;
        this.requestParser = null;
        this.responseWriter = null;
        this.metrics = null;
        this.entityserializer = this.createEntitySerializer();
        this.entitydeserializer = this.createEntityDeserializer();
    }

    protected abstract void assertOpen() throws IllegalStateException;

    private final EntityDeserializer $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    private final EntitySerializer $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    private final HttpRequestFactory $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createHttpRequestFactory() {
        return new DefaultHttpRequestFactory();
    }

    private final HttpMessageParser $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createRequestParser(SessionInputBuffer buffer, HttpRequestFactory requestFactory, HttpParams params) {
        return new HttpRequestParser(buffer, null, requestFactory, params);
    }

    private final HttpMessageWriter $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createResponseWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new HttpResponseWriter(buffer, null, params);
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpServerConnection$init(SessionInputBuffer inbuffer, SessionOutputBuffer outbuffer, HttpParams params) {
        if (inbuffer == null) {
            throw new IllegalArgumentException("Input session buffer may not be null");
        }
        if (outbuffer == null) {
            throw new IllegalArgumentException("Output session buffer may not be null");
        }
        this.inbuffer = inbuffer;
        this.outbuffer = outbuffer;
        this.requestParser = this.createRequestParser(inbuffer, this.createHttpRequestFactory(), params);
        this.responseWriter = this.createResponseWriter(outbuffer, params);
        this.metrics = new HttpConnectionMetricsImpl(inbuffer.getMetrics(), outbuffer.getMetrics());
    }

    private final HttpRequest $$robo$$org_apache_http_impl_AbstractHttpServerConnection$receiveRequestHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpRequest request = (HttpRequest)this.requestParser.parse();
        this.metrics.incrementRequestCount();
        return request;
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpServerConnection$receiveRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.inbuffer, request);
        request.setEntity(entity);
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpServerConnection$doFlush() throws IOException {
        this.outbuffer.flush();
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpServerConnection$flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpServerConnection$sendResponseHeader(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertOpen();
        this.responseWriter.write(response);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
    }

    private final void $$robo$$org_apache_http_impl_AbstractHttpServerConnection$sendResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, response, response.getEntity());
    }

    private final boolean $$robo$$org_apache_http_impl_AbstractHttpServerConnection$isStale() {
        this.assertOpen();
        try {
            this.inbuffer.isDataAvailable(1);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    private final HttpConnectionMetrics $$robo$$org_apache_http_impl_AbstractHttpServerConnection$getMetrics() {
        return this.metrics;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_AbstractHttpServerConnection$__constructor__();
    }

    public AbstractHttpServerConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$__constructor__(), 0, this);
    }

    protected EntityDeserializer createEntityDeserializer() {
        return InvokeDynamicSupport.bootstrap("createEntityDeserializer", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createEntityDeserializer(), 0, this);
    }

    protected EntitySerializer createEntitySerializer() {
        return InvokeDynamicSupport.bootstrap("createEntitySerializer", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createEntitySerializer(), 0, this);
    }

    protected HttpRequestFactory createHttpRequestFactory() {
        return InvokeDynamicSupport.bootstrap("createHttpRequestFactory", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createHttpRequestFactory(), 0, this);
    }

    protected HttpMessageParser createRequestParser(SessionInputBuffer sessionInputBuffer, HttpRequestFactory httpRequestFactory, HttpParams httpParams) {
        return InvokeDynamicSupport.bootstrap("createRequestParser", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createRequestParser(org.apache.http.io.SessionInputBuffer org.apache.http.HttpRequestFactory org.apache.http.params.HttpParams ), 0, this, sessionInputBuffer, httpRequestFactory, httpParams);
    }

    protected HttpMessageWriter createResponseWriter(SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        return InvokeDynamicSupport.bootstrap("createResponseWriter", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$createResponseWriter(org.apache.http.io.SessionOutputBuffer org.apache.http.params.HttpParams ), 0, this, sessionOutputBuffer, httpParams);
    }

    protected void init(SessionInputBuffer sessionInputBuffer, SessionOutputBuffer sessionOutputBuffer, HttpParams httpParams) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$init(org.apache.http.io.SessionInputBuffer org.apache.http.io.SessionOutputBuffer org.apache.http.params.HttpParams ), 0, this, sessionInputBuffer, sessionOutputBuffer, httpParams);
    }

    @Override
    public HttpRequest receiveRequestHeader() throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("receiveRequestHeader", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$receiveRequestHeader(), 0, this);
    }

    @Override
    public void receiveRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("receiveRequestEntity", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$receiveRequestEntity(org.apache.http.HttpEntityEnclosingRequest ), 0, this, httpEntityEnclosingRequest);
    }

    protected void doFlush() throws IOException {
        InvokeDynamicSupport.bootstrap("doFlush", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$doFlush(), 0, this);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$flush(), 0, this);
    }

    @Override
    public void sendResponseHeader(HttpResponse httpResponse) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendResponseHeader", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$sendResponseHeader(org.apache.http.HttpResponse ), 0, this, httpResponse);
    }

    @Override
    public void sendResponseEntity(HttpResponse httpResponse) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendResponseEntity", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$sendResponseEntity(org.apache.http.HttpResponse ), 0, this, httpResponse);
    }

    @Override
    public boolean isStale() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStale", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$isStale(), 0, this);
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$org_apache_http_impl_AbstractHttpServerConnection$getMetrics(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractHttpServerConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

