/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.util.HashMap;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.io.HttpTransportMetrics;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HttpConnectionMetricsImpl
implements HttpConnectionMetrics,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String REQUEST_COUNT = "http.request-count";
    public static String RESPONSE_COUNT = "http.response-count";
    public static String SENT_BYTES_COUNT = "http.sent-bytes-count";
    public static String RECEIVED_BYTES_COUNT = "http.received-bytes-count";
    private HttpTransportMetrics inTransportMetric;
    private HttpTransportMetrics outTransportMetric;
    private long requestCount;
    private long responseCount;
    private HashMap metricsCache;

    private void $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$__constructor__(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        this.requestCount = 0L;
        this.responseCount = 0L;
        this.inTransportMetric = inTransportMetric;
        this.outTransportMetric = outTransportMetric;
    }

    private final long $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getReceivedBytesCount() {
        if (this.inTransportMetric != null) {
            return this.inTransportMetric.getBytesTransferred();
        }
        return -1L;
    }

    private final long $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getSentBytesCount() {
        if (this.outTransportMetric != null) {
            return this.outTransportMetric.getBytesTransferred();
        }
        return -1L;
    }

    private final long $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getRequestCount() {
        return this.requestCount;
    }

    private final void $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$incrementRequestCount() {
        ++this.requestCount;
    }

    private final long $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getResponseCount() {
        return this.responseCount;
    }

    private final void $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$incrementResponseCount() {
        ++this.responseCount;
    }

    private final Object $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getMetric(String metricName) {
        Long value = null;
        if (this.metricsCache != null) {
            value = (Long)this.metricsCache.get(metricName);
        }
        if (value == null) {
            if ("http.request-count".equals(metricName)) {
                value = new Long(this.requestCount);
            } else if ("http.response-count".equals(metricName)) {
                value = new Long(this.responseCount);
            } else {
                if ("http.received-bytes-count".equals(metricName)) {
                    if (this.inTransportMetric != null) {
                        return new Long(this.inTransportMetric.getBytesTransferred());
                    }
                    return null;
                }
                if ("http.sent-bytes-count".equals(metricName)) {
                    if (this.outTransportMetric != null) {
                        return new Long(this.outTransportMetric.getBytesTransferred());
                    }
                    return null;
                }
            }
        }
        return value;
    }

    private final void $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$setMetric(String metricName, Object obj) {
        if (this.metricsCache == null) {
            this.metricsCache = new HashMap();
        }
        this.metricsCache.put(metricName, obj);
    }

    private final void $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$reset() {
        if (this.outTransportMetric != null) {
            this.outTransportMetric.reset();
        }
        if (this.inTransportMetric != null) {
            this.inTransportMetric.reset();
        }
        this.requestCount = 0L;
        this.responseCount = 0L;
        this.metricsCache = null;
    }

    private void __constructor__(HttpTransportMetrics httpTransportMetrics, HttpTransportMetrics httpTransportMetrics2) {
        this.$$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$__constructor__(httpTransportMetrics, httpTransportMetrics2);
    }

    public HttpConnectionMetricsImpl(HttpTransportMetrics httpTransportMetrics, HttpTransportMetrics httpTransportMetrics2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$__constructor__(org.apache.http.io.HttpTransportMetrics org.apache.http.io.HttpTransportMetrics ), 0, this, httpTransportMetrics, httpTransportMetrics2);
    }

    @Override
    public long getReceivedBytesCount() {
        return (long)InvokeDynamicSupport.bootstrap("getReceivedBytesCount", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getReceivedBytesCount(), 0, this);
    }

    @Override
    public long getSentBytesCount() {
        return (long)InvokeDynamicSupport.bootstrap("getSentBytesCount", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getSentBytesCount(), 0, this);
    }

    @Override
    public long getRequestCount() {
        return (long)InvokeDynamicSupport.bootstrap("getRequestCount", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getRequestCount(), 0, this);
    }

    public void incrementRequestCount() {
        InvokeDynamicSupport.bootstrap("incrementRequestCount", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$incrementRequestCount(), 0, this);
    }

    @Override
    public long getResponseCount() {
        return (long)InvokeDynamicSupport.bootstrap("getResponseCount", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getResponseCount(), 0, this);
    }

    public void incrementResponseCount() {
        InvokeDynamicSupport.bootstrap("incrementResponseCount", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$incrementResponseCount(), 0, this);
    }

    @Override
    public Object getMetric(String string2) {
        return InvokeDynamicSupport.bootstrap("getMetric", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$getMetric(java.lang.String ), 0, this, string2);
    }

    public void setMetric(String string2, Object object) {
        InvokeDynamicSupport.bootstrap("setMetric", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$setMetric(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$org_apache_http_impl_HttpConnectionMetricsImpl$reset(), 0, this);
    }

    public /* synthetic */ HttpConnectionMetricsImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpConnectionMetricsImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

