/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.http.HttpInetConnection;
import org.apache.http.impl.AbstractHttpClientConnection;
import org.apache.http.impl.io.SocketInputBuffer;
import org.apache.http.impl.io.SocketOutputBuffer;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SocketHttpClientConnection
extends AbstractHttpClientConnection
implements HttpInetConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private volatile boolean open;
    private Socket socket;

    private void $$robo$$org_apache_http_impl_SocketHttpClientConnection$__constructor__() {
        this.socket = null;
    }

    private final void $$robo$$org_apache_http_impl_SocketHttpClientConnection$assertNotOpen() {
        if (this.open) {
            throw new IllegalStateException("Connection is already open");
        }
    }

    private final void $$robo$$org_apache_http_impl_SocketHttpClientConnection$assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("Connection is not open");
        }
    }

    private final SessionInputBuffer $$robo$$org_apache_http_impl_SocketHttpClientConnection$createSessionInputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        return new SocketInputBuffer(socket, buffersize, params);
    }

    private final SessionOutputBuffer $$robo$$org_apache_http_impl_SocketHttpClientConnection$createSessionOutputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        return new SocketOutputBuffer(socket, buffersize, params);
    }

    private final void $$robo$$org_apache_http_impl_SocketHttpClientConnection$bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.socket = socket;
        int buffersize = HttpConnectionParams.getSocketBufferSize(params);
        this.init(this.createSessionInputBuffer(socket, buffersize, params), this.createSessionOutputBuffer(socket, buffersize, params), params);
        this.open = true;
    }

    private final boolean $$robo$$org_apache_http_impl_SocketHttpClientConnection$isOpen() {
        return this.open;
    }

    private final Socket $$robo$$org_apache_http_impl_SocketHttpClientConnection$getSocket() {
        return this.socket;
    }

    private final InetAddress $$robo$$org_apache_http_impl_SocketHttpClientConnection$getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return null;
    }

    private final int $$robo$$org_apache_http_impl_SocketHttpClientConnection$getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }

    private final InetAddress $$robo$$org_apache_http_impl_SocketHttpClientConnection$getRemoteAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    private final int $$robo$$org_apache_http_impl_SocketHttpClientConnection$getRemotePort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    private final void $$robo$$org_apache_http_impl_SocketHttpClientConnection$setSocketTimeout(int timeout) {
        this.assertOpen();
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(timeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    private final int $$robo$$org_apache_http_impl_SocketHttpClientConnection$getSocketTimeout() {
        if (this.socket != null) {
            try {
                return this.socket.getSoTimeout();
            }
            catch (SocketException ignore) {
                return -1;
            }
        }
        return -1;
    }

    private final void $$robo$$org_apache_http_impl_SocketHttpClientConnection$shutdown() throws IOException {
        this.open = false;
        Socket tmpsocket = this.socket;
        if (tmpsocket != null) {
            tmpsocket.close();
        }
    }

    private final void $$robo$$org_apache_http_impl_SocketHttpClientConnection$close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.doFlush();
        try {
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.socket.close();
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_SocketHttpClientConnection$__constructor__();
    }

    public SocketHttpClientConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_SocketHttpClientConnection$__constructor__(), 0, this);
    }

    protected void assertNotOpen() {
        InvokeDynamicSupport.bootstrap("assertNotOpen", $$robo$$org_apache_http_impl_SocketHttpClientConnection$assertNotOpen(), 0, this);
    }

    @Override
    protected void assertOpen() {
        InvokeDynamicSupport.bootstrap("assertOpen", $$robo$$org_apache_http_impl_SocketHttpClientConnection$assertOpen(), 0, this);
    }

    protected SessionInputBuffer createSessionInputBuffer(Socket socket, int n, HttpParams httpParams) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSessionInputBuffer", $$robo$$org_apache_http_impl_SocketHttpClientConnection$createSessionInputBuffer(java.net.Socket int org.apache.http.params.HttpParams ), 0, this, socket, n, httpParams);
    }

    protected SessionOutputBuffer createSessionOutputBuffer(Socket socket, int n, HttpParams httpParams) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSessionOutputBuffer", $$robo$$org_apache_http_impl_SocketHttpClientConnection$createSessionOutputBuffer(java.net.Socket int org.apache.http.params.HttpParams ), 0, this, socket, n, httpParams);
    }

    protected void bind(Socket socket, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("bind", $$robo$$org_apache_http_impl_SocketHttpClientConnection$bind(java.net.Socket org.apache.http.params.HttpParams ), 0, this, socket, httpParams);
    }

    @Override
    public boolean isOpen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$org_apache_http_impl_SocketHttpClientConnection$isOpen(), 0, this);
    }

    protected Socket getSocket() {
        return InvokeDynamicSupport.bootstrap("getSocket", $$robo$$org_apache_http_impl_SocketHttpClientConnection$getSocket(), 0, this);
    }

    @Override
    public InetAddress getLocalAddress() {
        return InvokeDynamicSupport.bootstrap("getLocalAddress", $$robo$$org_apache_http_impl_SocketHttpClientConnection$getLocalAddress(), 0, this);
    }

    @Override
    public int getLocalPort() {
        return (int)InvokeDynamicSupport.bootstrap("getLocalPort", $$robo$$org_apache_http_impl_SocketHttpClientConnection$getLocalPort(), 0, this);
    }

    @Override
    public InetAddress getRemoteAddress() {
        return InvokeDynamicSupport.bootstrap("getRemoteAddress", $$robo$$org_apache_http_impl_SocketHttpClientConnection$getRemoteAddress(), 0, this);
    }

    @Override
    public int getRemotePort() {
        return (int)InvokeDynamicSupport.bootstrap("getRemotePort", $$robo$$org_apache_http_impl_SocketHttpClientConnection$getRemotePort(), 0, this);
    }

    @Override
    public void setSocketTimeout(int n) {
        InvokeDynamicSupport.bootstrap("setSocketTimeout", $$robo$$org_apache_http_impl_SocketHttpClientConnection$setSocketTimeout(int ), 0, this, n);
    }

    @Override
    public int getSocketTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getSocketTimeout", $$robo$$org_apache_http_impl_SocketHttpClientConnection$getSocketTimeout(), 0, this);
    }

    @Override
    public void shutdown() throws IOException {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$org_apache_http_impl_SocketHttpClientConnection$shutdown(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_impl_SocketHttpClientConnection$close(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SocketHttpClientConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

