/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicScheme
extends RFC2617Scheme
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private boolean complete;

    private void $$robo$$org_apache_http_impl_auth_BasicScheme$__constructor__() {
        this.complete = false;
    }

    private final String $$robo$$org_apache_http_impl_auth_BasicScheme$getSchemeName() {
        return "basic";
    }

    private final void $$robo$$org_apache_http_impl_auth_BasicScheme$processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    private final boolean $$robo$$org_apache_http_impl_auth_BasicScheme$isComplete() {
        return this.complete;
    }

    private final boolean $$robo$$org_apache_http_impl_auth_BasicScheme$isConnectionBased() {
        return false;
    }

    private final Header $$robo$$org_apache_http_impl_auth_BasicScheme$authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String charset = AuthParams.getCredentialCharset(request.getParams());
        return BasicScheme.authenticate(credentials, charset, this.isProxy());
    }

    private static final Header $$robo$$org_apache_http_impl_auth_BasicScheme$authenticate(Credentials credentials, String charset, boolean proxy) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset may not be null");
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = Base64.encodeBase64(EncodingUtils.getBytes(tmp.toString(), charset));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (proxy) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_auth_BasicScheme$__constructor__();
    }

    public BasicScheme() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_auth_BasicScheme$__constructor__(), 0, this);
    }

    @Override
    public String getSchemeName() {
        return InvokeDynamicSupport.bootstrap("getSchemeName", $$robo$$org_apache_http_impl_auth_BasicScheme$getSchemeName(), 0, this);
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        InvokeDynamicSupport.bootstrap("processChallenge", $$robo$$org_apache_http_impl_auth_BasicScheme$processChallenge(org.apache.http.Header ), 0, this, header);
    }

    @Override
    public boolean isComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isComplete", $$robo$$org_apache_http_impl_auth_BasicScheme$isComplete(), 0, this);
    }

    @Override
    public boolean isConnectionBased() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectionBased", $$robo$$org_apache_http_impl_auth_BasicScheme$isConnectionBased(), 0, this);
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        return InvokeDynamicSupport.bootstrap("authenticate", $$robo$$org_apache_http_impl_auth_BasicScheme$authenticate(org.apache.http.auth.Credentials org.apache.http.HttpRequest ), 0, this, credentials, httpRequest);
    }

    public static Header authenticate(Credentials credentials, String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("authenticate", $$robo$$org_apache_http_impl_auth_BasicScheme$authenticate(org.apache.http.auth.Credentials java.lang.String boolean ), 0, (Credentials)credentials, (String)string2, (boolean)bl);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicScheme)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

