/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.auth.UnsupportedDigestAlgorithmException;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DigestScheme
extends RFC2617Scheme
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static char[] HEXADECIMAL;
    private boolean complete;
    private static String NC = "00000001";
    private static int QOP_MISSING = 0;
    private static int QOP_AUTH_INT = 1;
    private static int QOP_AUTH = 2;
    private int qopVariant;
    private String cnonce;

    private void $$robo$$org_apache_http_impl_auth_DigestScheme$__constructor__() {
        this.qopVariant = 0;
        this.complete = false;
    }

    private final void $$robo$$org_apache_http_impl_auth_DigestScheme$processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        if (this.getParameter("realm") == null) {
            throw new MalformedChallengeException("missing realm in challange");
        }
        if (this.getParameter("nonce") == null) {
            throw new MalformedChallengeException("missing nonce in challange");
        }
        boolean unsupportedQop = false;
        String qop = this.getParameter("qop");
        if (qop != null) {
            StringTokenizer tok = new StringTokenizer(qop, ",");
            while (tok.hasMoreTokens()) {
                String variant = tok.nextToken().trim();
                if (variant.equals("auth")) {
                    this.qopVariant = 2;
                    break;
                }
                if (variant.equals("auth-int")) {
                    this.qopVariant = 1;
                    continue;
                }
                unsupportedQop = true;
            }
        }
        if (unsupportedQop && this.qopVariant == 0) {
            throw new MalformedChallengeException("None of the qop methods is supported");
        }
        this.cnonce = null;
        this.complete = true;
    }

    private final boolean $$robo$$org_apache_http_impl_auth_DigestScheme$isComplete() {
        String s = this.getParameter("stale");
        if ("true".equalsIgnoreCase(s)) {
            return false;
        }
        return this.complete;
    }

    private final String $$robo$$org_apache_http_impl_auth_DigestScheme$getSchemeName() {
        return "digest";
    }

    private final boolean $$robo$$org_apache_http_impl_auth_DigestScheme$isConnectionBased() {
        return false;
    }

    private final void $$robo$$org_apache_http_impl_auth_DigestScheme$overrideParamter(String name, String value) {
        this.getParameters().put(name, value);
    }

    private final String $$robo$$org_apache_http_impl_auth_DigestScheme$getCnonce() {
        if (this.cnonce == null) {
            this.cnonce = DigestScheme.createCnonce();
        }
        return this.cnonce;
    }

    private final Header $$robo$$org_apache_http_impl_auth_DigestScheme$authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.getParameters().put("methodname", request.getRequestLine().getMethod());
        this.getParameters().put("uri", request.getRequestLine().getUri());
        String charset = this.getParameter("charset");
        if (charset == null) {
            charset = AuthParams.getCredentialCharset(request.getParams());
            this.getParameters().put("charset", charset);
        }
        String digest = this.createDigest(credentials);
        return this.createDigestHeader(credentials, digest);
    }

    private static final MessageDigest $$robo$$org_apache_http_impl_auth_DigestScheme$createMessageDigest(String digAlg) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(digAlg);
        }
        catch (Exception e) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + digAlg);
        }
    }

    private final String $$robo$$org_apache_http_impl_auth_DigestScheme$createDigest(Credentials credentials) throws AuthenticationException {
        String serverDigestValue;
        String charset;
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String method = this.getParameter("methodname");
        String algorithm = this.getParameter("algorithm");
        if (uri == null) {
            throw new IllegalStateException("URI may not be null");
        }
        if (realm == null) {
            throw new IllegalStateException("Realm may not be null");
        }
        if (nonce == null) {
            throw new IllegalStateException("Nonce may not be null");
        }
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((charset = this.getParameter("charset")) == null) {
            charset = "ISO-8859-1";
        }
        if (this.qopVariant == 1) {
            throw new AuthenticationException("Unsupported qop in HTTP Digest authentication");
        }
        MessageDigest md5Helper = DigestScheme.createMessageDigest("MD5");
        String uname = credentials.getUserPrincipal().getName();
        String pwd = credentials.getPassword();
        StringBuilder tmp = new StringBuilder(uname.length() + realm.length() + pwd.length() + 2);
        tmp.append(uname);
        tmp.append(':');
        tmp.append(realm);
        tmp.append(':');
        tmp.append(pwd);
        String a1 = tmp.toString();
        if (algorithm.equalsIgnoreCase("MD5-sess")) {
            String cnonce = this.getCnonce();
            String tmp2 = DigestScheme.encode(md5Helper.digest(EncodingUtils.getBytes(a1, charset)));
            StringBuilder tmp3 = new StringBuilder(tmp2.length() + nonce.length() + cnonce.length() + 2);
            tmp3.append(tmp2);
            tmp3.append(':');
            tmp3.append(nonce);
            tmp3.append(':');
            tmp3.append(cnonce);
            a1 = tmp3.toString();
        } else if (!algorithm.equalsIgnoreCase("MD5")) {
            throw new AuthenticationException("Unhandled algorithm " + algorithm + " requested");
        }
        String md5a1 = DigestScheme.encode(md5Helper.digest(EncodingUtils.getBytes(a1, charset)));
        String a2 = null;
        if (this.qopVariant != 1) {
            a2 = method + ':' + uri;
        }
        String md5a2 = DigestScheme.encode(md5Helper.digest(EncodingUtils.getAsciiBytes(a2)));
        if (this.qopVariant == 0) {
            StringBuilder tmp2 = new StringBuilder(md5a1.length() + nonce.length() + md5a2.length());
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(md5a2);
            serverDigestValue = tmp2.toString();
        } else {
            String qopOption = this.getQopVariantString();
            String cnonce = this.getCnonce();
            StringBuilder tmp2 = new StringBuilder(md5a1.length() + nonce.length() + "00000001".length() + cnonce.length() + qopOption.length() + md5a2.length() + 5);
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append("00000001");
            tmp2.append(':');
            tmp2.append(cnonce);
            tmp2.append(':');
            tmp2.append(qopOption);
            tmp2.append(':');
            tmp2.append(md5a2);
            serverDigestValue = tmp2.toString();
        }
        String serverDigest = DigestScheme.encode(md5Helper.digest(EncodingUtils.getAsciiBytes(serverDigestValue)));
        return serverDigest;
    }

    private final Header $$robo$$org_apache_http_impl_auth_DigestScheme$createDigestHeader(Credentials credentials, String digest) throws AuthenticationException {
        CharArrayBuffer buffer = new CharArrayBuffer(128);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Digest ");
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String opaque = this.getParameter("opaque");
        String response = digest;
        String algorithm = this.getParameter("algorithm");
        String uname = credentials.getUserPrincipal().getName();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(20);
        params.add(new BasicNameValuePair("username", uname));
        params.add(new BasicNameValuePair("realm", realm));
        params.add(new BasicNameValuePair("nonce", nonce));
        params.add(new BasicNameValuePair("uri", uri));
        params.add(new BasicNameValuePair("response", response));
        if (this.qopVariant != 0) {
            params.add(new BasicNameValuePair("qop", this.getQopVariantString()));
            params.add(new BasicNameValuePair("nc", "00000001"));
            params.add(new BasicNameValuePair("cnonce", this.getCnonce()));
        }
        if (algorithm != null) {
            params.add(new BasicNameValuePair("algorithm", algorithm));
        }
        if (opaque != null) {
            params.add(new BasicNameValuePair("opaque", opaque));
        }
        for (int i = 0; i < params.size(); ++i) {
            BasicNameValuePair param = (BasicNameValuePair)params.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            boolean noQuotes = "nc".equals(param.getName()) || "qop".equals(param.getName());
            BasicHeaderValueFormatter.DEFAULT.formatNameValuePair(buffer, param, !noQuotes);
        }
        return new BufferedHeader(buffer);
    }

    private final String $$robo$$org_apache_http_impl_auth_DigestScheme$getQopVariantString() {
        String qopOption = this.qopVariant == 1 ? "auth-int" : "auth";
        return qopOption;
    }

    private static final String $$robo$$org_apache_http_impl_auth_DigestScheme$encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    private static final String $$robo$$org_apache_http_impl_auth_DigestScheme$createCnonce() {
        MessageDigest md5Helper = DigestScheme.createMessageDigest("MD5");
        String cnonce = Long.toString((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        cnonce = DigestScheme.encode(md5Helper.digest(EncodingUtils.getAsciiBytes(cnonce)));
        return cnonce;
    }

    static void __staticInitializer__() {
        HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_auth_DigestScheme$__constructor__();
    }

    public DigestScheme() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_auth_DigestScheme$__constructor__(), 0, this);
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        InvokeDynamicSupport.bootstrap("processChallenge", $$robo$$org_apache_http_impl_auth_DigestScheme$processChallenge(org.apache.http.Header ), 0, this, header);
    }

    @Override
    public boolean isComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isComplete", $$robo$$org_apache_http_impl_auth_DigestScheme$isComplete(), 0, this);
    }

    @Override
    public String getSchemeName() {
        return InvokeDynamicSupport.bootstrap("getSchemeName", $$robo$$org_apache_http_impl_auth_DigestScheme$getSchemeName(), 0, this);
    }

    @Override
    public boolean isConnectionBased() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectionBased", $$robo$$org_apache_http_impl_auth_DigestScheme$isConnectionBased(), 0, this);
    }

    public void overrideParamter(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("overrideParamter", $$robo$$org_apache_http_impl_auth_DigestScheme$overrideParamter(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private String getCnonce() {
        return InvokeDynamicSupport.bootstrap("getCnonce", $$robo$$org_apache_http_impl_auth_DigestScheme$getCnonce(), 0, this);
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        return InvokeDynamicSupport.bootstrap("authenticate", $$robo$$org_apache_http_impl_auth_DigestScheme$authenticate(org.apache.http.auth.Credentials org.apache.http.HttpRequest ), 0, this, credentials, httpRequest);
    }

    private static MessageDigest createMessageDigest(String string2) throws UnsupportedDigestAlgorithmException {
        return InvokeDynamicSupport.bootstrapStatic("createMessageDigest", $$robo$$org_apache_http_impl_auth_DigestScheme$createMessageDigest(java.lang.String ), 0, (String)string2);
    }

    private String createDigest(Credentials credentials) throws AuthenticationException {
        return InvokeDynamicSupport.bootstrap("createDigest", $$robo$$org_apache_http_impl_auth_DigestScheme$createDigest(org.apache.http.auth.Credentials ), 0, this, credentials);
    }

    private Header createDigestHeader(Credentials credentials, String string2) throws AuthenticationException {
        return InvokeDynamicSupport.bootstrap("createDigestHeader", $$robo$$org_apache_http_impl_auth_DigestScheme$createDigestHeader(org.apache.http.auth.Credentials java.lang.String ), 0, this, credentials, string2);
    }

    private String getQopVariantString() {
        return InvokeDynamicSupport.bootstrap("getQopVariantString", $$robo$$org_apache_http_impl_auth_DigestScheme$getQopVariantString(), 0, this);
    }

    private static String encode(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$org_apache_http_impl_auth_DigestScheme$encode(byte[] ), 0, (byte[])byArray);
    }

    public static String createCnonce() {
        return InvokeDynamicSupport.bootstrapStatic("createCnonce", $$robo$$org_apache_http_impl_auth_DigestScheme$createCnonce(), 0);
    }

    static {
        RobolectricInternals.classInitializing(DigestScheme.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DigestScheme)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

