/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import com.google.errorprone.annotations.DoNotMock;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NTLMScheme
extends AuthSchemeBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private NTLMEngine engine;
    private State state;
    private String challenge;

    private void $$robo$$org_apache_http_impl_auth_NTLMScheme$__constructor__(NTLMEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("NTLM engine may not be null");
        }
        this.engine = engine;
        this.state = State.UNINITIATED;
        this.challenge = null;
    }

    private final String $$robo$$org_apache_http_impl_auth_NTLMScheme$getSchemeName() {
        return "ntlm";
    }

    private final String $$robo$$org_apache_http_impl_auth_NTLMScheme$getParameter(String name) {
        return null;
    }

    private final String $$robo$$org_apache_http_impl_auth_NTLMScheme$getRealm() {
        return null;
    }

    private final boolean $$robo$$org_apache_http_impl_auth_NTLMScheme$isConnectionBased() {
        return true;
    }

    private final void $$robo$$org_apache_http_impl_auth_NTLMScheme$parseChallenge(CharArrayBuffer buffer, int pos, int len) throws MalformedChallengeException {
        String challenge = buffer.substringTrimmed(pos, len);
        if (challenge.length() == 0) {
            this.state = this.state == State.UNINITIATED ? State.CHALLENGE_RECEIVED : State.FAILED;
            this.challenge = null;
        } else {
            this.state = State.MSG_TYPE2_RECEVIED;
            this.challenge = challenge;
        }
    }

    private final Header $$robo$$org_apache_http_impl_auth_NTLMScheme$authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        String response = null;
        if (this.state == State.CHALLENGE_RECEIVED || this.state == State.FAILED) {
            response = this.engine.generateType1Msg(ntcredentials.getDomain(), ntcredentials.getWorkstation());
            this.state = State.MSG_TYPE1_GENERATED;
        } else if (this.state == State.MSG_TYPE2_RECEVIED) {
            response = this.engine.generateType3Msg(ntcredentials.getUserName(), ntcredentials.getPassword(), ntcredentials.getDomain(), ntcredentials.getWorkstation(), this.challenge);
            this.state = State.MSG_TYPE3_GENERATED;
        } else {
            throw new AuthenticationException("Unexpected state: " + (Object)((Object)this.state));
        }
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": NTLM ");
        buffer.append(response);
        return new BufferedHeader(buffer);
    }

    private final boolean $$robo$$org_apache_http_impl_auth_NTLMScheme$isComplete() {
        return this.state == State.MSG_TYPE3_GENERATED || this.state == State.FAILED;
    }

    private void __constructor__(NTLMEngine nTLMEngine) {
        this.$$robo$$org_apache_http_impl_auth_NTLMScheme$__constructor__(nTLMEngine);
    }

    public NTLMScheme(NTLMEngine nTLMEngine) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_auth_NTLMScheme$__constructor__(org.apache.http.impl.auth.NTLMEngine ), 0, this, nTLMEngine);
    }

    @Override
    public String getSchemeName() {
        return InvokeDynamicSupport.bootstrap("getSchemeName", $$robo$$org_apache_http_impl_auth_NTLMScheme$getSchemeName(), 0, this);
    }

    @Override
    public String getParameter(String string2) {
        return InvokeDynamicSupport.bootstrap("getParameter", $$robo$$org_apache_http_impl_auth_NTLMScheme$getParameter(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getRealm() {
        return InvokeDynamicSupport.bootstrap("getRealm", $$robo$$org_apache_http_impl_auth_NTLMScheme$getRealm(), 0, this);
    }

    @Override
    public boolean isConnectionBased() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectionBased", $$robo$$org_apache_http_impl_auth_NTLMScheme$isConnectionBased(), 0, this);
    }

    @Override
    protected void parseChallenge(CharArrayBuffer charArrayBuffer, int n, int n2) throws MalformedChallengeException {
        InvokeDynamicSupport.bootstrap("parseChallenge", $$robo$$org_apache_http_impl_auth_NTLMScheme$parseChallenge(org.apache.http.util.CharArrayBuffer int int ), 0, this, charArrayBuffer, n, n2);
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        return InvokeDynamicSupport.bootstrap("authenticate", $$robo$$org_apache_http_impl_auth_NTLMScheme$authenticate(org.apache.http.auth.Credentials org.apache.http.HttpRequest ), 0, this, credentials, httpRequest);
    }

    @Override
    public boolean isComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isComplete", $$robo$$org_apache_http_impl_auth_NTLMScheme$isComplete(), 0, this);
    }

    public /* synthetic */ NTLMScheme() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NTLMScheme)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    extends Enum<State> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ State UNINITIATED;
        public static /* enum */ State CHALLENGE_RECEIVED;
        public static /* enum */ State MSG_TYPE1_GENERATED;
        public static /* enum */ State MSG_TYPE2_RECEVIED;
        public static /* enum */ State MSG_TYPE3_GENERATED;
        public static /* enum */ State FAILED;
        private static /* synthetic */ State[] $VALUES;

        private static final State[] $$robo$$org_apache_http_impl_auth_NTLMScheme_State$values() {
            return (State[])$VALUES.clone();
        }

        private static final State $$robo$$org_apache_http_impl_auth_NTLMScheme_State$valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$org_apache_http_impl_auth_NTLMScheme_State$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            UNINITIATED = new State();
            CHALLENGE_RECEIVED = new State();
            MSG_TYPE1_GENERATED = new State();
            MSG_TYPE2_RECEVIED = new State();
            MSG_TYPE3_GENERATED = new State();
            FAILED = new State();
            $VALUES = new State[]{UNINITIATED, CHALLENGE_RECEIVED, MSG_TYPE1_GENERATED, MSG_TYPE2_RECEVIED, MSG_TYPE3_GENERATED, FAILED};
        }

        public static State[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$org_apache_http_impl_auth_NTLMScheme_State$values(), 0);
        }

        public static State valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$org_apache_http_impl_auth_NTLMScheme_State$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$org_apache_http_impl_auth_NTLMScheme_State$__constructor__(string2, n);
        }

        private State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_auth_NTLMScheme_State$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

