/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    private static List<String> DEFAULT_SCHEME_PRIORITY;

    private void $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$__constructor__() {
        this.log = LogFactory.getLog(this.getClass());
    }

    private final Map<String, Header> $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$parseChallenges(Header[] headers) throws MalformedChallengeException {
        HashMap<String, Header> map = new HashMap<String, Header>(headers.length);
        for (Header header : headers) {
            int pos;
            CharArrayBuffer buffer;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s = buffer.substring(beginIndex, endIndex);
            map.put(s.toLowerCase(Locale.ENGLISH), header);
        }
        return map;
    }

    private final List<String> $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$getAuthPreferences() {
        return DEFAULT_SCHEME_PRIORITY;
    }

    private final AuthScheme $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$selectScheme(Map<String, Header> challenges, HttpResponse response, HttpContext context) throws AuthenticationException {
        AuthSchemeRegistry registry = (AuthSchemeRegistry)context.getAttribute("http.authscheme-registry");
        if (registry == null) {
            throw new IllegalStateException("AuthScheme registry not set in HTTP context");
        }
        List<String> authPrefs = (List<String>)context.getAttribute("http.auth.scheme-pref");
        if (authPrefs == null) {
            authPrefs = this.getAuthPreferences();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication schemes in the order of preference: " + authPrefs);
        }
        AuthScheme authScheme = null;
        for (int i = 0; i < authPrefs.size(); ++i) {
            String id2 = authPrefs.get(i);
            Header challenge = challenges.get(id2.toLowerCase(Locale.ENGLISH));
            if (challenge != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(id2 + " authentication scheme selected");
                }
                try {
                    authScheme = registry.getAuthScheme(id2, response.getParams());
                    break;
                }
                catch (IllegalStateException e) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Authentication scheme " + id2 + " not supported");
                    continue;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Challenge for " + id2 + " authentication scheme not available");
        }
        if (authScheme == null) {
            throw new AuthenticationException("Unable to respond to any of these challenges: " + challenges);
        }
        return authScheme;
    }

    static void __staticInitializer__() {
        DEFAULT_SCHEME_PRIORITY = Arrays.asList("ntlm", "digest", "basic");
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$__constructor__();
    }

    public AbstractAuthenticationHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$__constructor__(), 0, this);
    }

    protected Map<String, Header> parseChallenges(Header[] headerArray) throws MalformedChallengeException {
        return InvokeDynamicSupport.bootstrap("parseChallenges", $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$parseChallenges(org.apache.http.Header[] ), 0, this, headerArray);
    }

    protected List<String> getAuthPreferences() {
        return InvokeDynamicSupport.bootstrap("getAuthPreferences", $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$getAuthPreferences(), 0, this);
    }

    @Override
    public AuthScheme selectScheme(Map<String, Header> map, HttpResponse httpResponse, HttpContext httpContext) throws AuthenticationException {
        return InvokeDynamicSupport.bootstrap("selectScheme", $$robo$$org_apache_http_impl_client_AbstractAuthenticationHandler$selectScheme(java.util.Map<java.lang.String, org.apache.http.Header> org.apache.http.HttpResponse org.apache.http.protocol.HttpContext ), 0, this, map, httpResponse, httpContext);
    }

    static {
        RobolectricInternals.classInitializing(AbstractAuthenticationHandler.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractAuthenticationHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

