/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.ClientParamsStack;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.DefaultedHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractHttpClient
implements HttpClient,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    private HttpParams defaultParams;
    private HttpRequestExecutor requestExec;
    private ClientConnectionManager connManager;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private CookieSpecRegistry supportedCookieSpecs;
    private AuthSchemeRegistry supportedAuthSchemes;
    private BasicHttpProcessor httpProcessor;
    private HttpRequestRetryHandler retryHandler;
    private RedirectHandler redirectHandler;
    private AuthenticationHandler targetAuthHandler;
    private AuthenticationHandler proxyAuthHandler;
    private CookieStore cookieStore;
    private CredentialsProvider credsProvider;
    private HttpRoutePlanner routePlanner;
    private UserTokenHandler userTokenHandler;

    private void $$robo$$org_apache_http_impl_client_AbstractHttpClient$__constructor__(ClientConnectionManager conman, HttpParams params) {
        this.log = LogFactory.getLog(this.getClass());
        this.defaultParams = params;
        this.connManager = conman;
    }

    protected abstract HttpParams createHttpParams();

    protected abstract HttpContext createHttpContext();

    protected abstract HttpRequestExecutor createRequestExecutor();

    protected abstract ClientConnectionManager createClientConnectionManager();

    protected abstract AuthSchemeRegistry createAuthSchemeRegistry();

    protected abstract CookieSpecRegistry createCookieSpecRegistry();

    protected abstract ConnectionReuseStrategy createConnectionReuseStrategy();

    protected abstract ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy();

    protected abstract BasicHttpProcessor createHttpProcessor();

    protected abstract HttpRequestRetryHandler createHttpRequestRetryHandler();

    protected abstract RedirectHandler createRedirectHandler();

    protected abstract AuthenticationHandler createTargetAuthenticationHandler();

    protected abstract AuthenticationHandler createProxyAuthenticationHandler();

    protected abstract CookieStore createCookieStore();

    protected abstract CredentialsProvider createCredentialsProvider();

    protected abstract HttpRoutePlanner createHttpRoutePlanner();

    protected abstract UserTokenHandler createUserTokenHandler();

    private final synchronized HttpParams $$robo$$org_apache_http_impl_client_AbstractHttpClient$getParams() {
        if (this.defaultParams == null) {
            this.defaultParams = this.createHttpParams();
        }
        return this.defaultParams;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setParams(HttpParams params) {
        this.defaultParams = params;
    }

    private final synchronized ClientConnectionManager $$robo$$org_apache_http_impl_client_AbstractHttpClient$getConnectionManager() {
        if (this.connManager == null) {
            this.connManager = this.createClientConnectionManager();
        }
        return this.connManager;
    }

    private final synchronized HttpRequestExecutor $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRequestExecutor() {
        if (this.requestExec == null) {
            this.requestExec = this.createRequestExecutor();
        }
        return this.requestExec;
    }

    private final synchronized AuthSchemeRegistry $$robo$$org_apache_http_impl_client_AbstractHttpClient$getAuthSchemes() {
        if (this.supportedAuthSchemes == null) {
            this.supportedAuthSchemes = this.createAuthSchemeRegistry();
        }
        return this.supportedAuthSchemes;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setAuthSchemes(AuthSchemeRegistry authSchemeRegistry) {
        this.supportedAuthSchemes = authSchemeRegistry;
    }

    private final synchronized CookieSpecRegistry $$robo$$org_apache_http_impl_client_AbstractHttpClient$getCookieSpecs() {
        if (this.supportedCookieSpecs == null) {
            this.supportedCookieSpecs = this.createCookieSpecRegistry();
        }
        return this.supportedCookieSpecs;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setCookieSpecs(CookieSpecRegistry cookieSpecRegistry) {
        this.supportedCookieSpecs = cookieSpecRegistry;
    }

    private final synchronized ConnectionReuseStrategy $$robo$$org_apache_http_impl_client_AbstractHttpClient$getConnectionReuseStrategy() {
        if (this.reuseStrategy == null) {
            this.reuseStrategy = this.createConnectionReuseStrategy();
        }
        return this.reuseStrategy;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
    }

    private final synchronized ConnectionKeepAliveStrategy $$robo$$org_apache_http_impl_client_AbstractHttpClient$getConnectionKeepAliveStrategy() {
        if (this.keepAliveStrategy == null) {
            this.keepAliveStrategy = this.createConnectionKeepAliveStrategy();
        }
        return this.keepAliveStrategy;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setKeepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.keepAliveStrategy = keepAliveStrategy;
    }

    private final synchronized HttpRequestRetryHandler $$robo$$org_apache_http_impl_client_AbstractHttpClient$getHttpRequestRetryHandler() {
        if (this.retryHandler == null) {
            this.retryHandler = this.createHttpRequestRetryHandler();
        }
        return this.retryHandler;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setHttpRequestRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    private final synchronized RedirectHandler $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRedirectHandler() {
        if (this.redirectHandler == null) {
            this.redirectHandler = this.createRedirectHandler();
        }
        return this.redirectHandler;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setRedirectHandler(RedirectHandler redirectHandler) {
        this.redirectHandler = redirectHandler;
    }

    private final synchronized AuthenticationHandler $$robo$$org_apache_http_impl_client_AbstractHttpClient$getTargetAuthenticationHandler() {
        if (this.targetAuthHandler == null) {
            this.targetAuthHandler = this.createTargetAuthenticationHandler();
        }
        return this.targetAuthHandler;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setTargetAuthenticationHandler(AuthenticationHandler targetAuthHandler) {
        this.targetAuthHandler = targetAuthHandler;
    }

    private final synchronized AuthenticationHandler $$robo$$org_apache_http_impl_client_AbstractHttpClient$getProxyAuthenticationHandler() {
        if (this.proxyAuthHandler == null) {
            this.proxyAuthHandler = this.createProxyAuthenticationHandler();
        }
        return this.proxyAuthHandler;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setProxyAuthenticationHandler(AuthenticationHandler proxyAuthHandler) {
        this.proxyAuthHandler = proxyAuthHandler;
    }

    private final synchronized CookieStore $$robo$$org_apache_http_impl_client_AbstractHttpClient$getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = this.createCookieStore();
        }
        return this.cookieStore;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    private final synchronized CredentialsProvider $$robo$$org_apache_http_impl_client_AbstractHttpClient$getCredentialsProvider() {
        if (this.credsProvider == null) {
            this.credsProvider = this.createCredentialsProvider();
        }
        return this.credsProvider;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setCredentialsProvider(CredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
    }

    private final synchronized HttpRoutePlanner $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRoutePlanner() {
        if (this.routePlanner == null) {
            this.routePlanner = this.createHttpRoutePlanner();
        }
        return this.routePlanner;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setRoutePlanner(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
    }

    private final synchronized UserTokenHandler $$robo$$org_apache_http_impl_client_AbstractHttpClient$getUserTokenHandler() {
        if (this.userTokenHandler == null) {
            this.userTokenHandler = this.createUserTokenHandler();
        }
        return this.userTokenHandler;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$setUserTokenHandler(UserTokenHandler userTokenHandler) {
        this.userTokenHandler = userTokenHandler;
    }

    private final synchronized BasicHttpProcessor $$robo$$org_apache_http_impl_client_AbstractHttpClient$getHttpProcessor() {
        if (this.httpProcessor == null) {
            this.httpProcessor = this.createHttpProcessor();
        }
        return this.httpProcessor;
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$addResponseInterceptor(HttpResponseInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$addResponseInterceptor(HttpResponseInterceptor itcp, int index) {
        this.getHttpProcessor().addInterceptor(itcp, index);
    }

    private final synchronized HttpResponseInterceptor $$robo$$org_apache_http_impl_client_AbstractHttpClient$getResponseInterceptor(int index) {
        return this.getHttpProcessor().getResponseInterceptor(index);
    }

    private final synchronized int $$robo$$org_apache_http_impl_client_AbstractHttpClient$getResponseInterceptorCount() {
        return this.getHttpProcessor().getResponseInterceptorCount();
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$clearResponseInterceptors() {
        this.getHttpProcessor().clearResponseInterceptors();
    }

    private final void $$robo$$org_apache_http_impl_client_AbstractHttpClient$removeResponseInterceptorByClass(Class<? extends HttpResponseInterceptor> clazz) {
        this.getHttpProcessor().removeResponseInterceptorByClass(clazz);
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$addRequestInterceptor(HttpRequestInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$addRequestInterceptor(HttpRequestInterceptor itcp, int index) {
        this.getHttpProcessor().addInterceptor(itcp, index);
    }

    private final synchronized HttpRequestInterceptor $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRequestInterceptor(int index) {
        return this.getHttpProcessor().getRequestInterceptor(index);
    }

    private final synchronized int $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRequestInterceptorCount() {
        return this.getHttpProcessor().getRequestInterceptorCount();
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_AbstractHttpClient$clearRequestInterceptors() {
        this.getHttpProcessor().clearRequestInterceptors();
    }

    private final void $$robo$$org_apache_http_impl_client_AbstractHttpClient$removeRequestInterceptorByClass(Class<? extends HttpRequestInterceptor> clazz) {
        this.getHttpProcessor().removeRequestInterceptorByClass(clazz);
    }

    private final HttpResponse $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.execute(request, (HttpContext)null);
    }

    private final HttpResponse $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        return this.execute(this.determineTarget(request), (HttpRequest)request, context);
    }

    private final HttpHost $$robo$$org_apache_http_impl_client_AbstractHttpClient$determineTarget(HttpUriRequest request) {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute()) {
            target = new HttpHost(requestURI.getHost(), requestURI.getPort(), requestURI.getScheme());
        }
        return target;
    }

    private final HttpResponse $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.execute(target, request, (HttpContext)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpResponse $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        HttpContext execContext = null;
        RequestDirector director = null;
        AbstractHttpClient abstractHttpClient = this;
        synchronized (abstractHttpClient) {
            HttpContext defaultContext = this.createHttpContext();
            execContext = context == null ? defaultContext : new DefaultedHttpContext(context, defaultContext);
            director = this.createClientRequestDirector(this.getRequestExecutor(), this.getConnectionManager(), this.getConnectionReuseStrategy(), this.getConnectionKeepAliveStrategy(), this.getRoutePlanner(), this.getHttpProcessor().copy(), this.getHttpRequestRetryHandler(), this.getRedirectHandler(), this.getTargetAuthenticationHandler(), this.getProxyAuthenticationHandler(), this.getUserTokenHandler(), this.determineParams(request));
        }
        try {
            return director.execute(target, request, execContext);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    private final RequestDirector $$robo$$org_apache_http_impl_client_AbstractHttpClient$createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler stateHandler, HttpParams params) {
        return new DefaultRequestDirector(requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, stateHandler, params);
    }

    private final HttpParams $$robo$$org_apache_http_impl_client_AbstractHttpClient$determineParams(HttpRequest req) {
        return new ClientParamsStack(null, this.getParams(), req.getParams(), null);
    }

    private final <T> T $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(request, responseHandler, null);
    }

    private final <T> T $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        HttpHost target = this.determineTarget(request);
        return this.execute(target, request, responseHandler, context);
    }

    private final <T> T $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(target, request, responseHandler, null);
    }

    private final <T> T $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        T result;
        if (responseHandler == null) {
            throw new IllegalArgumentException("Response handler must not be null.");
        }
        HttpResponse response = this.execute(target, request, context);
        try {
            result = responseHandler.handleResponse(response);
        }
        catch (Throwable t) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (Throwable t2) {
                    this.log.warn("Error consuming content after an exception.", t2);
                }
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            entity.consumeContent();
        }
        return result;
    }

    private void __constructor__(ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
        this.$$robo$$org_apache_http_impl_client_AbstractHttpClient$__constructor__(clientConnectionManager, httpParams);
    }

    protected AbstractHttpClient(ClientConnectionManager clientConnectionManager, HttpParams httpParams) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_client_AbstractHttpClient$__constructor__(org.apache.http.conn.ClientConnectionManager org.apache.http.params.HttpParams ), 0, this, clientConnectionManager, httpParams);
    }

    @Override
    public synchronized HttpParams getParams() {
        return InvokeDynamicSupport.bootstrap("getParams", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getParams(), 0, this);
    }

    public synchronized void setParams(HttpParams httpParams) {
        InvokeDynamicSupport.bootstrap("setParams", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setParams(org.apache.http.params.HttpParams ), 0, this, httpParams);
    }

    @Override
    public synchronized ClientConnectionManager getConnectionManager() {
        return InvokeDynamicSupport.bootstrap("getConnectionManager", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getConnectionManager(), 0, this);
    }

    public synchronized HttpRequestExecutor getRequestExecutor() {
        return InvokeDynamicSupport.bootstrap("getRequestExecutor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRequestExecutor(), 0, this);
    }

    public synchronized AuthSchemeRegistry getAuthSchemes() {
        return InvokeDynamicSupport.bootstrap("getAuthSchemes", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getAuthSchemes(), 0, this);
    }

    public synchronized void setAuthSchemes(AuthSchemeRegistry authSchemeRegistry) {
        InvokeDynamicSupport.bootstrap("setAuthSchemes", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setAuthSchemes(org.apache.http.auth.AuthSchemeRegistry ), 0, this, authSchemeRegistry);
    }

    public synchronized CookieSpecRegistry getCookieSpecs() {
        return InvokeDynamicSupport.bootstrap("getCookieSpecs", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getCookieSpecs(), 0, this);
    }

    public synchronized void setCookieSpecs(CookieSpecRegistry cookieSpecRegistry) {
        InvokeDynamicSupport.bootstrap("setCookieSpecs", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setCookieSpecs(org.apache.http.cookie.CookieSpecRegistry ), 0, this, cookieSpecRegistry);
    }

    public synchronized ConnectionReuseStrategy getConnectionReuseStrategy() {
        return InvokeDynamicSupport.bootstrap("getConnectionReuseStrategy", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getConnectionReuseStrategy(), 0, this);
    }

    public synchronized void setReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        InvokeDynamicSupport.bootstrap("setReuseStrategy", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setReuseStrategy(org.apache.http.ConnectionReuseStrategy ), 0, this, connectionReuseStrategy);
    }

    public synchronized ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        return InvokeDynamicSupport.bootstrap("getConnectionKeepAliveStrategy", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getConnectionKeepAliveStrategy(), 0, this);
    }

    public synchronized void setKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        InvokeDynamicSupport.bootstrap("setKeepAliveStrategy", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setKeepAliveStrategy(org.apache.http.conn.ConnectionKeepAliveStrategy ), 0, this, connectionKeepAliveStrategy);
    }

    public synchronized HttpRequestRetryHandler getHttpRequestRetryHandler() {
        return InvokeDynamicSupport.bootstrap("getHttpRequestRetryHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getHttpRequestRetryHandler(), 0, this);
    }

    public synchronized void setHttpRequestRetryHandler(HttpRequestRetryHandler httpRequestRetryHandler) {
        InvokeDynamicSupport.bootstrap("setHttpRequestRetryHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setHttpRequestRetryHandler(org.apache.http.client.HttpRequestRetryHandler ), 0, this, httpRequestRetryHandler);
    }

    public synchronized RedirectHandler getRedirectHandler() {
        return InvokeDynamicSupport.bootstrap("getRedirectHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRedirectHandler(), 0, this);
    }

    public synchronized void setRedirectHandler(RedirectHandler redirectHandler) {
        InvokeDynamicSupport.bootstrap("setRedirectHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setRedirectHandler(org.apache.http.client.RedirectHandler ), 0, this, redirectHandler);
    }

    public synchronized AuthenticationHandler getTargetAuthenticationHandler() {
        return InvokeDynamicSupport.bootstrap("getTargetAuthenticationHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getTargetAuthenticationHandler(), 0, this);
    }

    public synchronized void setTargetAuthenticationHandler(AuthenticationHandler authenticationHandler) {
        InvokeDynamicSupport.bootstrap("setTargetAuthenticationHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setTargetAuthenticationHandler(org.apache.http.client.AuthenticationHandler ), 0, this, authenticationHandler);
    }

    public synchronized AuthenticationHandler getProxyAuthenticationHandler() {
        return InvokeDynamicSupport.bootstrap("getProxyAuthenticationHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getProxyAuthenticationHandler(), 0, this);
    }

    public synchronized void setProxyAuthenticationHandler(AuthenticationHandler authenticationHandler) {
        InvokeDynamicSupport.bootstrap("setProxyAuthenticationHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setProxyAuthenticationHandler(org.apache.http.client.AuthenticationHandler ), 0, this, authenticationHandler);
    }

    public synchronized CookieStore getCookieStore() {
        return InvokeDynamicSupport.bootstrap("getCookieStore", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getCookieStore(), 0, this);
    }

    public synchronized void setCookieStore(CookieStore cookieStore) {
        InvokeDynamicSupport.bootstrap("setCookieStore", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setCookieStore(org.apache.http.client.CookieStore ), 0, this, cookieStore);
    }

    public synchronized CredentialsProvider getCredentialsProvider() {
        return InvokeDynamicSupport.bootstrap("getCredentialsProvider", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getCredentialsProvider(), 0, this);
    }

    public synchronized void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        InvokeDynamicSupport.bootstrap("setCredentialsProvider", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setCredentialsProvider(org.apache.http.client.CredentialsProvider ), 0, this, credentialsProvider);
    }

    public synchronized HttpRoutePlanner getRoutePlanner() {
        return InvokeDynamicSupport.bootstrap("getRoutePlanner", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRoutePlanner(), 0, this);
    }

    public synchronized void setRoutePlanner(HttpRoutePlanner httpRoutePlanner) {
        InvokeDynamicSupport.bootstrap("setRoutePlanner", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setRoutePlanner(org.apache.http.conn.routing.HttpRoutePlanner ), 0, this, httpRoutePlanner);
    }

    public synchronized UserTokenHandler getUserTokenHandler() {
        return InvokeDynamicSupport.bootstrap("getUserTokenHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getUserTokenHandler(), 0, this);
    }

    public synchronized void setUserTokenHandler(UserTokenHandler userTokenHandler) {
        InvokeDynamicSupport.bootstrap("setUserTokenHandler", $$robo$$org_apache_http_impl_client_AbstractHttpClient$setUserTokenHandler(org.apache.http.client.UserTokenHandler ), 0, this, userTokenHandler);
    }

    protected synchronized BasicHttpProcessor getHttpProcessor() {
        return InvokeDynamicSupport.bootstrap("getHttpProcessor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getHttpProcessor(), 0, this);
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        InvokeDynamicSupport.bootstrap("addResponseInterceptor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$addResponseInterceptor(org.apache.http.HttpResponseInterceptor ), 0, this, httpResponseInterceptor);
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor, int n) {
        InvokeDynamicSupport.bootstrap("addResponseInterceptor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$addResponseInterceptor(org.apache.http.HttpResponseInterceptor int ), 0, this, httpResponseInterceptor, n);
    }

    public synchronized HttpResponseInterceptor getResponseInterceptor(int n) {
        return InvokeDynamicSupport.bootstrap("getResponseInterceptor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getResponseInterceptor(int ), 0, this, n);
    }

    public synchronized int getResponseInterceptorCount() {
        return (int)InvokeDynamicSupport.bootstrap("getResponseInterceptorCount", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getResponseInterceptorCount(), 0, this);
    }

    public synchronized void clearResponseInterceptors() {
        InvokeDynamicSupport.bootstrap("clearResponseInterceptors", $$robo$$org_apache_http_impl_client_AbstractHttpClient$clearResponseInterceptors(), 0, this);
    }

    public void removeResponseInterceptorByClass(Class<? extends HttpResponseInterceptor> clazz) {
        InvokeDynamicSupport.bootstrap("removeResponseInterceptorByClass", $$robo$$org_apache_http_impl_client_AbstractHttpClient$removeResponseInterceptorByClass(java.lang.Class<? extends org.apache.http.HttpResponseInterceptor> ), 0, this, clazz);
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        InvokeDynamicSupport.bootstrap("addRequestInterceptor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$addRequestInterceptor(org.apache.http.HttpRequestInterceptor ), 0, this, httpRequestInterceptor);
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor, int n) {
        InvokeDynamicSupport.bootstrap("addRequestInterceptor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$addRequestInterceptor(org.apache.http.HttpRequestInterceptor int ), 0, this, httpRequestInterceptor, n);
    }

    public synchronized HttpRequestInterceptor getRequestInterceptor(int n) {
        return InvokeDynamicSupport.bootstrap("getRequestInterceptor", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRequestInterceptor(int ), 0, this, n);
    }

    public synchronized int getRequestInterceptorCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRequestInterceptorCount", $$robo$$org_apache_http_impl_client_AbstractHttpClient$getRequestInterceptorCount(), 0, this);
    }

    public synchronized void clearRequestInterceptors() {
        InvokeDynamicSupport.bootstrap("clearRequestInterceptors", $$robo$$org_apache_http_impl_client_AbstractHttpClient$clearRequestInterceptors(), 0, this);
    }

    public void removeRequestInterceptorByClass(Class<? extends HttpRequestInterceptor> clazz) {
        InvokeDynamicSupport.bootstrap("removeRequestInterceptorByClass", $$robo$$org_apache_http_impl_client_AbstractHttpClient$removeRequestInterceptorByClass(java.lang.Class<? extends org.apache.http.HttpRequestInterceptor> ), 0, this, clazz);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException, ClientProtocolException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.client.methods.HttpUriRequest ), 0, this, httpUriRequest);
    }

    @Override
    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.client.methods.HttpUriRequest org.apache.http.protocol.HttpContext ), 0, this, httpUriRequest, httpContext);
    }

    private HttpHost determineTarget(HttpUriRequest httpUriRequest) {
        return InvokeDynamicSupport.bootstrap("determineTarget", $$robo$$org_apache_http_impl_client_AbstractHttpClient$determineTarget(org.apache.http.client.methods.HttpUriRequest ), 0, this, httpUriRequest);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException, ClientProtocolException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest ), 0, this, httpHost, httpRequest);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, httpContext);
    }

    protected RequestDirector createClientRequestDirector(HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectHandler redirectHandler, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        return InvokeDynamicSupport.bootstrap("createClientRequestDirector", $$robo$$org_apache_http_impl_client_AbstractHttpClient$createClientRequestDirector(org.apache.http.protocol.HttpRequestExecutor org.apache.http.conn.ClientConnectionManager org.apache.http.ConnectionReuseStrategy org.apache.http.conn.ConnectionKeepAliveStrategy org.apache.http.conn.routing.HttpRoutePlanner org.apache.http.protocol.HttpProcessor org.apache.http.client.HttpRequestRetryHandler org.apache.http.client.RedirectHandler org.apache.http.client.AuthenticationHandler org.apache.http.client.AuthenticationHandler org.apache.http.client.UserTokenHandler org.apache.http.params.HttpParams ), 0, this, httpRequestExecutor, clientConnectionManager, connectionReuseStrategy, connectionKeepAliveStrategy, httpRoutePlanner, httpProcessor, httpRequestRetryHandler, redirectHandler, authenticationHandler, authenticationHandler2, userTokenHandler, httpParams);
    }

    protected HttpParams determineParams(HttpRequest httpRequest) {
        return InvokeDynamicSupport.bootstrap("determineParams", $$robo$$org_apache_http_impl_client_AbstractHttpClient$determineParams(org.apache.http.HttpRequest ), 0, this, httpRequest);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.client.methods.HttpUriRequest org.apache.http.client.ResponseHandler<? extends T> ), 0, this, httpUriRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.client.methods.HttpUriRequest org.apache.http.client.ResponseHandler<? extends T> org.apache.http.protocol.HttpContext ), 0, this, httpUriRequest, responseHandler, httpContext);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.client.ResponseHandler<? extends T> ), 0, this, httpHost, httpRequest, responseHandler);
    }

    @Override
    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return (T)InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_AbstractHttpClient$execute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.client.ResponseHandler<? extends T> org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, responseHandler, httpContext);
    }

    public /* synthetic */ AbstractHttpClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractHttpClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

