/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BasicCookieStore
implements CookieStore,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ArrayList<Cookie> cookies;
    private Comparator<Cookie> cookieComparator;

    private void $$robo$$org_apache_http_impl_client_BasicCookieStore$__constructor__() {
        this.cookies = new ArrayList();
        this.cookieComparator = new CookieIdentityComparator();
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_BasicCookieStore$addCookie(Cookie cookie) {
        if (cookie != null) {
            Iterator<Cookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                if (this.cookieComparator.compare(cookie, it.next()) != 0) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired(new Date())) {
                this.cookies.add(cookie);
            }
        }
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_BasicCookieStore$addCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cooky : cookies) {
                this.addCookie(cooky);
            }
        }
    }

    private final synchronized List<Cookie> $$robo$$org_apache_http_impl_client_BasicCookieStore$getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    private final synchronized boolean $$robo$$org_apache_http_impl_client_BasicCookieStore$clearExpired(Date date) {
        if (date == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Cookie> it = this.cookies.iterator();
        while (it.hasNext()) {
            if (!it.next().isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    private final String $$robo$$org_apache_http_impl_client_BasicCookieStore$toString() {
        return this.cookies.toString();
    }

    private final synchronized void $$robo$$org_apache_http_impl_client_BasicCookieStore$clear() {
        this.cookies.clear();
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_client_BasicCookieStore$__constructor__();
    }

    public BasicCookieStore() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_client_BasicCookieStore$__constructor__(), 0, this);
    }

    @Override
    public synchronized void addCookie(Cookie cookie) {
        InvokeDynamicSupport.bootstrap("addCookie", $$robo$$org_apache_http_impl_client_BasicCookieStore$addCookie(org.apache.http.cookie.Cookie ), 0, this, cookie);
    }

    public synchronized void addCookies(Cookie[] cookieArray) {
        InvokeDynamicSupport.bootstrap("addCookies", $$robo$$org_apache_http_impl_client_BasicCookieStore$addCookies(org.apache.http.cookie.Cookie[] ), 0, this, cookieArray);
    }

    @Override
    public synchronized List<Cookie> getCookies() {
        return InvokeDynamicSupport.bootstrap("getCookies", $$robo$$org_apache_http_impl_client_BasicCookieStore$getCookies(), 0, this);
    }

    @Override
    public synchronized boolean clearExpired(Date date) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearExpired", $$robo$$org_apache_http_impl_client_BasicCookieStore$clearExpired(java.util.Date ), 0, this, date);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$org_apache_http_impl_client_BasicCookieStore$toString(), 0, this);
    }

    @Override
    public synchronized void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$org_apache_http_impl_client_BasicCookieStore$clear(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicCookieStore)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

