/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.BasicManagedEntity;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.RoutedRequest;
import org.apache.http.impl.client.TunnelRefusedException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DefaultRequestDirector
implements RequestDirector,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    protected ClientConnectionManager connManager;
    protected HttpRoutePlanner routePlanner;
    protected ConnectionReuseStrategy reuseStrategy;
    protected ConnectionKeepAliveStrategy keepAliveStrategy;
    protected HttpRequestExecutor requestExec;
    protected HttpProcessor httpProcessor;
    protected HttpRequestRetryHandler retryHandler;
    protected RedirectHandler redirectHandler;
    private AuthenticationHandler targetAuthHandler;
    private AuthenticationHandler proxyAuthHandler;
    private UserTokenHandler userTokenHandler;
    protected HttpParams params;
    protected ManagedClientConnection managedConn;
    private int redirectCount;
    private int maxRedirects;
    private AuthState targetAuthState;
    private AuthState proxyAuthState;

    private void $$robo$$org_apache_http_impl_client_DefaultRequestDirector$__constructor__(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        this.log = LogFactory.getLog(this.getClass());
        if (requestExec == null) {
            throw new IllegalArgumentException("Request executor may not be null.");
        }
        if (conman == null) {
            throw new IllegalArgumentException("Client connection manager may not be null.");
        }
        if (reustrat == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null.");
        }
        if (kastrat == null) {
            throw new IllegalArgumentException("Connection keep alive strategy may not be null.");
        }
        if (rouplan == null) {
            throw new IllegalArgumentException("Route planner may not be null.");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP protocol processor may not be null.");
        }
        if (retryHandler == null) {
            throw new IllegalArgumentException("HTTP request retry handler may not be null.");
        }
        if (redirectHandler == null) {
            throw new IllegalArgumentException("Redirect handler may not be null.");
        }
        if (targetAuthHandler == null) {
            throw new IllegalArgumentException("Target authentication handler may not be null.");
        }
        if (proxyAuthHandler == null) {
            throw new IllegalArgumentException("Proxy authentication handler may not be null.");
        }
        if (userTokenHandler == null) {
            throw new IllegalArgumentException("User token handler may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.requestExec = requestExec;
        this.connManager = conman;
        this.reuseStrategy = reustrat;
        this.keepAliveStrategy = kastrat;
        this.routePlanner = rouplan;
        this.httpProcessor = httpProcessor;
        this.retryHandler = retryHandler;
        this.redirectHandler = redirectHandler;
        this.targetAuthHandler = targetAuthHandler;
        this.proxyAuthHandler = proxyAuthHandler;
        this.userTokenHandler = userTokenHandler;
        this.params = params;
        this.managedConn = null;
        this.redirectCount = 0;
        this.maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
    }

    private final RequestWrapper $$robo$$org_apache_http_impl_client_DefaultRequestDirector$wrapRequest(HttpRequest request) throws ProtocolException {
        if (request instanceof HttpEntityEnclosingRequest) {
            return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
        }
        return new RequestWrapper(request);
    }

    private final void $$robo$$org_apache_http_impl_client_DefaultRequestDirector$rewriteRequestURI(RequestWrapper request, HttpRoute route) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (route.getProxyHost() != null && !route.isTunnelled()) {
                if (!uri.isAbsolute()) {
                    HttpHost target = route.getTargetHost();
                    uri = URIUtils.rewriteURI(uri, target);
                    request.setURI(uri);
                }
            } else if (uri.isAbsolute()) {
                uri = URIUtils.rewriteURI(uri, null);
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), ex);
        }
    }

    private final HttpResponse $$robo$$org_apache_http_impl_client_DefaultRequestDirector$execute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpRequest orig = request;
        RequestWrapper origWrapper = this.wrapRequest(orig);
        origWrapper.setParams(this.params);
        HttpRoute origRoute = this.determineRoute(target, origWrapper, context);
        RoutedRequest roureq = new RoutedRequest(origWrapper, origRoute);
        long timeout = ConnManagerParams.getTimeout(this.params);
        int execCount = 0;
        boolean reuse = false;
        HttpResponse response = null;
        boolean done = false;
        try {
            while (!done) {
                RoutedRequest followup;
                RequestWrapper wrapper = roureq.getRequest();
                HttpRoute route = roureq.getRoute();
                Object userToken = context.getAttribute("http.user-token");
                if (this.managedConn == null) {
                    ClientConnectionRequest connRequest = this.connManager.requestConnection(route, userToken);
                    if (orig instanceof AbortableHttpRequest) {
                        ((AbortableHttpRequest)((Object)orig)).setConnectionRequest(connRequest);
                    }
                    try {
                        this.managedConn = connRequest.getConnection(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interrupted) {
                        InterruptedIOException iox = new InterruptedIOException();
                        iox.initCause(interrupted);
                        throw iox;
                    }
                    if (HttpConnectionParams.isStaleCheckingEnabled(this.params)) {
                        this.log.debug("Stale connection check");
                        if (this.managedConn.isStale()) {
                            this.log.debug("Stale connection detected");
                            try {
                                this.managedConn.close();
                            }
                            catch (IOException interrupted) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (orig instanceof AbortableHttpRequest) {
                    ((AbortableHttpRequest)((Object)orig)).setReleaseTrigger(this.managedConn);
                }
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(route, context, this.params);
                } else {
                    this.managedConn.setSocketTimeout(HttpConnectionParams.getSoTimeout(this.params));
                }
                try {
                    this.establishRoute(route, context);
                }
                catch (TunnelRefusedException ex) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ex.getMessage());
                    }
                    response = ex.getResponse();
                    break;
                }
                wrapper.resetHeaders();
                this.rewriteRequestURI(wrapper, route);
                target = (HttpHost)wrapper.getParams().getParameter("http.virtual-host");
                if (target == null) {
                    target = route.getTargetHost();
                }
                HttpHost proxy = route.getProxyHost();
                context.setAttribute("http.target_host", target);
                context.setAttribute("http.proxy_host", proxy);
                context.setAttribute("http.connection", this.managedConn);
                context.setAttribute("http.auth.target-scope", this.targetAuthState);
                context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
                this.requestExec.preProcess(wrapper, this.httpProcessor, context);
                context.setAttribute("http.request", wrapper);
                boolean retrying = true;
                while (retrying) {
                    ++execCount;
                    wrapper.incrementExecCount();
                    if (wrapper.getExecCount() > 1 && !wrapper.isRepeatable()) {
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity");
                    }
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Attempt " + execCount + " to execute request");
                        }
                        response = this.requestExec.execute(wrapper, this.managedConn, context);
                        retrying = false;
                    }
                    catch (IOException ex) {
                        this.log.debug("Closing the connection.");
                        this.managedConn.close();
                        if (this.retryHandler.retryRequest(ex, execCount, context)) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("I/O exception (" + ex.getClass().getName() + ") caught when processing request: " + ex.getMessage());
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(ex.getMessage(), ex);
                            }
                        } else {
                            throw ex;
                        }
                        this.log.info("Retrying request");
                        if (route.getHopCount() == 1) {
                            this.log.debug("Reopening the direct connection.");
                            this.managedConn.open(route, context, this.params);
                            continue;
                        }
                        throw ex;
                    }
                }
                response.setParams(this.params);
                this.requestExec.postProcess(response, this.httpProcessor, context);
                reuse = this.reuseStrategy.keepAlive(response, context);
                if (reuse) {
                    long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                    this.managedConn.setIdleDuration(duration, TimeUnit.MILLISECONDS);
                }
                if ((followup = this.handleResponse(roureq, response, context)) == null) {
                    done = true;
                } else {
                    if (reuse) {
                        this.log.debug("Connection kept alive");
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            entity.consumeContent();
                        }
                        this.managedConn.markReusable();
                    } else {
                        this.managedConn.close();
                    }
                    if (!followup.getRoute().equals(roureq.getRoute())) {
                        this.releaseConnection();
                    }
                    roureq = followup;
                }
                userToken = this.userTokenHandler.getUserToken(context);
                context.setAttribute("http.user-token", userToken);
                if (this.managedConn == null) continue;
                this.managedConn.setState(userToken);
            }
            if (response == null || response.getEntity() == null || !response.getEntity().isStreaming()) {
                if (reuse) {
                    this.managedConn.markReusable();
                }
                this.releaseConnection();
            } else {
                HttpEntity entity = response.getEntity();
                entity = new BasicManagedEntity(entity, this.managedConn, reuse);
                response.setEntity(entity);
            }
            return response;
        }
        catch (HttpException ex) {
            this.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            this.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.abortConnection();
            throw ex;
        }
    }

    private final void $$robo$$org_apache_http_impl_client_DefaultRequestDirector$releaseConnection() {
        try {
            this.managedConn.releaseConnection();
        }
        catch (IOException ignored) {
            this.log.debug("IOException releasing connection", ignored);
        }
        this.managedConn = null;
    }

    private final HttpRoute $$robo$$org_apache_http_impl_client_DefaultRequestDirector$determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (target == null) {
            target = (HttpHost)request.getParams().getParameter("http.default-host");
        }
        if (target == null) {
            URI uri;
            String scheme = null;
            String host = null;
            String path = null;
            if (request instanceof HttpUriRequest && (uri = ((HttpUriRequest)request).getURI()) != null) {
                scheme = uri.getScheme();
                host = uri.getHost();
                path = uri.getPath();
            }
            throw new IllegalStateException("Target host must not be null, or set in parameters. scheme=" + scheme + ", host=" + host + ", path=" + path);
        }
        return this.routePlanner.determineRoute(target, request, context);
    }

    private final void $$robo$$org_apache_http_impl_client_DefaultRequestDirector$establishRoute(HttpRoute route, HttpContext context) throws HttpException, IOException {
        int step;
        BasicRouteDirector rowdy = new BasicRouteDirector();
        do {
            HttpRoute fact = this.managedConn.getRoute();
            step = rowdy.nextStep(route, fact);
            switch (step) {
                case 1: 
                case 2: {
                    this.managedConn.open(route, context, this.params);
                    break;
                }
                case 3: {
                    boolean secure = this.createTunnelToTarget(route, context);
                    this.log.debug("Tunnel to target created.");
                    this.managedConn.tunnelTarget(secure, this.params);
                    break;
                }
                case 4: {
                    int hop = fact.getHopCount() - 1;
                    boolean secure = this.createTunnelToProxy(route, hop, context);
                    this.log.debug("Tunnel to proxy created.");
                    this.managedConn.tunnelProxy(route.getHopTarget(hop), secure, this.params);
                    break;
                }
                case 5: {
                    this.managedConn.layerProtocol(context, this.params);
                    break;
                }
                case -1: {
                    throw new IllegalStateException("Unable to establish route.\nplanned = " + route + "\ncurrent = " + fact);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                }
            }
        } while (step > 0);
    }

    private final boolean $$robo$$org_apache_http_impl_client_DefaultRequestDirector$createTunnelToTarget(HttpRoute route, HttpContext context) throws HttpException, IOException {
        int status;
        HttpHost proxy = route.getProxyHost();
        HttpHost target = route.getTargetHost();
        HttpResponse response = null;
        boolean done = false;
        while (!done) {
            int status2;
            HttpRequest connect;
            block13: {
                done = true;
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(route, context, this.params);
                }
                connect = this.createConnectRequest(route, context);
                String agent = HttpProtocolParams.getUserAgent(this.params);
                if (agent != null) {
                    connect.addHeader("User-Agent", agent);
                }
                connect.addHeader("Host", target.toHostString());
                AuthScheme authScheme = this.proxyAuthState.getAuthScheme();
                AuthScope authScope = this.proxyAuthState.getAuthScope();
                Credentials creds = this.proxyAuthState.getCredentials();
                if (!(creds == null || authScope == null && authScheme.isConnectionBased())) {
                    try {
                        connect.addHeader(authScheme.authenticate(creds, connect));
                    }
                    catch (AuthenticationException ex) {
                        if (!this.log.isErrorEnabled()) break block13;
                        this.log.error("Proxy authentication error: " + ex.getMessage());
                    }
                }
            }
            if ((status2 = (response = this.requestExec.execute(connect, this.managedConn, context)).getStatusLine().getStatusCode()) < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            if (credsProvider == null || !HttpClientParams.isAuthenticating(this.params)) continue;
            if (this.proxyAuthHandler.isAuthenticationRequested(response, context)) {
                block14: {
                    this.log.debug("Proxy requested authentication");
                    Map<String, Header> challenges = this.proxyAuthHandler.getChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.proxyAuthState, this.proxyAuthHandler, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!this.log.isWarnEnabled()) break block14;
                        this.log.warn("Authentication error: " + ex.getMessage());
                        break;
                    }
                }
                this.updateAuthState(this.proxyAuthState, proxy, credsProvider);
                if (this.proxyAuthState.getCredentials() == null) continue;
                done = false;
                if (this.reuseStrategy.keepAlive(response, context)) {
                    this.log.debug("Connection kept alive");
                    HttpEntity entity = response.getEntity();
                    if (entity == null) continue;
                    entity.consumeContent();
                    continue;
                }
                this.managedConn.close();
                continue;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        if ((status = response.getStatusLine().getStatusCode()) > 299) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            this.managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        this.managedConn.markReusable();
        return false;
    }

    private final boolean $$robo$$org_apache_http_impl_client_DefaultRequestDirector$createTunnelToProxy(HttpRoute route, int hop, HttpContext context) throws HttpException, IOException {
        throw new UnsupportedOperationException("Proxy chains are not supported.");
    }

    private final HttpRequest $$robo$$org_apache_http_impl_client_DefaultRequestDirector$createConnectRequest(HttpRoute route, HttpContext context) {
        HttpHost target = route.getTargetHost();
        String host = target.getHostName();
        int port = target.getPort();
        if (port < 0) {
            Scheme scheme = this.connManager.getSchemeRegistry().getScheme(target.getSchemeName());
            port = scheme.getDefaultPort();
        }
        StringBuilder buffer = new StringBuilder(host.length() + 6);
        buffer.append(host);
        buffer.append(':');
        buffer.append(Integer.toString(port));
        String authority = buffer.toString();
        ProtocolVersion ver = HttpProtocolParams.getVersion(this.params);
        BasicHttpRequest req = new BasicHttpRequest("CONNECT", authority, ver);
        return req;
    }

    private final RoutedRequest $$robo$$org_apache_http_impl_client_DefaultRequestDirector$handleResponse(RoutedRequest roureq, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRoute route = roureq.getRoute();
        HttpHost proxy = route.getProxyHost();
        RequestWrapper request = roureq.getRequest();
        HttpParams params = request.getParams();
        if (HttpClientParams.isRedirecting(params) && this.redirectHandler.isRedirectRequested(response, context)) {
            if (this.redirectCount >= this.maxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.maxRedirects + ") exceeded");
            }
            ++this.redirectCount;
            URI uri = this.redirectHandler.getLocationURI(response, context);
            HttpHost newTarget = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            HttpGet redirect = new HttpGet(uri);
            HttpRequest orig = request.getOriginal();
            redirect.setHeaders(orig.getAllHeaders());
            RequestWrapper wrapper = new RequestWrapper(redirect);
            wrapper.setParams(params);
            HttpRoute newRoute = this.determineRoute(newTarget, wrapper, context);
            RoutedRequest newRequest = new RoutedRequest(wrapper, newRoute);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Redirecting to '" + uri + "' via " + newRoute);
            }
            return newRequest;
        }
        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (credsProvider != null && HttpClientParams.isAuthenticating(params)) {
            if (this.targetAuthHandler.isAuthenticationRequested(response, context)) {
                HttpHost target;
                block13: {
                    target = (HttpHost)context.getAttribute("http.target_host");
                    if (target == null) {
                        target = route.getTargetHost();
                    }
                    this.log.debug("Target requested authentication");
                    Map<String, Header> challenges = this.targetAuthHandler.getChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.targetAuthState, this.targetAuthHandler, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!this.log.isWarnEnabled()) break block13;
                        this.log.warn("Authentication error: " + ex.getMessage());
                        return null;
                    }
                }
                this.updateAuthState(this.targetAuthState, target, credsProvider);
                if (this.targetAuthState.getCredentials() != null) {
                    return roureq;
                }
                return null;
            }
            this.targetAuthState.setAuthScope(null);
            if (this.proxyAuthHandler.isAuthenticationRequested(response, context)) {
                block14: {
                    this.log.debug("Proxy requested authentication");
                    Map<String, Header> challenges = this.proxyAuthHandler.getChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.proxyAuthState, this.proxyAuthHandler, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!this.log.isWarnEnabled()) break block14;
                        this.log.warn("Authentication error: " + ex.getMessage());
                        return null;
                    }
                }
                this.updateAuthState(this.proxyAuthState, proxy, credsProvider);
                if (this.proxyAuthState.getCredentials() != null) {
                    return roureq;
                }
                return null;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        return null;
    }

    private final void $$robo$$org_apache_http_impl_client_DefaultRequestDirector$abortConnection() {
        ManagedClientConnection mcc = this.managedConn;
        if (mcc != null) {
            block5: {
                this.managedConn = null;
                try {
                    mcc.abortConnection();
                }
                catch (IOException ex) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug(ex.getMessage(), ex);
                }
            }
            try {
                mcc.releaseConnection();
            }
            catch (IOException ignored) {
                this.log.debug("Error releasing connection", ignored);
            }
        }
    }

    private final void $$robo$$org_apache_http_impl_client_DefaultRequestDirector$processChallenges(Map<String, Header> challenges, AuthState authState, AuthenticationHandler authHandler, HttpResponse response, HttpContext context) throws MalformedChallengeException, AuthenticationException {
        String id2;
        Header challenge;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            authScheme = authHandler.selectScheme(challenges, response, context);
            authState.setAuthScheme(authScheme);
        }
        if ((challenge = challenges.get((id2 = authScheme.getSchemeName()).toLowerCase(Locale.ENGLISH))) == null) {
            throw new AuthenticationException(id2 + " authorization challenge expected, but not found");
        }
        authScheme.processChallenge(challenge);
        this.log.debug("Authorization challenge processed");
    }

    private final void $$robo$$org_apache_http_impl_client_DefaultRequestDirector$updateAuthState(AuthState authState, HttpHost host, CredentialsProvider credsProvider) {
        Credentials creds;
        if (!authState.isValid()) {
            return;
        }
        String hostname = host.getHostName();
        int port = host.getPort();
        if (port < 0) {
            Scheme scheme = this.connManager.getSchemeRegistry().getScheme(host);
            port = scheme.getDefaultPort();
        }
        AuthScheme authScheme = authState.getAuthScheme();
        AuthScope authScope = new AuthScope(hostname, port, authScheme.getRealm(), authScheme.getSchemeName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication scope: " + authScope);
        }
        if ((creds = authState.getCredentials()) == null) {
            creds = credsProvider.getCredentials(authScope);
            if (this.log.isDebugEnabled()) {
                if (creds != null) {
                    this.log.debug("Found credentials");
                } else {
                    this.log.debug("Credentials not found");
                }
            }
        } else if (authScheme.isComplete()) {
            this.log.debug("Authentication failed");
            creds = null;
        }
        authState.setAuthScope(authScope);
        authState.setCredentials(creds);
    }

    private void __constructor__(HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectHandler redirectHandler, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        this.$$robo$$org_apache_http_impl_client_DefaultRequestDirector$__constructor__(httpRequestExecutor, clientConnectionManager, connectionReuseStrategy, connectionKeepAliveStrategy, httpRoutePlanner, httpProcessor, httpRequestRetryHandler, redirectHandler, authenticationHandler, authenticationHandler2, userTokenHandler, httpParams);
    }

    public DefaultRequestDirector(HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectHandler redirectHandler, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$__constructor__(org.apache.http.protocol.HttpRequestExecutor org.apache.http.conn.ClientConnectionManager org.apache.http.ConnectionReuseStrategy org.apache.http.conn.ConnectionKeepAliveStrategy org.apache.http.conn.routing.HttpRoutePlanner org.apache.http.protocol.HttpProcessor org.apache.http.client.HttpRequestRetryHandler org.apache.http.client.RedirectHandler org.apache.http.client.AuthenticationHandler org.apache.http.client.AuthenticationHandler org.apache.http.client.UserTokenHandler org.apache.http.params.HttpParams ), 0, this, httpRequestExecutor, clientConnectionManager, connectionReuseStrategy, connectionKeepAliveStrategy, httpRoutePlanner, httpProcessor, httpRequestRetryHandler, redirectHandler, authenticationHandler, authenticationHandler2, userTokenHandler, httpParams);
    }

    private RequestWrapper wrapRequest(HttpRequest httpRequest) throws ProtocolException {
        return InvokeDynamicSupport.bootstrap("wrapRequest", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$wrapRequest(org.apache.http.HttpRequest ), 0, this, httpRequest);
    }

    protected void rewriteRequestURI(RequestWrapper requestWrapper, HttpRoute httpRoute) throws ProtocolException {
        InvokeDynamicSupport.bootstrap("rewriteRequestURI", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$rewriteRequestURI(org.apache.http.impl.client.RequestWrapper org.apache.http.conn.routing.HttpRoute ), 0, this, requestWrapper, httpRoute);
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$execute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, httpContext);
    }

    protected void releaseConnection() {
        InvokeDynamicSupport.bootstrap("releaseConnection", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$releaseConnection(), 0, this);
    }

    protected HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return InvokeDynamicSupport.bootstrap("determineRoute", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$determineRoute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, httpContext);
    }

    protected void establishRoute(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("establishRoute", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$establishRoute(org.apache.http.conn.routing.HttpRoute org.apache.http.protocol.HttpContext ), 0, this, httpRoute, httpContext);
    }

    protected boolean createTunnelToTarget(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("createTunnelToTarget", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$createTunnelToTarget(org.apache.http.conn.routing.HttpRoute org.apache.http.protocol.HttpContext ), 0, this, httpRoute, httpContext);
    }

    protected boolean createTunnelToProxy(HttpRoute httpRoute, int n, HttpContext httpContext) throws HttpException, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("createTunnelToProxy", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$createTunnelToProxy(org.apache.http.conn.routing.HttpRoute int org.apache.http.protocol.HttpContext ), 0, this, httpRoute, n, httpContext);
    }

    protected HttpRequest createConnectRequest(HttpRoute httpRoute, HttpContext httpContext) {
        return InvokeDynamicSupport.bootstrap("createConnectRequest", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$createConnectRequest(org.apache.http.conn.routing.HttpRoute org.apache.http.protocol.HttpContext ), 0, this, httpRoute, httpContext);
    }

    protected RoutedRequest handleResponse(RoutedRequest routedRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("handleResponse", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$handleResponse(org.apache.http.impl.client.RoutedRequest org.apache.http.HttpResponse org.apache.http.protocol.HttpContext ), 0, this, routedRequest, httpResponse, httpContext);
    }

    private void abortConnection() {
        InvokeDynamicSupport.bootstrap("abortConnection", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$abortConnection(), 0, this);
    }

    private void processChallenges(Map<String, Header> map, AuthState authState, AuthenticationHandler authenticationHandler, HttpResponse httpResponse, HttpContext httpContext) throws MalformedChallengeException, AuthenticationException {
        InvokeDynamicSupport.bootstrap("processChallenges", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$processChallenges(java.util.Map<java.lang.String, org.apache.http.Header> org.apache.http.auth.AuthState org.apache.http.client.AuthenticationHandler org.apache.http.HttpResponse org.apache.http.protocol.HttpContext ), 0, this, map, authState, authenticationHandler, httpResponse, httpContext);
    }

    private void updateAuthState(AuthState authState, HttpHost httpHost, CredentialsProvider credentialsProvider) {
        InvokeDynamicSupport.bootstrap("updateAuthState", $$robo$$org_apache_http_impl_client_DefaultRequestDirector$updateAuthState(org.apache.http.auth.AuthState org.apache.http.HttpHost org.apache.http.client.CredentialsProvider ), 0, this, authState, httpHost, credentialsProvider);
    }

    public /* synthetic */ DefaultRequestDirector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultRequestDirector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

