/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.params.HttpProtocolParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestWrapper
extends AbstractHttpMessage
implements HttpUriRequest,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HttpRequest original;
    private URI uri;
    private String method;
    private ProtocolVersion version;
    private int execCount;

    private void $$robo$$org_apache_http_impl_client_RequestWrapper$__constructor__(HttpRequest request) throws ProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.original = request;
        this.setParams(request.getParams());
        if (request instanceof HttpUriRequest) {
            this.uri = ((HttpUriRequest)request).getURI();
            this.method = ((HttpUriRequest)request).getMethod();
            this.version = null;
        } else {
            RequestLine requestLine = request.getRequestLine();
            try {
                this.uri = new URI(requestLine.getUri());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid request URI: " + requestLine.getUri(), ex);
            }
            this.method = requestLine.getMethod();
            this.version = request.getProtocolVersion();
        }
        this.execCount = 0;
    }

    private final void $$robo$$org_apache_http_impl_client_RequestWrapper$resetHeaders() {
        this.headergroup.clear();
        this.setHeaders(this.original.getAllHeaders());
    }

    private final String $$robo$$org_apache_http_impl_client_RequestWrapper$getMethod() {
        return this.method;
    }

    private final void $$robo$$org_apache_http_impl_client_RequestWrapper$setMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("Method name may not be null");
        }
        this.method = method;
    }

    private final ProtocolVersion $$robo$$org_apache_http_impl_client_RequestWrapper$getProtocolVersion() {
        if (this.version != null) {
            return this.version;
        }
        return HttpProtocolParams.getVersion(this.getParams());
    }

    private final void $$robo$$org_apache_http_impl_client_RequestWrapper$setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    private final URI $$robo$$org_apache_http_impl_client_RequestWrapper$getURI() {
        return this.uri;
    }

    private final void $$robo$$org_apache_http_impl_client_RequestWrapper$setURI(URI uri) {
        this.uri = uri;
    }

    private final RequestLine $$robo$$org_apache_http_impl_client_RequestWrapper$getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        String uritext = null;
        if (this.uri != null) {
            uritext = this.uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    private final void $$robo$$org_apache_http_impl_client_RequestWrapper$abort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private final boolean $$robo$$org_apache_http_impl_client_RequestWrapper$isAborted() {
        return false;
    }

    private final HttpRequest $$robo$$org_apache_http_impl_client_RequestWrapper$getOriginal() {
        return this.original;
    }

    private final boolean $$robo$$org_apache_http_impl_client_RequestWrapper$isRepeatable() {
        return true;
    }

    private final int $$robo$$org_apache_http_impl_client_RequestWrapper$getExecCount() {
        return this.execCount;
    }

    private final void $$robo$$org_apache_http_impl_client_RequestWrapper$incrementExecCount() {
        ++this.execCount;
    }

    private void __constructor__(HttpRequest httpRequest) throws ProtocolException {
        this.$$robo$$org_apache_http_impl_client_RequestWrapper$__constructor__(httpRequest);
    }

    public RequestWrapper(HttpRequest httpRequest) throws ProtocolException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_client_RequestWrapper$__constructor__(org.apache.http.HttpRequest ), 0, this, httpRequest);
    }

    public void resetHeaders() {
        InvokeDynamicSupport.bootstrap("resetHeaders", $$robo$$org_apache_http_impl_client_RequestWrapper$resetHeaders(), 0, this);
    }

    @Override
    public String getMethod() {
        return InvokeDynamicSupport.bootstrap("getMethod", $$robo$$org_apache_http_impl_client_RequestWrapper$getMethod(), 0, this);
    }

    public void setMethod(String string2) {
        InvokeDynamicSupport.bootstrap("setMethod", $$robo$$org_apache_http_impl_client_RequestWrapper$setMethod(java.lang.String ), 0, this, string2);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return InvokeDynamicSupport.bootstrap("getProtocolVersion", $$robo$$org_apache_http_impl_client_RequestWrapper$getProtocolVersion(), 0, this);
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        InvokeDynamicSupport.bootstrap("setProtocolVersion", $$robo$$org_apache_http_impl_client_RequestWrapper$setProtocolVersion(org.apache.http.ProtocolVersion ), 0, this, protocolVersion);
    }

    @Override
    public URI getURI() {
        return InvokeDynamicSupport.bootstrap("getURI", $$robo$$org_apache_http_impl_client_RequestWrapper$getURI(), 0, this);
    }

    public void setURI(URI uRI) {
        InvokeDynamicSupport.bootstrap("setURI", $$robo$$org_apache_http_impl_client_RequestWrapper$setURI(java.net.URI ), 0, this, uRI);
    }

    @Override
    public RequestLine getRequestLine() {
        return InvokeDynamicSupport.bootstrap("getRequestLine", $$robo$$org_apache_http_impl_client_RequestWrapper$getRequestLine(), 0, this);
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        InvokeDynamicSupport.bootstrap("abort", $$robo$$org_apache_http_impl_client_RequestWrapper$abort(), 0, this);
    }

    @Override
    public boolean isAborted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAborted", $$robo$$org_apache_http_impl_client_RequestWrapper$isAborted(), 0, this);
    }

    public HttpRequest getOriginal() {
        return InvokeDynamicSupport.bootstrap("getOriginal", $$robo$$org_apache_http_impl_client_RequestWrapper$getOriginal(), 0, this);
    }

    public boolean isRepeatable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRepeatable", $$robo$$org_apache_http_impl_client_RequestWrapper$isRepeatable(), 0, this);
    }

    public int getExecCount() {
        return (int)InvokeDynamicSupport.bootstrap("getExecCount", $$robo$$org_apache_http_impl_client_RequestWrapper$getExecCount(), 0, this);
    }

    public void incrementExecCount() {
        InvokeDynamicSupport.bootstrap("incrementExecCount", $$robo$$org_apache_http_impl_client_RequestWrapper$incrementExecCount(), 0, this);
    }

    public /* synthetic */ RequestWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

