/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractClientConnAdapter
implements ManagedClientConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Thread executionThread;
    private volatile ClientConnectionManager connManager;
    private volatile OperatedClientConnection wrappedConnection;
    private volatile boolean markedReusable;
    private volatile boolean aborted;
    private volatile long duration;

    private void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$__constructor__(ClientConnectionManager mgr, OperatedClientConnection conn) {
        this.executionThread = Thread.currentThread();
        this.connManager = mgr;
        this.wrappedConnection = conn;
        this.markedReusable = false;
        this.aborted = false;
        this.duration = Long.MAX_VALUE;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$detach() {
        this.wrappedConnection = null;
        this.connManager = null;
        this.duration = Long.MAX_VALUE;
    }

    private final OperatedClientConnection $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getWrappedConnection() {
        return this.wrappedConnection;
    }

    private final ClientConnectionManager $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getManager() {
        return this.connManager;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$assertNotAborted() throws InterruptedIOException {
        if (this.aborted) {
            throw new InterruptedIOException("Connection has been shut down.");
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$assertValid(OperatedClientConnection wrappedConn) {
        if (wrappedConn == null) {
            throw new IllegalStateException("No wrapped connection.");
        }
    }

    private final boolean $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isOpen() {
        OperatedClientConnection conn = this.getWrappedConnection();
        if (conn == null) {
            return false;
        }
        return conn.isOpen();
    }

    private final boolean $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isStale() {
        if (this.aborted) {
            return true;
        }
        OperatedClientConnection conn = this.getWrappedConnection();
        if (conn == null) {
            return true;
        }
        return conn.isStale();
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$setSocketTimeout(int timeout) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        conn.setSocketTimeout(timeout);
    }

    private final int $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getSocketTimeout() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getSocketTimeout();
    }

    private final HttpConnectionMetrics $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getMetrics() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getMetrics();
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$flush() throws IOException {
        this.assertNotAborted();
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        conn.flush();
    }

    private final boolean $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isResponseAvailable(int timeout) throws IOException {
        this.assertNotAborted();
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.isResponseAvailable(timeout);
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        this.assertNotAborted();
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        conn.receiveResponseEntity(response);
    }

    private final HttpResponse $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$receiveResponseHeader() throws HttpException, IOException {
        this.assertNotAborted();
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        return conn.receiveResponseHeader();
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        this.assertNotAborted();
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        conn.sendRequestEntity(request);
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        this.assertNotAborted();
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        conn.sendRequestHeader(request);
    }

    private final InetAddress $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getLocalAddress() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getLocalAddress();
    }

    private final int $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getLocalPort() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getLocalPort();
    }

    private final InetAddress $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getRemoteAddress() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getRemoteAddress();
    }

    private final int $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getRemotePort() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getRemotePort();
    }

    private final boolean $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isSecure() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.isSecure();
    }

    private final SSLSession $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getSSLSession() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (!this.isOpen()) {
            return null;
        }
        SSLSession result = null;
        Socket sock = conn.getSocket();
        if (sock instanceof SSLSocket) {
            result = ((SSLSocket)sock).getSession();
        }
        return result;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$markReusable() {
        this.markedReusable = true;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$unmarkReusable() {
        this.markedReusable = false;
    }

    private final boolean $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isMarkedReusable() {
        return this.markedReusable;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$setIdleDuration(long duration, TimeUnit unit) {
        this.duration = duration > 0L ? unit.toMillis(duration) : -1L;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$releaseConnection() {
        if (this.connManager != null) {
            this.connManager.releaseConnection(this, this.duration, TimeUnit.MILLISECONDS);
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$abortConnection() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        this.unmarkReusable();
        try {
            this.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.executionThread.equals(Thread.currentThread())) {
            this.releaseConnection();
        }
    }

    private void __constructor__(ClientConnectionManager clientConnectionManager, OperatedClientConnection operatedClientConnection) {
        this.$$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$__constructor__(clientConnectionManager, operatedClientConnection);
    }

    protected AbstractClientConnAdapter(ClientConnectionManager clientConnectionManager, OperatedClientConnection operatedClientConnection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$__constructor__(org.apache.http.conn.ClientConnectionManager org.apache.http.conn.OperatedClientConnection ), 0, this, clientConnectionManager, operatedClientConnection);
    }

    protected void detach() {
        InvokeDynamicSupport.bootstrap("detach", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$detach(), 0, this);
    }

    protected OperatedClientConnection getWrappedConnection() {
        return InvokeDynamicSupport.bootstrap("getWrappedConnection", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getWrappedConnection(), 0, this);
    }

    protected ClientConnectionManager getManager() {
        return InvokeDynamicSupport.bootstrap("getManager", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getManager(), 0, this);
    }

    protected void assertNotAborted() throws InterruptedIOException {
        InvokeDynamicSupport.bootstrap("assertNotAborted", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$assertNotAborted(), 0, this);
    }

    protected void assertValid(OperatedClientConnection operatedClientConnection) {
        InvokeDynamicSupport.bootstrap("assertValid", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$assertValid(org.apache.http.conn.OperatedClientConnection ), 0, this, operatedClientConnection);
    }

    @Override
    public boolean isOpen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isOpen(), 0, this);
    }

    @Override
    public boolean isStale() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStale", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isStale(), 0, this);
    }

    @Override
    public void setSocketTimeout(int n) {
        InvokeDynamicSupport.bootstrap("setSocketTimeout", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$setSocketTimeout(int ), 0, this, n);
    }

    @Override
    public int getSocketTimeout() {
        return (int)InvokeDynamicSupport.bootstrap("getSocketTimeout", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getSocketTimeout(), 0, this);
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getMetrics(), 0, this);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$flush(), 0, this);
    }

    @Override
    public boolean isResponseAvailable(int n) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("isResponseAvailable", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isResponseAvailable(int ), 0, this, n);
    }

    @Override
    public void receiveResponseEntity(HttpResponse httpResponse) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("receiveResponseEntity", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$receiveResponseEntity(org.apache.http.HttpResponse ), 0, this, httpResponse);
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("receiveResponseHeader", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$receiveResponseHeader(), 0, this);
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequestEntity", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$sendRequestEntity(org.apache.http.HttpEntityEnclosingRequest ), 0, this, httpEntityEnclosingRequest);
    }

    @Override
    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequestHeader", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$sendRequestHeader(org.apache.http.HttpRequest ), 0, this, httpRequest);
    }

    @Override
    public InetAddress getLocalAddress() {
        return InvokeDynamicSupport.bootstrap("getLocalAddress", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getLocalAddress(), 0, this);
    }

    @Override
    public int getLocalPort() {
        return (int)InvokeDynamicSupport.bootstrap("getLocalPort", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getLocalPort(), 0, this);
    }

    @Override
    public InetAddress getRemoteAddress() {
        return InvokeDynamicSupport.bootstrap("getRemoteAddress", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getRemoteAddress(), 0, this);
    }

    @Override
    public int getRemotePort() {
        return (int)InvokeDynamicSupport.bootstrap("getRemotePort", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getRemotePort(), 0, this);
    }

    @Override
    public boolean isSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isSecure(), 0, this);
    }

    @Override
    public SSLSession getSSLSession() {
        return InvokeDynamicSupport.bootstrap("getSSLSession", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$getSSLSession(), 0, this);
    }

    @Override
    public void markReusable() {
        InvokeDynamicSupport.bootstrap("markReusable", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$markReusable(), 0, this);
    }

    @Override
    public void unmarkReusable() {
        InvokeDynamicSupport.bootstrap("unmarkReusable", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$unmarkReusable(), 0, this);
    }

    @Override
    public boolean isMarkedReusable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMarkedReusable", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$isMarkedReusable(), 0, this);
    }

    @Override
    public void setIdleDuration(long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("setIdleDuration", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$setIdleDuration(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
    }

    @Override
    public void releaseConnection() {
        InvokeDynamicSupport.bootstrap("releaseConnection", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$releaseConnection(), 0, this);
    }

    @Override
    public void abortConnection() {
        InvokeDynamicSupport.bootstrap("abortConnection", $$robo$$org_apache_http_impl_conn_AbstractClientConnAdapter$abortConnection(), 0, this);
    }

    public /* synthetic */ AbstractClientConnAdapter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractClientConnAdapter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

