/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractPoolEntry
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected ClientConnectionOperator connOperator;
    protected OperatedClientConnection connection;
    protected volatile HttpRoute route;
    protected volatile Object state;
    protected volatile RouteTracker tracker;

    private void $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$__constructor__(ClientConnectionOperator connOperator, HttpRoute route) {
        if (connOperator == null) {
            throw new IllegalArgumentException("Connection operator may not be null");
        }
        this.connOperator = connOperator;
        this.connection = connOperator.createConnection();
        this.route = route;
        this.tracker = null;
    }

    private final Object $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$getState() {
        return this.state;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$setState(Object state) {
        this.state = state;
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
        if (route == null) {
            throw new IllegalArgumentException("Route must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (this.tracker != null && this.tracker.isConnected()) {
            throw new IllegalStateException("Connection already open.");
        }
        this.tracker = new RouteTracker(route);
        HttpHost proxy = route.getProxyHost();
        this.connOperator.openConnection(this.connection, proxy != null ? proxy : route.getTargetHost(), route.getLocalAddress(), context, params);
        RouteTracker localTracker = this.tracker;
        if (localTracker == null) {
            throw new IOException("Request aborted");
        }
        if (proxy == null) {
            localTracker.connectTarget(this.connection.isSecure());
        } else {
            localTracker.connectProxy(proxy, this.connection.isSecure());
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$tunnelTarget(boolean secure, HttpParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (this.tracker == null || !this.tracker.isConnected()) {
            throw new IllegalStateException("Connection not open.");
        }
        if (this.tracker.isTunnelled()) {
            throw new IllegalStateException("Connection is already tunnelled.");
        }
        this.connection.update(null, this.tracker.getTargetHost(), secure, params);
        this.tracker.tunnelTarget(secure);
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$tunnelProxy(HttpHost next, boolean secure, HttpParams params) throws IOException {
        if (next == null) {
            throw new IllegalArgumentException("Next proxy must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (this.tracker == null || !this.tracker.isConnected()) {
            throw new IllegalStateException("Connection not open.");
        }
        this.connection.update(null, next, secure, params);
        this.tracker.tunnelProxy(next, secure);
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$layerProtocol(HttpContext context, HttpParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (this.tracker == null || !this.tracker.isConnected()) {
            throw new IllegalStateException("Connection not open.");
        }
        if (!this.tracker.isTunnelled()) {
            throw new IllegalStateException("Protocol layering without a tunnel not supported.");
        }
        if (this.tracker.isLayered()) {
            throw new IllegalStateException("Multiple protocol layering not supported.");
        }
        HttpHost target = this.tracker.getTargetHost();
        this.connOperator.updateSecureConnection(this.connection, target, context, params);
        this.tracker.layerProtocol(this.connection.isSecure());
    }

    private final void $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$shutdownEntry() {
        this.tracker = null;
    }

    private void __constructor__(ClientConnectionOperator clientConnectionOperator, HttpRoute httpRoute) {
        this.$$robo$$org_apache_http_impl_conn_AbstractPoolEntry$__constructor__(clientConnectionOperator, httpRoute);
    }

    protected AbstractPoolEntry(ClientConnectionOperator clientConnectionOperator, HttpRoute httpRoute) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$__constructor__(org.apache.http.conn.ClientConnectionOperator org.apache.http.conn.routing.HttpRoute ), 0, this, clientConnectionOperator, httpRoute);
    }

    public Object getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$getState(), 0, this);
    }

    public void setState(Object object) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$setState(java.lang.Object ), 0, this, object);
    }

    public void open(HttpRoute httpRoute, HttpContext httpContext, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("open", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$open(org.apache.http.conn.routing.HttpRoute org.apache.http.protocol.HttpContext org.apache.http.params.HttpParams ), 0, this, httpRoute, httpContext, httpParams);
    }

    public void tunnelTarget(boolean bl, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("tunnelTarget", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$tunnelTarget(boolean org.apache.http.params.HttpParams ), 0, this, bl, httpParams);
    }

    public void tunnelProxy(HttpHost httpHost, boolean bl, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("tunnelProxy", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$tunnelProxy(org.apache.http.HttpHost boolean org.apache.http.params.HttpParams ), 0, this, httpHost, bl, httpParams);
    }

    public void layerProtocol(HttpContext httpContext, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("layerProtocol", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$layerProtocol(org.apache.http.protocol.HttpContext org.apache.http.params.HttpParams ), 0, this, httpContext, httpParams);
    }

    protected void shutdownEntry() {
        InvokeDynamicSupport.bootstrap("shutdownEntry", $$robo$$org_apache_http_impl_conn_AbstractPoolEntry$shutdownEntry(), 0, this);
    }

    public /* synthetic */ AbstractPoolEntry() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractPoolEntry)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

