/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.impl.SocketHttpClientConnection;
import org.apache.http.impl.conn.DefaultResponseParser;
import org.apache.http.impl.conn.LoggingSessionInputBuffer;
import org.apache.http.impl.conn.LoggingSessionOutputBuffer;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DefaultClientConnection
extends SocketHttpClientConnection
implements OperatedClientConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    private Log headerLog;
    private Log wireLog;
    private volatile Socket socket;
    private HttpHost targetHost;
    private boolean connSecure;
    private volatile boolean shutdown;

    private void $$robo$$org_apache_http_impl_conn_DefaultClientConnection$__constructor__() {
        this.log = LogFactory.getLog(this.getClass());
        this.headerLog = LogFactory.getLog("org.apache.http.headers");
        this.wireLog = LogFactory.getLog("org.apache.http.wire");
    }

    private final HttpHost $$robo$$org_apache_http_impl_conn_DefaultClientConnection$getTargetHost() {
        return this.targetHost;
    }

    private final boolean $$robo$$org_apache_http_impl_conn_DefaultClientConnection$isSecure() {
        return this.connSecure;
    }

    private final Socket $$robo$$org_apache_http_impl_conn_DefaultClientConnection$getSocket() {
        return this.socket;
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnection$opening(Socket sock, HttpHost target) throws IOException {
        this.assertNotOpen();
        this.socket = sock;
        this.targetHost = target;
        if (this.shutdown) {
            sock.close();
            throw new IOException("Connection already shutdown");
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnection$openCompleted(boolean secure, HttpParams params) throws IOException {
        this.assertNotOpen();
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.connSecure = secure;
        this.bind(this.socket, params);
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnection$shutdown() throws IOException {
        this.log.debug("Connection shut down");
        this.shutdown = true;
        super.shutdown();
        Socket sock = this.socket;
        if (sock != null) {
            sock.close();
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnection$close() throws IOException {
        this.log.debug("Connection closed");
        super.close();
    }

    private final SessionInputBuffer $$robo$$org_apache_http_impl_conn_DefaultClientConnection$createSessionInputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        SessionInputBuffer inbuffer = super.createSessionInputBuffer(socket, buffersize, params);
        if (this.wireLog.isDebugEnabled()) {
            inbuffer = new LoggingSessionInputBuffer(inbuffer, new Wire(this.wireLog));
        }
        return inbuffer;
    }

    private final SessionOutputBuffer $$robo$$org_apache_http_impl_conn_DefaultClientConnection$createSessionOutputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        SessionOutputBuffer outbuffer = super.createSessionOutputBuffer(socket, buffersize, params);
        if (this.wireLog.isDebugEnabled()) {
            outbuffer = new LoggingSessionOutputBuffer(outbuffer, new Wire(this.wireLog));
        }
        return outbuffer;
    }

    private final HttpMessageParser $$robo$$org_apache_http_impl_conn_DefaultClientConnection$createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new DefaultResponseParser(buffer, null, responseFactory, params);
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnection$update(Socket sock, HttpHost target, boolean secure, HttpParams params) throws IOException {
        this.assertOpen();
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (sock != null) {
            this.socket = sock;
            this.bind(sock, params);
        }
        this.targetHost = target;
        this.connSecure = secure;
    }

    private final HttpResponse $$robo$$org_apache_http_impl_conn_DefaultClientConnection$receiveResponseHeader() throws HttpException, IOException {
        HttpResponse response = super.receiveResponseHeader();
        if (this.headerLog.isDebugEnabled()) {
            Header[] headers;
            this.headerLog.debug("<< " + response.getStatusLine().toString());
            for (Header header : headers = response.getAllHeaders()) {
                this.headerLog.debug("<< " + header.toString());
            }
        }
        return response;
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnection$sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        super.sendRequestHeader(request);
        if (this.headerLog.isDebugEnabled()) {
            Header[] headers;
            this.headerLog.debug(">> " + request.getRequestLine().toString());
            for (Header header : headers = request.getAllHeaders()) {
                this.headerLog.debug(">> " + header.toString());
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_conn_DefaultClientConnection$__constructor__();
    }

    public DefaultClientConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$__constructor__(), 0, this);
    }

    @Override
    public HttpHost getTargetHost() {
        return InvokeDynamicSupport.bootstrap("getTargetHost", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$getTargetHost(), 0, this);
    }

    @Override
    public boolean isSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$isSecure(), 0, this);
    }

    @Override
    public Socket getSocket() {
        return InvokeDynamicSupport.bootstrap("getSocket", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$getSocket(), 0, this);
    }

    @Override
    public void opening(Socket socket, HttpHost httpHost) throws IOException {
        InvokeDynamicSupport.bootstrap("opening", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$opening(java.net.Socket org.apache.http.HttpHost ), 0, this, socket, httpHost);
    }

    @Override
    public void openCompleted(boolean bl, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("openCompleted", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$openCompleted(boolean org.apache.http.params.HttpParams ), 0, this, bl, httpParams);
    }

    @Override
    public void shutdown() throws IOException {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$shutdown(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$close(), 0, this);
    }

    @Override
    protected SessionInputBuffer createSessionInputBuffer(Socket socket, int n, HttpParams httpParams) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSessionInputBuffer", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$createSessionInputBuffer(java.net.Socket int org.apache.http.params.HttpParams ), 0, this, socket, n, httpParams);
    }

    @Override
    protected SessionOutputBuffer createSessionOutputBuffer(Socket socket, int n, HttpParams httpParams) throws IOException {
        return InvokeDynamicSupport.bootstrap("createSessionOutputBuffer", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$createSessionOutputBuffer(java.net.Socket int org.apache.http.params.HttpParams ), 0, this, socket, n, httpParams);
    }

    @Override
    protected HttpMessageParser createResponseParser(SessionInputBuffer sessionInputBuffer, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        return InvokeDynamicSupport.bootstrap("createResponseParser", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$createResponseParser(org.apache.http.io.SessionInputBuffer org.apache.http.HttpResponseFactory org.apache.http.params.HttpParams ), 0, this, sessionInputBuffer, httpResponseFactory, httpParams);
    }

    @Override
    public void update(Socket socket, HttpHost httpHost, boolean bl, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("update", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$update(java.net.Socket org.apache.http.HttpHost boolean org.apache.http.params.HttpParams ), 0, this, socket, httpHost, bl, httpParams);
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("receiveResponseHeader", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$receiveResponseHeader(), 0, this);
    }

    @Override
    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequestHeader", $$robo$$org_apache_http_impl_conn_DefaultClientConnection$sendRequestHeader(org.apache.http.HttpRequest ), 0, this, httpRequest);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultClientConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

