/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.conn.DefaultClientConnection;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DefaultClientConnectionOperator
implements ClientConnectionOperator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static PlainSocketFactory staticPlainSocketFactory;
    protected SchemeRegistry schemeRegistry;

    private void $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$__constructor__(SchemeRegistry schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException("Scheme registry must not be null.");
        }
        this.schemeRegistry = schemes;
    }

    private final OperatedClientConnection $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$createConnection() {
        return new DefaultClientConnection();
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$openConnection(OperatedClientConnection conn, HttpHost target, InetAddress local, HttpContext context, HttpParams params) throws IOException {
        LayeredSocketFactory layered_sf;
        SocketFactory plain_sf;
        if (conn == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (conn.isOpen()) {
            throw new IllegalArgumentException("Connection must not be open.");
        }
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        SocketFactory sf = schm.getSocketFactory();
        if (sf instanceof LayeredSocketFactory) {
            plain_sf = staticPlainSocketFactory;
            layered_sf = (LayeredSocketFactory)sf;
        } else {
            plain_sf = sf;
            layered_sf = null;
        }
        InetAddress[] addresses = InetAddress.getAllByName(target.getHostName());
        for (int i = 0; i < addresses.length; ++i) {
            Socket sock = plain_sf.createSocket();
            conn.opening(sock, target);
            try {
                Socket connsock = plain_sf.connectSocket(sock, addresses[i].getHostAddress(), schm.resolvePort(target.getPort()), local, 0, params);
                if (sock != connsock) {
                    sock = connsock;
                    conn.opening(sock, target);
                }
                this.prepareSocket(sock, context, params);
                if (layered_sf != null) {
                    Socket layeredsock = layered_sf.createSocket(sock, target.getHostName(), schm.resolvePort(target.getPort()), true);
                    if (layeredsock != sock) {
                        conn.opening(layeredsock, target);
                    }
                    conn.openCompleted(sf.isSecure(layeredsock), params);
                    break;
                }
                conn.openCompleted(sf.isSecure(sock), params);
                break;
            }
            catch (SocketException ex) {
                if (i != addresses.length - 1) continue;
                ConnectException cause = ex instanceof ConnectException ? (ConnectException)ex : new ConnectException(ex.getMessage(), ex);
                throw new HttpHostConnectException(target, cause);
            }
            catch (ConnectTimeoutException ex) {
                if (i != addresses.length - 1) continue;
                throw ex;
            }
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$updateSecureConnection(OperatedClientConnection conn, HttpHost target, HttpContext context, HttpParams params) throws IOException {
        Socket sock;
        if (conn == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (!conn.isOpen()) {
            throw new IllegalArgumentException("Connection must be open.");
        }
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        if (!(schm.getSocketFactory() instanceof LayeredSocketFactory)) {
            throw new IllegalArgumentException("Target scheme (" + schm.getName() + ") must have layered socket factory.");
        }
        LayeredSocketFactory lsf = (LayeredSocketFactory)schm.getSocketFactory();
        try {
            sock = lsf.createSocket(conn.getSocket(), target.getHostName(), schm.resolvePort(target.getPort()), true);
        }
        catch (ConnectException ex) {
            throw new HttpHostConnectException(target, ex);
        }
        this.prepareSocket(sock, context, params);
        conn.update(sock, target, lsf.isSecure(sock), params);
    }

    private final void $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$prepareSocket(Socket sock, HttpContext context, HttpParams params) throws IOException {
        sock.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        sock.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            sock.setSoLinger(linger > 0, linger);
        }
    }

    static void __staticInitializer__() {
        staticPlainSocketFactory = new PlainSocketFactory();
    }

    private void __constructor__(SchemeRegistry schemeRegistry) {
        this.$$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$__constructor__(schemeRegistry);
    }

    public DefaultClientConnectionOperator(SchemeRegistry schemeRegistry) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$__constructor__(org.apache.http.conn.scheme.SchemeRegistry ), 0, this, schemeRegistry);
    }

    @Override
    public OperatedClientConnection createConnection() {
        return InvokeDynamicSupport.bootstrap("createConnection", $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$createConnection(), 0, this);
    }

    @Override
    public void openConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, InetAddress inetAddress, HttpContext httpContext, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("openConnection", $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$openConnection(org.apache.http.conn.OperatedClientConnection org.apache.http.HttpHost java.net.InetAddress org.apache.http.protocol.HttpContext org.apache.http.params.HttpParams ), 0, this, operatedClientConnection, httpHost, inetAddress, httpContext, httpParams);
    }

    @Override
    public void updateSecureConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, HttpContext httpContext, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("updateSecureConnection", $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$updateSecureConnection(org.apache.http.conn.OperatedClientConnection org.apache.http.HttpHost org.apache.http.protocol.HttpContext org.apache.http.params.HttpParams ), 0, this, operatedClientConnection, httpHost, httpContext, httpParams);
    }

    protected void prepareSocket(Socket socket, HttpContext httpContext, HttpParams httpParams) throws IOException {
        InvokeDynamicSupport.bootstrap("prepareSocket", $$robo$$org_apache_http_impl_conn_DefaultClientConnectionOperator$prepareSocket(java.net.Socket org.apache.http.protocol.HttpContext org.apache.http.params.HttpParams ), 0, this, socket, httpContext, httpParams);
    }

    static {
        RobolectricInternals.classInitializing(DefaultClientConnectionOperator.class);
    }

    public /* synthetic */ DefaultClientConnectionOperator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultClientConnectionOperator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

