/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponseFactory;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DefaultResponseParser
extends AbstractMessageParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HttpResponseFactory responseFactory;
    private CharArrayBuffer lineBuf;
    private int maxGarbageLines;

    private void $$robo$$org_apache_http_impl_conn_DefaultResponseParser$__constructor__(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
        this.maxGarbageLines = params.getIntParameter("http.connection.max-status-line-garbage", Integer.MAX_VALUE);
    }

    private final HttpMessage $$robo$$org_apache_http_impl_conn_DefaultResponseParser$parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        this.lineBuf.clear();
        int count = 0;
        ParserCursor cursor = null;
        while (true) {
            int i;
            if ((i = sessionBuffer.readLine(this.lineBuf)) == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            cursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
            if (i == -1 || count >= this.maxGarbageLines) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }

    private void __constructor__(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        this.$$robo$$org_apache_http_impl_conn_DefaultResponseParser$__constructor__(sessionInputBuffer, lineParser, httpResponseFactory, httpParams);
    }

    public DefaultResponseParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        super(sessionInputBuffer, lineParser, httpParams);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_DefaultResponseParser$__constructor__(org.apache.http.io.SessionInputBuffer org.apache.http.message.LineParser org.apache.http.HttpResponseFactory org.apache.http.params.HttpParams ), 0, this, sessionInputBuffer, lineParser, httpResponseFactory, httpParams);
    }

    @Override
    protected HttpMessage parseHead(SessionInputBuffer sessionInputBuffer) throws IOException, HttpException {
        return InvokeDynamicSupport.bootstrap("parseHead", $$robo$$org_apache_http_impl_conn_DefaultResponseParser$parseHead(org.apache.http.io.SessionInputBuffer ), 0, this, sessionInputBuffer);
    }

    public /* synthetic */ DefaultResponseParser() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultResponseParser)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

