/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IdleConnectionHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    private Map<HttpConnection, TimeValues> connectionToTimes;

    private void $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$__constructor__() {
        this.log = LogFactory.getLog(this.getClass());
        this.connectionToTimes = new HashMap<HttpConnection, TimeValues>();
    }

    private final void $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$add(HttpConnection connection, long validDuration, TimeUnit unit) {
        Long timeAdded = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding connection at: " + timeAdded);
        }
        this.connectionToTimes.put(connection, new TimeValues(timeAdded, validDuration, unit));
    }

    private final boolean $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$remove(HttpConnection connection) {
        TimeValues times = this.connectionToTimes.remove(connection);
        if (times == null) {
            this.log.warn("Removing a connection that never existed!");
            return true;
        }
        return InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") <= times.timeExpires;
    }

    private final void $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$removeAll() {
        this.connectionToTimes.clear();
    }

    private final void $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$closeIdleConnections(long idleTime) {
        reference var3_2 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - idleTime;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking for connections, idleTimeout: " + (long)var3_2);
        }
        Iterator<HttpConnection> connectionIter = this.connectionToTimes.keySet().iterator();
        while (connectionIter.hasNext()) {
            HttpConnection conn = connectionIter.next();
            TimeValues times = this.connectionToTimes.get(conn);
            Long connectionTime = times.timeAdded;
            if (connectionTime > var3_2) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Closing connection, connection time: " + connectionTime);
            }
            connectionIter.remove();
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.log.debug("I/O error closing connection", ex);
            }
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$closeExpiredConnections() {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking for expired connections, now: " + (long)now);
        }
        Iterator<HttpConnection> connectionIter = this.connectionToTimes.keySet().iterator();
        while (connectionIter.hasNext()) {
            HttpConnection conn = connectionIter.next();
            TimeValues times = this.connectionToTimes.get(conn);
            if (times.timeExpires > now) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Closing connection, expired @: " + times.timeExpires);
            }
            connectionIter.remove();
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.log.debug("I/O error closing connection", ex);
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_conn_IdleConnectionHandler$__constructor__();
    }

    public IdleConnectionHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$__constructor__(), 0, this);
    }

    public void add(HttpConnection httpConnection, long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$add(org.apache.http.HttpConnection long java.util.concurrent.TimeUnit ), 0, this, httpConnection, l, timeUnit);
    }

    public boolean remove(HttpConnection httpConnection) {
        return (boolean)InvokeDynamicSupport.bootstrap("remove", $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$remove(org.apache.http.HttpConnection ), 0, this, httpConnection);
    }

    public void removeAll() {
        InvokeDynamicSupport.bootstrap("removeAll", $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$removeAll(), 0, this);
    }

    public void closeIdleConnections(long l) {
        InvokeDynamicSupport.bootstrap("closeIdleConnections", $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$closeIdleConnections(long ), 0, this, l);
    }

    public void closeExpiredConnections() {
        InvokeDynamicSupport.bootstrap("closeExpiredConnections", $$robo$$org_apache_http_impl_conn_IdleConnectionHandler$closeExpiredConnections(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleConnectionHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TimeValues
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long timeAdded;
        private long timeExpires;

        private void $$robo$$org_apache_http_impl_conn_IdleConnectionHandler_TimeValues$__constructor__(long now, long validDuration, TimeUnit validUnit) {
            this.timeAdded = now;
            this.timeExpires = validDuration > 0L ? now + validUnit.toMillis(validDuration) : Long.MAX_VALUE;
        }

        private void __constructor__(long l, long l2, TimeUnit timeUnit) {
            this.$$robo$$org_apache_http_impl_conn_IdleConnectionHandler_TimeValues$__constructor__(l, l2, timeUnit);
        }

        TimeValues(long l, long l2, TimeUnit timeUnit) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_IdleConnectionHandler_TimeValues$__constructor__(long long java.util.concurrent.TimeUnit ), 0, this, l, l2, timeUnit);
        }

        public /* synthetic */ TimeValues() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeValues)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

