/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.protocol.HttpContext;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ProxySelectorRoutePlanner
implements HttpRoutePlanner,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected SchemeRegistry schemeRegistry;
    protected ProxySelector proxySelector;

    private void $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$__constructor__(SchemeRegistry schreg, ProxySelector prosel) {
        if (schreg == null) {
            throw new IllegalArgumentException("SchemeRegistry must not be null.");
        }
        this.schemeRegistry = schreg;
        this.proxySelector = prosel;
    }

    private final ProxySelector $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$getProxySelector() {
        return this.proxySelector;
    }

    private final void $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$setProxySelector(ProxySelector prosel) {
        this.proxySelector = prosel;
    }

    private final HttpRoute $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (request == null) {
            throw new IllegalStateException("Request must not be null.");
        }
        HttpRoute route = ConnRouteParams.getForcedRoute(request.getParams());
        if (route != null) {
            return route;
        }
        if (target == null) {
            throw new IllegalStateException("Target host must not be null.");
        }
        InetAddress local = ConnRouteParams.getLocalAddress(request.getParams());
        HttpHost proxy = (HttpHost)request.getParams().getParameter("http.route.default-proxy");
        if (proxy == null) {
            proxy = this.determineProxy(target, request, context);
        } else if (ConnRouteParams.NO_HOST.equals(proxy)) {
            proxy = null;
        }
        Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
        boolean secure = schm.isLayered();
        route = proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
        return route;
    }

    private final HttpHost $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        ProxySelector psel = this.proxySelector;
        if (psel == null) {
            psel = ProxySelector.getDefault();
        }
        if (psel == null) {
            return null;
        }
        URI targetURI = null;
        try {
            targetURI = new URI(target.toURI());
        }
        catch (URISyntaxException usx) {
            throw new HttpException("Cannot convert host to URI: " + target, usx);
        }
        List<Proxy> proxies = psel.select(targetURI);
        Proxy p = this.chooseProxy(proxies, target, request, context);
        HttpHost result = null;
        if (p.type() == Proxy.Type.HTTP) {
            if (!(p.address() instanceof InetSocketAddress)) {
                throw new HttpException("Unable to handle non-Inet proxy address: " + p.address());
            }
            InetSocketAddress isa = (InetSocketAddress)p.address();
            result = new HttpHost(this.getHost(isa), isa.getPort());
        }
        return result;
    }

    private final String $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$getHost(InetSocketAddress isa) {
        return isa.isUnresolved() ? isa.getHostName() : isa.getAddress().getHostAddress();
    }

    private final Proxy $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$chooseProxy(List<Proxy> proxies, HttpHost target, HttpRequest request, HttpContext context) {
        if (proxies == null || proxies.isEmpty()) {
            throw new IllegalArgumentException("Proxy list must not be empty.");
        }
        Proxy result = null;
        block3: for (int i = 0; result == null && i < proxies.size(); ++i) {
            Proxy p = proxies.get(i);
            switch (1.$SwitchMap$java$net$Proxy$Type[p.type().ordinal()]) {
                case 1: 
                case 2: {
                    result = p;
                    continue block3;
                }
            }
        }
        if (result == null) {
            result = Proxy.NO_PROXY;
        }
        return result;
    }

    private void __constructor__(SchemeRegistry schemeRegistry, ProxySelector proxySelector) {
        this.$$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$__constructor__(schemeRegistry, proxySelector);
    }

    public ProxySelectorRoutePlanner(SchemeRegistry schemeRegistry, ProxySelector proxySelector) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$__constructor__(org.apache.http.conn.scheme.SchemeRegistry java.net.ProxySelector ), 0, this, schemeRegistry, proxySelector);
    }

    public ProxySelector getProxySelector() {
        return InvokeDynamicSupport.bootstrap("getProxySelector", $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$getProxySelector(), 0, this);
    }

    public void setProxySelector(ProxySelector proxySelector) {
        InvokeDynamicSupport.bootstrap("setProxySelector", $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$setProxySelector(java.net.ProxySelector ), 0, this, proxySelector);
    }

    @Override
    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return InvokeDynamicSupport.bootstrap("determineRoute", $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$determineRoute(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, httpContext);
    }

    protected HttpHost determineProxy(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return InvokeDynamicSupport.bootstrap("determineProxy", $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$determineProxy(org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, httpHost, httpRequest, httpContext);
    }

    protected String getHost(InetSocketAddress inetSocketAddress) {
        return InvokeDynamicSupport.bootstrap("getHost", $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$getHost(java.net.InetSocketAddress ), 0, this, inetSocketAddress);
    }

    protected Proxy chooseProxy(List<Proxy> list, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        return InvokeDynamicSupport.bootstrap("chooseProxy", $$robo$$org_apache_http_impl_conn_ProxySelectorRoutePlanner$chooseProxy(java.util.List<java.net.Proxy> org.apache.http.HttpHost org.apache.http.HttpRequest org.apache.http.protocol.HttpContext ), 0, this, list, httpHost, httpRequest, httpContext);
    }

    public /* synthetic */ ProxySelectorRoutePlanner() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProxySelectorRoutePlanner)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$java$net$Proxy$Type;

        static void __staticInitializer__() {
            $SwitchMap$java$net$Proxy$Type = new int[Proxy.Type.values().length];
            try {
                1.$SwitchMap$java$net$Proxy$Type[Proxy.Type.DIRECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$net$Proxy$Type[Proxy.Type.HTTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$java$net$Proxy$Type[Proxy.Type.SOCKS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

