/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import dalvik.system.SocketTagger;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.AbstractPooledConnAdapter;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SingleClientConnManager
implements ClientConnectionManager,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    public static String MISUSE_MESSAGE = "Invalid use of SingleClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.";
    protected SchemeRegistry schemeRegistry;
    protected ClientConnectionOperator connOperator;
    protected PoolEntry uniquePoolEntry;
    protected ConnAdapter managedConn;
    protected long lastReleaseTime;
    protected long connectionExpiresTime;
    protected boolean alwaysShutDown;
    protected volatile boolean isShutDown;

    private void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$__constructor__(HttpParams params, SchemeRegistry schreg) {
        this.log = LogFactory.getLog(this.getClass());
        if (schreg == null) {
            throw new IllegalArgumentException("Scheme registry must not be null.");
        }
        this.schemeRegistry = schreg;
        this.connOperator = this.createConnectionOperator(schreg);
        this.uniquePoolEntry = new PoolEntry(this);
        this.managedConn = null;
        this.lastReleaseTime = -1L;
        this.alwaysShutDown = false;
        this.isShutDown = false;
    }

    private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    private final SchemeRegistry $$robo$$org_apache_http_impl_conn_SingleClientConnManager$getSchemeRegistry() {
        return this.schemeRegistry;
    }

    private final ClientConnectionOperator $$robo$$org_apache_http_impl_conn_SingleClientConnManager$createConnectionOperator(SchemeRegistry schreg) {
        return new DefaultClientConnectionOperator(schreg);
    }

    private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$assertStillUp() throws IllegalStateException {
        if (this.isShutDown) {
            throw new IllegalStateException("Manager is shut down.");
        }
    }

    private final ClientConnectionRequest $$robo$$org_apache_http_impl_conn_SingleClientConnManager$requestConnection(HttpRoute route, Object state) {
        return new ClientConnectionRequest(this, route, state){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ HttpRoute val$route;
            /* synthetic */ Object val$state;
            /* synthetic */ SingleClientConnManager this$0;

            private void $$robo$$org_apache_http_impl_conn_SingleClientConnManager_1$__constructor__(SingleClientConnManager singleClientConnManager, HttpRoute httpRoute, Object object) {
            }

            private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager_1$abortRequest() {
            }

            private final ManagedClientConnection $$robo$$org_apache_http_impl_conn_SingleClientConnManager_1$getConnection(long timeout, TimeUnit tunit) {
                return this.this$0.getConnection(this.val$route, this.val$state);
            }

            private void __constructor__(SingleClientConnManager singleClientConnManager, HttpRoute httpRoute, Object object) {
                this.$$robo$$org_apache_http_impl_conn_SingleClientConnManager_1$__constructor__(singleClientConnManager, httpRoute, object);
            }
            {
                this.this$0 = singleClientConnManager;
                this.val$route = httpRoute;
                this.val$state = object;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_SingleClientConnManager_1$__constructor__(org.apache.http.impl.conn.SingleClientConnManager org.apache.http.conn.routing.HttpRoute java.lang.Object ), 0, this, singleClientConnManager, httpRoute, object);
            }

            @Override
            public void abortRequest() {
                InvokeDynamicSupport.bootstrap("abortRequest", $$robo$$org_apache_http_impl_conn_SingleClientConnManager_1$abortRequest(), 0, this);
            }

            @Override
            public ManagedClientConnection getConnection(long l, TimeUnit timeUnit) {
                return InvokeDynamicSupport.bootstrap("getConnection", $$robo$$org_apache_http_impl_conn_SingleClientConnManager_1$getConnection(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final ManagedClientConnection $$robo$$org_apache_http_impl_conn_SingleClientConnManager$getConnection(HttpRoute route, Object state) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null.");
        }
        this.assertStillUp();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Get connection for route " + route);
        }
        if (this.managedConn != null) {
            this.revokeConnection();
        }
        boolean recreate = false;
        boolean shutdown = false;
        this.closeExpiredConnections();
        if (this.uniquePoolEntry.connection.isOpen()) {
            RouteTracker tracker = this.uniquePoolEntry.tracker;
            shutdown = tracker == null || !tracker.toRoute().equals(route);
        } else {
            recreate = true;
        }
        if (shutdown) {
            recreate = true;
            try {
                this.uniquePoolEntry.shutdown();
            }
            catch (IOException iox) {
                this.log.debug("Problem shutting down connection.", iox);
            }
        }
        if (recreate) {
            this.uniquePoolEntry = new PoolEntry(this);
        }
        try {
            Socket socket = this.uniquePoolEntry.connection.getSocket();
            if (socket != null) {
                SocketTagger.get().tag(socket);
            }
        }
        catch (IOException iox) {
            this.log.debug("Problem tagging socket.", iox);
        }
        this.managedConn = new ConnAdapter(this, this.uniquePoolEntry, route);
        return this.managedConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
        this.assertStillUp();
        if (!(conn instanceof ConnAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Releasing connection " + conn);
        }
        ConnAdapter sca = (ConnAdapter)conn;
        if (sca.poolEntry == null) {
            return;
        }
        ClientConnectionManager manager = sca.getManager();
        if (manager != null && manager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        try {
            Socket socket = this.uniquePoolEntry.connection.getSocket();
            if (socket != null) {
                SocketTagger.get().untag(socket);
            }
            if (sca.isOpen() && (this.alwaysShutDown || !sca.isMarkedReusable())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Released connection open but not reusable.");
                }
                sca.shutdown();
            }
        }
        catch (IOException iox) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Exception shutting down released connection.", iox);
            }
        }
        finally {
            sca.detach();
            this.managedConn = null;
            this.lastReleaseTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.connectionExpiresTime = validDuration > 0L ? timeUnit.toMillis(validDuration) + this.lastReleaseTime : Long.MAX_VALUE;
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$closeExpiredConnections() {
        if (InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") >= this.connectionExpiresTime) {
            this.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$closeIdleConnections(long idletime, TimeUnit tunit) {
        reference var4_3;
        this.assertStillUp();
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        if (this.managedConn == null && this.uniquePoolEntry.connection.isOpen() && this.lastReleaseTime <= (var4_3 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - tunit.toMillis(idletime))) {
            try {
                this.uniquePoolEntry.close();
            }
            catch (IOException iox) {
                this.log.debug("Problem closing idle connection.", iox);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$shutdown() {
        this.isShutDown = true;
        if (this.managedConn != null) {
            this.managedConn.detach();
        }
        try {
            if (this.uniquePoolEntry != null) {
                this.uniquePoolEntry.shutdown();
            }
        }
        catch (IOException iox) {
            this.log.debug("Problem while shutting down manager.", iox);
        }
        finally {
            this.uniquePoolEntry = null;
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager$revokeConnection() {
        if (this.managedConn == null) {
            return;
        }
        this.log.warn("Invalid use of SingleClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.");
        this.managedConn.detach();
        try {
            this.uniquePoolEntry.shutdown();
        }
        catch (IOException iox) {
            this.log.debug("Problem while shutting down connection.", iox);
        }
    }

    private void __constructor__(HttpParams httpParams, SchemeRegistry schemeRegistry) {
        this.$$robo$$org_apache_http_impl_conn_SingleClientConnManager$__constructor__(httpParams, schemeRegistry);
    }

    public SingleClientConnManager(HttpParams httpParams, SchemeRegistry schemeRegistry) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$__constructor__(org.apache.http.params.HttpParams org.apache.http.conn.scheme.SchemeRegistry ), 0, this, httpParams, schemeRegistry);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$finalize(), 0, this);
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return InvokeDynamicSupport.bootstrap("getSchemeRegistry", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$getSchemeRegistry(), 0, this);
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schemeRegistry) {
        return InvokeDynamicSupport.bootstrap("createConnectionOperator", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$createConnectionOperator(org.apache.http.conn.scheme.SchemeRegistry ), 0, this, schemeRegistry);
    }

    protected void assertStillUp() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("assertStillUp", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$assertStillUp(), 0, this);
    }

    @Override
    public ClientConnectionRequest requestConnection(HttpRoute httpRoute, Object object) {
        return InvokeDynamicSupport.bootstrap("requestConnection", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$requestConnection(org.apache.http.conn.routing.HttpRoute java.lang.Object ), 0, this, httpRoute, object);
    }

    public ManagedClientConnection getConnection(HttpRoute httpRoute, Object object) {
        return InvokeDynamicSupport.bootstrap("getConnection", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$getConnection(org.apache.http.conn.routing.HttpRoute java.lang.Object ), 0, this, httpRoute, object);
    }

    @Override
    public void releaseConnection(ManagedClientConnection managedClientConnection, long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("releaseConnection", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$releaseConnection(org.apache.http.conn.ManagedClientConnection long java.util.concurrent.TimeUnit ), 0, this, managedClientConnection, l, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        InvokeDynamicSupport.bootstrap("closeExpiredConnections", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$closeExpiredConnections(), 0, this);
    }

    @Override
    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("closeIdleConnections", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$closeIdleConnections(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
    }

    @Override
    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$shutdown(), 0, this);
    }

    protected void revokeConnection() {
        InvokeDynamicSupport.bootstrap("revokeConnection", $$robo$$org_apache_http_impl_conn_SingleClientConnManager$revokeConnection(), 0, this);
    }

    public /* synthetic */ SingleClientConnManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SingleClientConnManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    protected class ConnAdapter
    extends AbstractPooledConnAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SingleClientConnManager this$0;

        private void $$robo$$org_apache_http_impl_conn_SingleClientConnManager_ConnAdapter$__constructor__(SingleClientConnManager singleClientConnManager, PoolEntry entry, HttpRoute route) {
            this.markReusable();
            entry.route = route;
        }

        private void __constructor__(SingleClientConnManager singleClientConnManager, PoolEntry poolEntry, HttpRoute httpRoute) {
            this.$$robo$$org_apache_http_impl_conn_SingleClientConnManager_ConnAdapter$__constructor__(singleClientConnManager, poolEntry, httpRoute);
        }

        protected ConnAdapter(SingleClientConnManager singleClientConnManager, PoolEntry poolEntry, HttpRoute httpRoute) {
            this.this$0 = singleClientConnManager;
            super((ClientConnectionManager)singleClientConnManager, poolEntry);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_SingleClientConnManager_ConnAdapter$__constructor__(org.apache.http.impl.conn.SingleClientConnManager org.apache.http.impl.conn.SingleClientConnManager$PoolEntry org.apache.http.conn.routing.HttpRoute ), 0, this, singleClientConnManager, poolEntry, httpRoute);
        }

        public /* synthetic */ ConnAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected class PoolEntry
    extends AbstractPoolEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SingleClientConnManager this$0;

        private void $$robo$$org_apache_http_impl_conn_SingleClientConnManager_PoolEntry$__constructor__(SingleClientConnManager singleClientConnManager) {
        }

        private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager_PoolEntry$close() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.close();
            }
        }

        private final void $$robo$$org_apache_http_impl_conn_SingleClientConnManager_PoolEntry$shutdown() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.shutdown();
            }
        }

        private void __constructor__(SingleClientConnManager singleClientConnManager) {
            this.$$robo$$org_apache_http_impl_conn_SingleClientConnManager_PoolEntry$__constructor__(singleClientConnManager);
        }

        protected PoolEntry(SingleClientConnManager singleClientConnManager) {
            this.this$0 = singleClientConnManager;
            super(singleClientConnManager.connOperator, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_SingleClientConnManager_PoolEntry$__constructor__(org.apache.http.impl.conn.SingleClientConnManager ), 0, this, singleClientConnManager);
        }

        protected void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_impl_conn_SingleClientConnManager_PoolEntry$close(), 0, this);
        }

        protected void shutdown() throws IOException {
            InvokeDynamicSupport.bootstrap("shutdown", $$robo$$org_apache_http_impl_conn_SingleClientConnManager_PoolEntry$shutdown(), 0, this);
        }

        public /* synthetic */ PoolEntry() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PoolEntry)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

