/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.IdleConnectionHandler;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPoolEntryRef;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RefQueueHandler;
import org.apache.http.impl.conn.tsccm.RefQueueWorker;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractConnPool
implements RefQueueHandler,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    protected Lock poolLock;
    protected Set<BasicPoolEntryRef> issuedConnections;
    protected IdleConnectionHandler idleConnHandler;
    protected int numConnections;
    protected ReferenceQueue<Object> refQueue;
    private RefQueueWorker refWorker;
    protected volatile boolean isShutDown;

    private void $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$__constructor__() {
        this.log = LogFactory.getLog(this.getClass());
        this.issuedConnections = new HashSet<BasicPoolEntryRef>();
        this.idleConnHandler = new IdleConnectionHandler();
        boolean fair = false;
        this.poolLock = new ReentrantLock(fair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$enableConnectionGC() throws IllegalStateException {
        if (this.refQueue != null) {
            throw new IllegalStateException("Connection GC already enabled.");
        }
        this.poolLock.lock();
        try {
            if (this.numConnections > 0) {
                throw new IllegalStateException("Pool already in use.");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        this.refQueue = new ReferenceQueue();
        this.refWorker = new RefQueueWorker(this.refQueue, this);
        Thread t = new Thread(this.refWorker);
        t.setDaemon(true);
        t.setName("RefQueueWorker@" + this);
        t.start();
    }

    private final BasicPoolEntry $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$getEntry(HttpRoute route, Object state, long timeout, TimeUnit tunit) throws ConnectionPoolTimeoutException, InterruptedException {
        return this.requestPoolEntry(route, state).getPoolEntry(timeout, tunit);
    }

    public abstract PoolEntryRequest requestPoolEntry(HttpRoute var1, Object var2);

    public abstract void freeEntry(BasicPoolEntry var1, boolean var2, long var3, TimeUnit var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$handleReference(Reference ref) {
        this.poolLock.lock();
        try {
            boolean lost;
            if (ref instanceof BasicPoolEntryRef && (lost = this.issuedConnections.remove(ref))) {
                HttpRoute route = ((BasicPoolEntryRef)ref).getRoute();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connection garbage collected. " + route);
                }
                this.handleLostEntry(route);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected abstract void handleLostEntry(HttpRoute var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$closeIdleConnections(long idletime, TimeUnit tunit) {
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        this.poolLock.lock();
        try {
            this.idleConnHandler.closeIdleConnections(tunit.toMillis(idletime));
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$closeExpiredConnections() {
        this.poolLock.lock();
        try {
            this.idleConnHandler.closeExpiredConnections();
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public abstract void deleteClosedConnections();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$shutdown() {
        this.poolLock.lock();
        try {
            if (this.isShutDown) {
                return;
            }
            if (this.refWorker != null) {
                this.refWorker.shutdown();
            }
            Iterator<BasicPoolEntryRef> iter = this.issuedConnections.iterator();
            while (iter.hasNext()) {
                BasicPoolEntryRef per = iter.next();
                iter.remove();
                BasicPoolEntry entry = (BasicPoolEntry)per.get();
                if (entry == null) continue;
                this.closeConnection(entry.getConnection());
            }
            this.idleConnHandler.removeAll();
            this.isShutDown = true;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$closeConnection(OperatedClientConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.log.debug("I/O error closing connection", ex);
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$__constructor__();
    }

    protected AbstractConnPool() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$__constructor__(), 0, this);
    }

    public void enableConnectionGC() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("enableConnectionGC", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$enableConnectionGC(), 0, this);
    }

    public BasicPoolEntry getEntry(HttpRoute httpRoute, Object object, long l, TimeUnit timeUnit) throws ConnectionPoolTimeoutException, InterruptedException {
        return InvokeDynamicSupport.bootstrap("getEntry", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$getEntry(org.apache.http.conn.routing.HttpRoute java.lang.Object long java.util.concurrent.TimeUnit ), 0, this, httpRoute, object, l, timeUnit);
    }

    public void handleReference(Reference reference) {
        InvokeDynamicSupport.bootstrap("handleReference", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$handleReference(java.lang.ref.Reference ), 0, this, reference);
    }

    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("closeIdleConnections", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$closeIdleConnections(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
    }

    public void closeExpiredConnections() {
        InvokeDynamicSupport.bootstrap("closeExpiredConnections", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$closeExpiredConnections(), 0, this);
    }

    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$shutdown(), 0, this);
    }

    protected void closeConnection(OperatedClientConnection operatedClientConnection) {
        InvokeDynamicSupport.bootstrap("closeConnection", $$robo$$org_apache_http_impl_conn_tsccm_AbstractConnPool$closeConnection(org.apache.http.conn.OperatedClientConnection ), 0, this, operatedClientConnection);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractConnPool)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

