/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.apache.http.impl.conn.tsccm.WaitingThreadAborter;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnPoolByRoute
extends AbstractConnPool
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    protected ClientConnectionOperator operator;
    protected Queue<BasicPoolEntry> freeConnections;
    protected Queue<WaitingThread> waitingThreads;
    protected Map<HttpRoute, RouteSpecificPool> routeToPool;
    protected int maxTotalConnections;
    private ConnPerRoute connPerRoute;

    private void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$__constructor__(ClientConnectionOperator operator, HttpParams params) {
        this.log = LogFactory.getLog(this.getClass());
        if (operator == null) {
            throw new IllegalArgumentException("Connection operator may not be null");
        }
        this.operator = operator;
        this.freeConnections = this.createFreeConnQueue();
        this.waitingThreads = this.createWaitingThreadQueue();
        this.routeToPool = this.createRouteToPoolMap();
        this.maxTotalConnections = ConnManagerParams.getMaxTotalConnections(params);
        this.connPerRoute = ConnManagerParams.getMaxConnectionsPerRoute(params);
    }

    private final Queue<BasicPoolEntry> $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createFreeConnQueue() {
        return new LinkedList<BasicPoolEntry>();
    }

    private final Queue<WaitingThread> $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createWaitingThreadQueue() {
        return new LinkedList<WaitingThread>();
    }

    private final Map<HttpRoute, RouteSpecificPool> $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createRouteToPoolMap() {
        return new HashMap<HttpRoute, RouteSpecificPool>();
    }

    private final RouteSpecificPool $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$newRouteSpecificPool(HttpRoute route) {
        return new RouteSpecificPool(route, this.connPerRoute.getMaxForRoute(route));
    }

    private final WaitingThread $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$newWaitingThread(Condition cond, RouteSpecificPool rospl) {
        return new WaitingThread(cond, rospl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RouteSpecificPool $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getRoutePool(HttpRoute route, boolean create) {
        RouteSpecificPool rospl = null;
        this.poolLock.lock();
        try {
            rospl = this.routeToPool.get(route);
            if (rospl == null && create) {
                rospl = this.newRouteSpecificPool(route);
                this.routeToPool.put(route, rospl);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return rospl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getConnectionsInPool(HttpRoute route) {
        this.poolLock.lock();
        try {
            RouteSpecificPool rospl = this.getRoutePool(route, false);
            int n = rospl != null ? rospl.getEntryCount() : 0;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    private final PoolEntryRequest $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$requestPoolEntry(HttpRoute route, Object state) {
        WaitingThreadAborter aborter = new WaitingThreadAborter();
        return new PoolEntryRequest(this, aborter, route, state){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ WaitingThreadAborter val$aborter;
            /* synthetic */ HttpRoute val$route;
            /* synthetic */ Object val$state;
            /* synthetic */ ConnPoolByRoute this$0;

            private void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute_1$__constructor__(ConnPoolByRoute connPoolByRoute, WaitingThreadAborter waitingThreadAborter, HttpRoute httpRoute, Object object) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute_1$abortRequest() {
                this.this$0.poolLock.lock();
                try {
                    this.val$aborter.abort();
                }
                finally {
                    this.this$0.poolLock.unlock();
                }
            }

            private final BasicPoolEntry $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute_1$getPoolEntry(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                return this.this$0.getEntryBlocking(this.val$route, this.val$state, timeout, tunit, this.val$aborter);
            }

            private void __constructor__(ConnPoolByRoute connPoolByRoute, WaitingThreadAborter waitingThreadAborter, HttpRoute httpRoute, Object object) {
                this.$$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute_1$__constructor__(connPoolByRoute, waitingThreadAborter, httpRoute, object);
            }
            {
                this.this$0 = connPoolByRoute;
                this.val$aborter = waitingThreadAborter;
                this.val$route = httpRoute;
                this.val$state = object;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute_1$__constructor__(org.apache.http.impl.conn.tsccm.ConnPoolByRoute org.apache.http.impl.conn.tsccm.WaitingThreadAborter org.apache.http.conn.routing.HttpRoute java.lang.Object ), 0, this, connPoolByRoute, waitingThreadAborter, httpRoute, object);
            }

            @Override
            public void abortRequest() {
                InvokeDynamicSupport.bootstrap("abortRequest", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute_1$abortRequest(), 0, this);
            }

            @Override
            public BasicPoolEntry getPoolEntry(long l, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                return InvokeDynamicSupport.bootstrap("getPoolEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute_1$getPoolEntry(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BasicPoolEntry $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getEntryBlocking(HttpRoute route, Object state, long timeout, TimeUnit tunit, WaitingThreadAborter aborter) throws ConnectionPoolTimeoutException, InterruptedException {
        Date deadline = null;
        if (timeout > 0L) {
            deadline = new Date((long)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") + tunit.toMillis(timeout)));
        }
        BasicPoolEntry entry = null;
        this.poolLock.lock();
        try {
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            WaitingThread waitingThread = null;
            while (entry == null) {
                boolean hasCapacity;
                if (this.isShutDown) {
                    throw new IllegalStateException("Connection pool shut down.");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Total connections kept alive: " + this.freeConnections.size());
                    this.log.debug("Total issued connections: " + this.issuedConnections.size());
                    this.log.debug("Total allocated connection: " + this.numConnections + " out of " + this.maxTotalConnections);
                }
                if ((entry = this.getFreeEntry(rospl, state)) != null) {
                    break;
                }
                boolean bl = hasCapacity = rospl.getCapacity() > 0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Available capacity: " + rospl.getCapacity() + " out of " + rospl.getMaxEntries() + " [" + route + "][" + state + "]");
                }
                if (hasCapacity && this.numConnections < this.maxTotalConnections) {
                    entry = this.createEntry(rospl, this.operator);
                    continue;
                }
                if (hasCapacity && !this.freeConnections.isEmpty()) {
                    this.deleteLeastUsedEntry();
                    entry = this.createEntry(rospl, this.operator);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Need to wait for connection [" + route + "][" + state + "]");
                }
                if (waitingThread == null) {
                    waitingThread = this.newWaitingThread(this.poolLock.newCondition(), rospl);
                    aborter.setWaitingThread(waitingThread);
                }
                boolean success = false;
                try {
                    rospl.queueThread(waitingThread);
                    this.waitingThreads.add(waitingThread);
                    success = waitingThread.await(deadline);
                }
                finally {
                    rospl.removeThread(waitingThread);
                    this.waitingThreads.remove(waitingThread);
                }
                if (success || deadline == null || deadline.getTime() > InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System")) continue;
                throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$freeEntry(BasicPoolEntry entry, boolean reusable, long validDuration, TimeUnit timeUnit) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Freeing connection [" + route + "][" + entry.getState() + "]");
        }
        this.poolLock.lock();
        try {
            if (this.isShutDown) {
                this.closeConnection(entry.getConnection());
                return;
            }
            this.issuedConnections.remove(entry.getWeakRef());
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            if (reusable) {
                rospl.freeEntry(entry);
                this.freeConnections.add(entry);
                this.idleConnHandler.add(entry.getConnection(), validDuration, timeUnit);
            } else {
                rospl.dropEntry();
                --this.numConnections;
            }
            this.notifyWaitingThread(rospl);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BasicPoolEntry $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getFreeEntry(RouteSpecificPool rospl, Object state) {
        BasicPoolEntry entry = null;
        this.poolLock.lock();
        try {
            boolean done = false;
            while (!done) {
                entry = rospl.allocEntry(state);
                if (entry != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Getting free connection [" + rospl.getRoute() + "][" + state + "]");
                    }
                    this.freeConnections.remove(entry);
                    boolean valid = this.idleConnHandler.remove(entry.getConnection());
                    if (!valid) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Closing expired free connection [" + rospl.getRoute() + "][" + state + "]");
                        }
                        this.closeConnection(entry.getConnection());
                        rospl.dropEntry();
                        --this.numConnections;
                        continue;
                    }
                    this.issuedConnections.add(entry.getWeakRef());
                    done = true;
                    continue;
                }
                done = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("No free connections [" + rospl.getRoute() + "][" + state + "]");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BasicPoolEntry $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating new connection [" + rospl.getRoute() + "]");
        }
        BasicPoolEntry entry = new BasicPoolEntry(op, rospl.getRoute(), this.refQueue);
        this.poolLock.lock();
        try {
            rospl.createdEntry(entry);
            ++this.numConnections;
            this.issuedConnections.add(entry.getWeakRef());
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$deleteEntry(BasicPoolEntry entry) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting connection [" + route + "][" + entry.getState() + "]");
        }
        this.poolLock.lock();
        try {
            this.closeConnection(entry.getConnection());
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.deleteEntry(entry);
            --this.numConnections;
            if (rospl.isUnused()) {
                this.routeToPool.remove(route);
            }
            this.idleConnHandler.remove(entry.getConnection());
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$deleteLeastUsedEntry() {
        try {
            this.poolLock.lock();
            BasicPoolEntry entry = this.freeConnections.remove();
            if (entry != null) {
                this.deleteEntry(entry);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("No free connection to delete.");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$handleLostEntry(HttpRoute route) {
        this.poolLock.lock();
        try {
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.dropEntry();
            if (rospl.isUnused()) {
                this.routeToPool.remove(route);
            }
            --this.numConnections;
            this.notifyWaitingThread(rospl);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$notifyWaitingThread(RouteSpecificPool rospl) {
        WaitingThread waitingThread = null;
        this.poolLock.lock();
        try {
            if (rospl != null && rospl.hasThread()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying thread waiting on pool [" + rospl.getRoute() + "]");
                }
                waitingThread = rospl.nextThread();
            } else if (!this.waitingThreads.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying thread waiting on any pool");
                }
                waitingThread = this.waitingThreads.remove();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.wakeup();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$deleteClosedConnections() {
        this.poolLock.lock();
        try {
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)iter.next();
                if (entry.getConnection().isOpen()) continue;
                iter.remove();
                this.deleteEntry(entry);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$shutdown() {
        this.poolLock.lock();
        try {
            super.shutdown();
            Iterator ibpe = this.freeConnections.iterator();
            while (ibpe.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)ibpe.next();
                ibpe.remove();
                this.closeConnection(entry.getConnection());
            }
            Iterator iwth = this.waitingThreads.iterator();
            while (iwth.hasNext()) {
                WaitingThread waiter = (WaitingThread)iwth.next();
                iwth.remove();
                waiter.wakeup();
            }
            this.routeToPool.clear();
        }
        finally {
            this.poolLock.unlock();
        }
    }

    private void __constructor__(ClientConnectionOperator clientConnectionOperator, HttpParams httpParams) {
        this.$$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$__constructor__(clientConnectionOperator, httpParams);
    }

    public ConnPoolByRoute(ClientConnectionOperator clientConnectionOperator, HttpParams httpParams) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$__constructor__(org.apache.http.conn.ClientConnectionOperator org.apache.http.params.HttpParams ), 0, this, clientConnectionOperator, httpParams);
    }

    protected Queue<BasicPoolEntry> createFreeConnQueue() {
        return InvokeDynamicSupport.bootstrap("createFreeConnQueue", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createFreeConnQueue(), 0, this);
    }

    protected Queue<WaitingThread> createWaitingThreadQueue() {
        return InvokeDynamicSupport.bootstrap("createWaitingThreadQueue", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createWaitingThreadQueue(), 0, this);
    }

    protected Map<HttpRoute, RouteSpecificPool> createRouteToPoolMap() {
        return InvokeDynamicSupport.bootstrap("createRouteToPoolMap", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createRouteToPoolMap(), 0, this);
    }

    protected RouteSpecificPool newRouteSpecificPool(HttpRoute httpRoute) {
        return InvokeDynamicSupport.bootstrap("newRouteSpecificPool", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$newRouteSpecificPool(org.apache.http.conn.routing.HttpRoute ), 0, this, httpRoute);
    }

    protected WaitingThread newWaitingThread(Condition condition, RouteSpecificPool routeSpecificPool) {
        return InvokeDynamicSupport.bootstrap("newWaitingThread", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$newWaitingThread(java.util.concurrent.locks.Condition org.apache.http.impl.conn.tsccm.RouteSpecificPool ), 0, this, condition, routeSpecificPool);
    }

    protected RouteSpecificPool getRoutePool(HttpRoute httpRoute, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getRoutePool", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getRoutePool(org.apache.http.conn.routing.HttpRoute boolean ), 0, this, httpRoute, bl);
    }

    public int getConnectionsInPool(HttpRoute httpRoute) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionsInPool", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getConnectionsInPool(org.apache.http.conn.routing.HttpRoute ), 0, this, httpRoute);
    }

    @Override
    public PoolEntryRequest requestPoolEntry(HttpRoute httpRoute, Object object) {
        return InvokeDynamicSupport.bootstrap("requestPoolEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$requestPoolEntry(org.apache.http.conn.routing.HttpRoute java.lang.Object ), 0, this, httpRoute, object);
    }

    protected BasicPoolEntry getEntryBlocking(HttpRoute httpRoute, Object object, long l, TimeUnit timeUnit, WaitingThreadAborter waitingThreadAborter) throws ConnectionPoolTimeoutException, InterruptedException {
        return InvokeDynamicSupport.bootstrap("getEntryBlocking", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getEntryBlocking(org.apache.http.conn.routing.HttpRoute java.lang.Object long java.util.concurrent.TimeUnit org.apache.http.impl.conn.tsccm.WaitingThreadAborter ), 0, this, httpRoute, object, l, timeUnit, waitingThreadAborter);
    }

    @Override
    public void freeEntry(BasicPoolEntry basicPoolEntry, boolean bl, long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("freeEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$freeEntry(org.apache.http.impl.conn.tsccm.BasicPoolEntry boolean long java.util.concurrent.TimeUnit ), 0, this, basicPoolEntry, bl, l, timeUnit);
    }

    protected BasicPoolEntry getFreeEntry(RouteSpecificPool routeSpecificPool, Object object) {
        return InvokeDynamicSupport.bootstrap("getFreeEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$getFreeEntry(org.apache.http.impl.conn.tsccm.RouteSpecificPool java.lang.Object ), 0, this, routeSpecificPool, object);
    }

    protected BasicPoolEntry createEntry(RouteSpecificPool routeSpecificPool, ClientConnectionOperator clientConnectionOperator) {
        return InvokeDynamicSupport.bootstrap("createEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$createEntry(org.apache.http.impl.conn.tsccm.RouteSpecificPool org.apache.http.conn.ClientConnectionOperator ), 0, this, routeSpecificPool, clientConnectionOperator);
    }

    protected void deleteEntry(BasicPoolEntry basicPoolEntry) {
        InvokeDynamicSupport.bootstrap("deleteEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$deleteEntry(org.apache.http.impl.conn.tsccm.BasicPoolEntry ), 0, this, basicPoolEntry);
    }

    protected void deleteLeastUsedEntry() {
        InvokeDynamicSupport.bootstrap("deleteLeastUsedEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$deleteLeastUsedEntry(), 0, this);
    }

    @Override
    protected void handleLostEntry(HttpRoute httpRoute) {
        InvokeDynamicSupport.bootstrap("handleLostEntry", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$handleLostEntry(org.apache.http.conn.routing.HttpRoute ), 0, this, httpRoute);
    }

    protected void notifyWaitingThread(RouteSpecificPool routeSpecificPool) {
        InvokeDynamicSupport.bootstrap("notifyWaitingThread", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$notifyWaitingThread(org.apache.http.impl.conn.tsccm.RouteSpecificPool ), 0, this, routeSpecificPool);
    }

    @Override
    public void deleteClosedConnections() {
        InvokeDynamicSupport.bootstrap("deleteClosedConnections", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$deleteClosedConnections(), 0, this);
    }

    @Override
    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$org_apache_http_impl_conn_tsccm_ConnPoolByRoute$shutdown(), 0, this);
    }

    public /* synthetic */ ConnPoolByRoute() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnPoolByRoute)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

