/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.apache.http.util.LangUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RouteSpecificPool
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    protected HttpRoute route;
    protected int maxEntries;
    protected LinkedList<BasicPoolEntry> freeEntries;
    protected Queue<WaitingThread> waitingThreads;
    protected int numEntries;

    private void $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$__constructor__(HttpRoute route, int maxEntries) {
        this.log = LogFactory.getLog(this.getClass());
        this.route = route;
        this.maxEntries = maxEntries;
        this.freeEntries = new LinkedList();
        this.waitingThreads = new LinkedList<WaitingThread>();
        this.numEntries = 0;
    }

    private final HttpRoute $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getRoute() {
        return this.route;
    }

    private final int $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getMaxEntries() {
        return this.maxEntries;
    }

    private final boolean $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$isUnused() {
        return this.numEntries < 1 && this.waitingThreads.isEmpty();
    }

    private final int $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getCapacity() {
        return this.maxEntries - this.numEntries;
    }

    private final int $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getEntryCount() {
        return this.numEntries;
    }

    private final BasicPoolEntry $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$allocEntry(Object state) {
        if (!this.freeEntries.isEmpty()) {
            ListIterator<BasicPoolEntry> it = this.freeEntries.listIterator(this.freeEntries.size());
            while (it.hasPrevious()) {
                BasicPoolEntry entry = it.previous();
                if (!LangUtils.equals(state, entry.getState())) continue;
                it.remove();
                return entry;
            }
        }
        if (!this.freeEntries.isEmpty()) {
            BasicPoolEntry entry = this.freeEntries.remove();
            entry.setState(null);
            OperatedClientConnection conn = entry.getConnection();
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.log.debug("I/O error closing connection", ex);
            }
            return entry;
        }
        return null;
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$freeEntry(BasicPoolEntry entry) {
        if (this.numEntries < 1) {
            throw new IllegalStateException("No entry created for this pool. " + this.route);
        }
        if (this.numEntries <= this.freeEntries.size()) {
            throw new IllegalStateException("No entry allocated from this pool. " + this.route);
        }
        this.freeEntries.add(entry);
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$createdEntry(BasicPoolEntry entry) {
        if (!this.route.equals(entry.getPlannedRoute())) {
            throw new IllegalArgumentException("Entry not planned for this pool.\npool: " + this.route + "\nplan: " + entry.getPlannedRoute());
        }
        ++this.numEntries;
    }

    private final boolean $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$deleteEntry(BasicPoolEntry entry) {
        boolean found = this.freeEntries.remove(entry);
        if (found) {
            --this.numEntries;
        }
        return found;
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$dropEntry() {
        if (this.numEntries < 1) {
            throw new IllegalStateException("There is no entry that could be dropped.");
        }
        --this.numEntries;
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$queueThread(WaitingThread wt) {
        if (wt == null) {
            throw new IllegalArgumentException("Waiting thread must not be null.");
        }
        this.waitingThreads.add(wt);
    }

    private final boolean $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$hasThread() {
        return !this.waitingThreads.isEmpty();
    }

    private final WaitingThread $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$nextThread() {
        return this.waitingThreads.peek();
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$removeThread(WaitingThread wt) {
        if (wt == null) {
            return;
        }
        this.waitingThreads.remove(wt);
    }

    private void __constructor__(HttpRoute httpRoute, int n) {
        this.$$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$__constructor__(httpRoute, n);
    }

    public RouteSpecificPool(HttpRoute httpRoute, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$__constructor__(org.apache.http.conn.routing.HttpRoute int ), 0, this, httpRoute, n);
    }

    public HttpRoute getRoute() {
        return InvokeDynamicSupport.bootstrap("getRoute", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getRoute(), 0, this);
    }

    public int getMaxEntries() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxEntries", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getMaxEntries(), 0, this);
    }

    public boolean isUnused() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnused", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$isUnused(), 0, this);
    }

    public int getCapacity() {
        return (int)InvokeDynamicSupport.bootstrap("getCapacity", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getCapacity(), 0, this);
    }

    public int getEntryCount() {
        return (int)InvokeDynamicSupport.bootstrap("getEntryCount", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$getEntryCount(), 0, this);
    }

    public BasicPoolEntry allocEntry(Object object) {
        return InvokeDynamicSupport.bootstrap("allocEntry", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$allocEntry(java.lang.Object ), 0, this, object);
    }

    public void freeEntry(BasicPoolEntry basicPoolEntry) {
        InvokeDynamicSupport.bootstrap("freeEntry", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$freeEntry(org.apache.http.impl.conn.tsccm.BasicPoolEntry ), 0, this, basicPoolEntry);
    }

    public void createdEntry(BasicPoolEntry basicPoolEntry) {
        InvokeDynamicSupport.bootstrap("createdEntry", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$createdEntry(org.apache.http.impl.conn.tsccm.BasicPoolEntry ), 0, this, basicPoolEntry);
    }

    public boolean deleteEntry(BasicPoolEntry basicPoolEntry) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteEntry", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$deleteEntry(org.apache.http.impl.conn.tsccm.BasicPoolEntry ), 0, this, basicPoolEntry);
    }

    public void dropEntry() {
        InvokeDynamicSupport.bootstrap("dropEntry", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$dropEntry(), 0, this);
    }

    public void queueThread(WaitingThread waitingThread) {
        InvokeDynamicSupport.bootstrap("queueThread", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$queueThread(org.apache.http.impl.conn.tsccm.WaitingThread ), 0, this, waitingThread);
    }

    public boolean hasThread() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasThread", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$hasThread(), 0, this);
    }

    public WaitingThread nextThread() {
        return InvokeDynamicSupport.bootstrap("nextThread", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$nextThread(), 0, this);
    }

    public void removeThread(WaitingThread waitingThread) {
        InvokeDynamicSupport.bootstrap("removeThread", $$robo$$org_apache_http_impl_conn_tsccm_RouteSpecificPool$removeThread(org.apache.http.impl.conn.tsccm.WaitingThread ), 0, this, waitingThread);
    }

    public /* synthetic */ RouteSpecificPool() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouteSpecificPool)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

