/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import dalvik.system.SocketTagger;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPooledConnAdapter;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ThreadSafeClientConnManager
implements ClientConnectionManager,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Log log;
    protected SchemeRegistry schemeRegistry;
    protected AbstractConnPool connectionPool;
    protected ClientConnectionOperator connOperator;

    private void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$__constructor__(HttpParams params, SchemeRegistry schreg) {
        this.log = LogFactory.getLog(this.getClass());
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.schemeRegistry = schreg;
        this.connOperator = this.createConnectionOperator(schreg);
        this.connectionPool = this.createConnectionPool(params);
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    private final AbstractConnPool $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$createConnectionPool(HttpParams params) {
        ConnPoolByRoute acp = new ConnPoolByRoute(this.connOperator, params);
        boolean conngc = true;
        if (conngc) {
            acp.enableConnectionGC();
        }
        return acp;
    }

    private final ClientConnectionOperator $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$createConnectionOperator(SchemeRegistry schreg) {
        return new DefaultClientConnectionOperator(schreg);
    }

    private final SchemeRegistry $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$getSchemeRegistry() {
        return this.schemeRegistry;
    }

    private final ClientConnectionRequest $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$requestConnection(HttpRoute route, Object state) {
        PoolEntryRequest poolRequest = this.connectionPool.requestPoolEntry(route, state);
        return new ClientConnectionRequest(this, poolRequest, route){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PoolEntryRequest val$poolRequest;
            /* synthetic */ HttpRoute val$route;
            /* synthetic */ ThreadSafeClientConnManager this$0;

            private void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager_1$__constructor__(ThreadSafeClientConnManager threadSafeClientConnManager, PoolEntryRequest poolEntryRequest, HttpRoute httpRoute) {
            }

            private final void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager_1$abortRequest() {
                this.val$poolRequest.abortRequest();
            }

            private final ManagedClientConnection $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager_1$getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                if (this.val$route == null) {
                    throw new IllegalArgumentException("Route may not be null.");
                }
                if (this.this$0.log.isDebugEnabled()) {
                    this.this$0.log.debug("ThreadSafeClientConnManager.getConnection: " + this.val$route + ", timeout = " + timeout);
                }
                BasicPoolEntry entry = this.val$poolRequest.getPoolEntry(timeout, tunit);
                try {
                    Socket socket = entry.getConnection().getSocket();
                    if (socket != null) {
                        SocketTagger.get().tag(socket);
                    }
                }
                catch (IOException iox) {
                    this.this$0.log.debug("Problem tagging socket.", iox);
                }
                return new BasicPooledConnAdapter(this.this$0, (AbstractPoolEntry)entry);
            }

            private void __constructor__(ThreadSafeClientConnManager threadSafeClientConnManager, PoolEntryRequest poolEntryRequest, HttpRoute httpRoute) {
                this.$$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager_1$__constructor__(threadSafeClientConnManager, poolEntryRequest, httpRoute);
            }
            {
                this.this$0 = threadSafeClientConnManager;
                this.val$poolRequest = poolEntryRequest;
                this.val$route = httpRoute;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager_1$__constructor__(org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager org.apache.http.impl.conn.tsccm.PoolEntryRequest org.apache.http.conn.routing.HttpRoute ), 0, this, threadSafeClientConnManager, poolEntryRequest, httpRoute);
            }

            @Override
            public void abortRequest() {
                InvokeDynamicSupport.bootstrap("abortRequest", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager_1$abortRequest(), 0, this);
            }

            @Override
            public ManagedClientConnection getConnection(long l, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                return InvokeDynamicSupport.bootstrap("getConnection", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager_1$getConnection(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
        if (!(conn instanceof BasicPooledConnAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        BasicPooledConnAdapter hca = (BasicPooledConnAdapter)conn;
        if (hca.getPoolEntry() != null && hca.getManager() != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        try {
            BasicPoolEntry entry = (BasicPoolEntry)hca.getPoolEntry();
            Socket socket = entry.getConnection().getSocket();
            if (socket != null) {
                SocketTagger.get().untag(socket);
            }
            if (hca.isOpen() && !hca.isMarkedReusable()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Released connection open but not marked reusable.");
                }
                hca.shutdown();
            }
        }
        catch (IOException iox) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Exception shutting down released connection.", iox);
            }
        }
        finally {
            BasicPoolEntry entry = (BasicPoolEntry)hca.getPoolEntry();
            boolean reusable = hca.isMarkedReusable();
            hca.detach();
            if (entry != null) {
                this.connectionPool.freeEntry(entry, reusable, validDuration, timeUnit);
            }
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$shutdown() {
        this.connectionPool.shutdown();
    }

    private final int $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$getConnectionsInPool(HttpRoute route) {
        return ((ConnPoolByRoute)this.connectionPool).getConnectionsInPool(route);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$getConnectionsInPool() {
        AbstractConnPool abstractConnPool = this.connectionPool;
        synchronized (abstractConnPool) {
            return this.connectionPool.numConnections;
        }
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        this.connectionPool.closeIdleConnections(idleTimeout, tunit);
        this.connectionPool.deleteClosedConnections();
    }

    private final void $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$closeExpiredConnections() {
        this.connectionPool.closeExpiredConnections();
        this.connectionPool.deleteClosedConnections();
    }

    private void __constructor__(HttpParams httpParams, SchemeRegistry schemeRegistry) {
        this.$$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$__constructor__(httpParams, schemeRegistry);
    }

    public ThreadSafeClientConnManager(HttpParams httpParams, SchemeRegistry schemeRegistry) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$__constructor__(org.apache.http.params.HttpParams org.apache.http.conn.scheme.SchemeRegistry ), 0, this, httpParams, schemeRegistry);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$finalize(), 0, this);
    }

    protected AbstractConnPool createConnectionPool(HttpParams httpParams) {
        return InvokeDynamicSupport.bootstrap("createConnectionPool", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$createConnectionPool(org.apache.http.params.HttpParams ), 0, this, httpParams);
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schemeRegistry) {
        return InvokeDynamicSupport.bootstrap("createConnectionOperator", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$createConnectionOperator(org.apache.http.conn.scheme.SchemeRegistry ), 0, this, schemeRegistry);
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return InvokeDynamicSupport.bootstrap("getSchemeRegistry", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$getSchemeRegistry(), 0, this);
    }

    @Override
    public ClientConnectionRequest requestConnection(HttpRoute httpRoute, Object object) {
        return InvokeDynamicSupport.bootstrap("requestConnection", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$requestConnection(org.apache.http.conn.routing.HttpRoute java.lang.Object ), 0, this, httpRoute, object);
    }

    @Override
    public void releaseConnection(ManagedClientConnection managedClientConnection, long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("releaseConnection", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$releaseConnection(org.apache.http.conn.ManagedClientConnection long java.util.concurrent.TimeUnit ), 0, this, managedClientConnection, l, timeUnit);
    }

    @Override
    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$shutdown(), 0, this);
    }

    public int getConnectionsInPool(HttpRoute httpRoute) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionsInPool", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$getConnectionsInPool(org.apache.http.conn.routing.HttpRoute ), 0, this, httpRoute);
    }

    public int getConnectionsInPool() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionsInPool", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$getConnectionsInPool(), 0, this);
    }

    @Override
    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        InvokeDynamicSupport.bootstrap("closeIdleConnections", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$closeIdleConnections(long java.util.concurrent.TimeUnit ), 0, this, l, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        InvokeDynamicSupport.bootstrap("closeExpiredConnections", $$robo$$org_apache_http_impl_conn_tsccm_ThreadSafeClientConnManager$closeExpiredConnections(), 0, this);
    }

    public /* synthetic */ ThreadSafeClientConnManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadSafeClientConnManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

