/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.impl.cookie.NetscapeDraftSpec;
import org.apache.http.impl.cookie.RFC2965Spec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BestMatchSpec
implements CookieSpec,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String[] datepatterns;
    private boolean oneHeader;
    private RFC2965Spec strict;
    private BrowserCompatSpec compat;
    private NetscapeDraftSpec netscape;

    private void $$robo$$org_apache_http_impl_cookie_BestMatchSpec$__constructor__(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    private void $$robo$$org_apache_http_impl_cookie_BestMatchSpec$__constructor__() {
    }

    private final RFC2965Spec $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getStrict() {
        if (this.strict == null) {
            this.strict = new RFC2965Spec(this.datepatterns, this.oneHeader);
        }
        return this.strict;
    }

    private final BrowserCompatSpec $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getCompat() {
        if (this.compat == null) {
            this.compat = new BrowserCompatSpec(this.datepatterns);
        }
        return this.compat;
    }

    private final NetscapeDraftSpec $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getNetscape() {
        if (this.netscape == null) {
            String[] patterns = this.datepatterns;
            if (patterns == null) {
                patterns = BrowserCompatSpec.DATE_PATTERNS;
            }
            this.netscape = new NetscapeDraftSpec(patterns);
        }
        return this.netscape;
    }

    private final List<Cookie> $$robo$$org_apache_http_impl_cookie_BestMatchSpec$parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        HeaderElement[] helems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        for (HeaderElement helem : helems) {
            if (helem.getParameterByName("version") != null) {
                versioned = true;
            }
            if (helem.getParameterByName("expires") == null) continue;
            netscape = true;
        }
        if (netscape) {
            // empty if block
        }
        if (versioned) {
            return this.getStrict().parse(helems, origin);
        }
        if (netscape) {
            return this.getNetscape().parse(header, origin);
        }
        return this.getCompat().parse(helems, origin);
    }

    private final void $$robo$$org_apache_http_impl_cookie_BestMatchSpec$validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        if (cookie.getVersion() > 0) {
            this.getStrict().validate(cookie, origin);
        } else {
            this.getCompat().validate(cookie, origin);
        }
    }

    private final boolean $$robo$$org_apache_http_impl_cookie_BestMatchSpec$match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        if (cookie.getVersion() > 0) {
            return this.getStrict().match(cookie, origin);
        }
        return this.getCompat().match(cookie, origin);
    }

    private final List<Header> $$robo$$org_apache_http_impl_cookie_BestMatchSpec$formatCookies(List<Cookie> cookies) {
        if (cookies == null) {
            throw new IllegalArgumentException("List of cookie may not be null");
        }
        int version = Integer.MAX_VALUE;
        for (Cookie cookie : cookies) {
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        if (version > 0) {
            return this.getStrict().formatCookies(cookies);
        }
        return this.getCompat().formatCookies(cookies);
    }

    private final int $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getVersion() {
        return this.getStrict().getVersion();
    }

    private final Header $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getVersionHeader() {
        return this.getStrict().getVersionHeader();
    }

    private void __constructor__(String[] stringArray, boolean bl) {
        this.$$robo$$org_apache_http_impl_cookie_BestMatchSpec$__constructor__(stringArray, bl);
    }

    public BestMatchSpec(String[] stringArray, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$__constructor__(java.lang.String[] boolean ), 0, this, stringArray, bl);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_BestMatchSpec$__constructor__();
    }

    public BestMatchSpec() {
        this(null, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$__constructor__(), 0, this);
    }

    private RFC2965Spec getStrict() {
        return InvokeDynamicSupport.bootstrap("getStrict", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getStrict(), 0, this);
    }

    private BrowserCompatSpec getCompat() {
        return InvokeDynamicSupport.bootstrap("getCompat", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getCompat(), 0, this);
    }

    private NetscapeDraftSpec getNetscape() {
        return InvokeDynamicSupport.bootstrap("getNetscape", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getNetscape(), 0, this);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$parse(org.apache.http.Header org.apache.http.cookie.CookieOrigin ), 0, this, header, cookieOrigin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$validate(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$match(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> list) {
        return InvokeDynamicSupport.bootstrap("formatCookies", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$formatCookies(java.util.List<org.apache.http.cookie.Cookie> ), 0, this, list);
    }

    @Override
    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getVersion(), 0, this);
    }

    @Override
    public Header getVersionHeader() {
        return InvokeDynamicSupport.bootstrap("getVersionHeader", $$robo$$org_apache_http_impl_cookie_BestMatchSpec$getVersionHeader(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BestMatchSpec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

