/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BrowserCompatSpec
extends CookieSpecBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static String[] DATE_PATTERNS;
    private String[] datepatterns;

    private void $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$__constructor__(String[] datepatterns) {
        this.datepatterns = datepatterns != null ? (String[])datepatterns.clone() : DATE_PATTERNS;
        this.registerAttribHandler("path", new BasicPathHandler());
        this.registerAttribHandler("domain", new BasicDomainHandler());
        this.registerAttribHandler("max-age", new BasicMaxAgeHandler());
        this.registerAttribHandler("secure", new BasicSecureHandler());
        this.registerAttribHandler("comment", new BasicCommentHandler());
        this.registerAttribHandler("expires", new BasicExpiresHandler(this.datepatterns));
    }

    private void $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$__constructor__() {
    }

    private final List<Cookie> $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String headervalue = header.getValue();
        boolean isNetscapeCookie = false;
        int i1 = headervalue.toLowerCase(Locale.ENGLISH).indexOf("expires=");
        if (i1 != -1) {
            int i2 = headervalue.indexOf(59, i1 += "expires=".length());
            if (i2 == -1) {
                i2 = headervalue.length();
            }
            try {
                DateUtils.parseDate(headervalue.substring(i1, i2), this.datepatterns);
                isNetscapeCookie = true;
            }
            catch (DateParseException dateParseException) {
                // empty catch block
            }
        }
        HeaderElement[] elems = null;
        if (isNetscapeCookie) {
            ParserCursor cursor;
            CharArrayBuffer buffer;
            NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                cursor = new ParserCursor(0, buffer.length());
            }
            elems = new HeaderElement[]{parser.parseHeader(buffer, cursor)};
        } else {
            elems = header.getElements();
        }
        return this.parse(elems, origin);
    }

    private final List<Header> $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$formatCookies(List<Cookie> cookies) {
        if (cookies == null) {
            throw new IllegalArgumentException("List of cookies may not be null");
        }
        if (cookies.isEmpty()) {
            throw new IllegalArgumentException("List of cookies may not be empty");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer.append("; ");
            }
            buffer.append(cookie.getName());
            buffer.append("=");
            String s = cookie.getValue();
            if (s == null) continue;
            buffer.append(s);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    private final int $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$getVersion() {
        return 0;
    }

    private final Header $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$getVersionHeader() {
        return null;
    }

    static void __staticInitializer__() {
        DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z"};
    }

    private void __constructor__(String[] stringArray) {
        this.$$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$__constructor__(stringArray);
    }

    public BrowserCompatSpec(String[] stringArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$__constructor__(java.lang.String[] ), 0, this, stringArray);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$__constructor__();
    }

    public BrowserCompatSpec() {
        this(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$__constructor__(), 0, this);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$parse(org.apache.http.Header org.apache.http.cookie.CookieOrigin ), 0, this, header, cookieOrigin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> list) {
        return InvokeDynamicSupport.bootstrap("formatCookies", $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$formatCookies(java.util.List<org.apache.http.cookie.Cookie> ), 0, this, list);
    }

    @Override
    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$getVersion(), 0, this);
    }

    @Override
    public Header getVersionHeader() {
        return InvokeDynamicSupport.bootstrap("getVersionHeader", $$robo$$org_apache_http_impl_cookie_BrowserCompatSpec$getVersionHeader(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(BrowserCompatSpec.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BrowserCompatSpec)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

