/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.AbstractCookieSpec;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CookieSpecBase
extends AbstractCookieSpec
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$org_apache_http_impl_cookie_CookieSpecBase$__constructor__() {
    }

    private static final String $$robo$$org_apache_http_impl_cookie_CookieSpecBase$getDefaultPath(CookieOrigin origin) {
        String defaultPath = origin.getPath();
        int lastSlashIndex = defaultPath.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = defaultPath.substring(0, lastSlashIndex);
        }
        return defaultPath;
    }

    private static final String $$robo$$org_apache_http_impl_cookie_CookieSpecBase$getDefaultDomain(CookieOrigin origin) {
        return origin.getHost();
    }

    private final List<Cookie> $$robo$$org_apache_http_impl_cookie_CookieSpecBase$parse(HeaderElement[] elems, CookieOrigin origin) throws MalformedCookieException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(elems.length);
        for (HeaderElement headerelement : elems) {
            String name = headerelement.getName();
            String value = headerelement.getValue();
            if (name == null || name.length() == 0) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie cookie = new BasicClientCookie(name, value);
            cookie.setPath(CookieSpecBase.getDefaultPath(origin));
            cookie.setDomain(CookieSpecBase.getDefaultDomain(origin));
            NameValuePair[] attribs = headerelement.getParameters();
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair attrib = attribs[j];
                String s = attrib.getName().toLowerCase(Locale.ENGLISH);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            cookies.add(cookie);
        }
        return cookies;
    }

    private final void $$robo$$org_apache_http_impl_cookie_CookieSpecBase$validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        for (CookieAttributeHandler handler : this.getAttribHandlers()) {
            handler.validate(cookie, origin);
        }
    }

    private final boolean $$robo$$org_apache_http_impl_cookie_CookieSpecBase$match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        for (CookieAttributeHandler handler : this.getAttribHandlers()) {
            if (handler.match(cookie, origin)) continue;
            return false;
        }
        return true;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_CookieSpecBase$__constructor__();
    }

    public CookieSpecBase() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_CookieSpecBase$__constructor__(), 0, this);
    }

    protected static String getDefaultPath(CookieOrigin cookieOrigin) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultPath", $$robo$$org_apache_http_impl_cookie_CookieSpecBase$getDefaultPath(org.apache.http.cookie.CookieOrigin ), 0, (CookieOrigin)cookieOrigin);
    }

    protected static String getDefaultDomain(CookieOrigin cookieOrigin) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultDomain", $$robo$$org_apache_http_impl_cookie_CookieSpecBase$getDefaultDomain(org.apache.http.cookie.CookieOrigin ), 0, (CookieOrigin)cookieOrigin);
    }

    protected List<Cookie> parse(HeaderElement[] headerElementArray, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$org_apache_http_impl_cookie_CookieSpecBase$parse(org.apache.http.HeaderElement[] org.apache.http.cookie.CookieOrigin ), 0, this, headerElementArray, cookieOrigin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$org_apache_http_impl_cookie_CookieSpecBase$validate(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$org_apache_http_impl_cookie_CookieSpecBase$match(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CookieSpecBase)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

