/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.impl.cookie.DateParseException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DateUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static String[] DEFAULT_PATTERNS;
    private static Date DEFAULT_TWO_DIGIT_YEAR_START;
    public static TimeZone GMT;

    private static final Date $$robo$$org_apache_http_impl_cookie_DateUtils$parseDate(String dateValue) throws DateParseException {
        return DateUtils.parseDate(dateValue, null, null);
    }

    private static final Date $$robo$$org_apache_http_impl_cookie_DateUtils$parseDate(String dateValue, String[] dateFormats) throws DateParseException {
        return DateUtils.parseDate(dateValue, dateFormats, null);
    }

    private static final Date $$robo$$org_apache_http_impl_cookie_DateUtils$parseDate(String dateValue, String[] dateFormats, Date startDate) throws DateParseException {
        if (dateValue == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (dateFormats == null) {
            dateFormats = DEFAULT_PATTERNS;
        }
        if (startDate == null) {
            startDate = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        if (dateValue.length() > 1 && dateValue.startsWith("'") && dateValue.endsWith("'")) {
            dateValue = dateValue.substring(1, dateValue.length() - 1);
        }
        for (String dateFormat : dateFormats) {
            SimpleDateFormat dateParser = DateFormatHolder.formatFor(dateFormat);
            dateParser.set2DigitYearStart(startDate);
            try {
                return dateParser.parse(dateValue);
            }
            catch (ParseException parseException) {
            }
        }
        throw new DateParseException("Unable to parse the date " + dateValue);
    }

    private static final String $$robo$$org_apache_http_impl_cookie_DateUtils$formatDate(Date date) {
        return DateUtils.formatDate(date, "EEE, dd MMM yyyy HH:mm:ss zzz");
    }

    private static final String $$robo$$org_apache_http_impl_cookie_DateUtils$formatDate(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat formatter = DateFormatHolder.formatFor(pattern);
        return formatter.format(date);
    }

    private void $$robo$$org_apache_http_impl_cookie_DateUtils$__constructor__() {
    }

    static void __staticInitializer__() {
        DEFAULT_PATTERNS = new String[]{"EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
        GMT = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
    }

    public static Date parseDate(String string2) throws DateParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseDate", $$robo$$org_apache_http_impl_cookie_DateUtils$parseDate(java.lang.String ), 0, (String)string2);
    }

    public static Date parseDate(String string2, String[] stringArray) throws DateParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseDate", $$robo$$org_apache_http_impl_cookie_DateUtils$parseDate(java.lang.String java.lang.String[] ), 0, (String)string2, (String[])stringArray);
    }

    public static Date parseDate(String string2, String[] stringArray, Date date) throws DateParseException {
        return InvokeDynamicSupport.bootstrapStatic("parseDate", $$robo$$org_apache_http_impl_cookie_DateUtils$parseDate(java.lang.String java.lang.String[] java.util.Date ), 0, (String)string2, (String[])stringArray, (Date)date);
    }

    public static String formatDate(Date date) {
        return InvokeDynamicSupport.bootstrapStatic("formatDate", $$robo$$org_apache_http_impl_cookie_DateUtils$formatDate(java.util.Date ), 0, (Date)date);
    }

    public static String formatDate(Date date, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("formatDate", $$robo$$org_apache_http_impl_cookie_DateUtils$formatDate(java.util.Date java.lang.String ), 0, (Date)date, (String)string2);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_DateUtils$__constructor__();
    }

    private DateUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_DateUtils$__constructor__(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(DateUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DateFormatHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS;

        private void $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder$__constructor__() {
        }

        private static final SimpleDateFormat $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder$formatFor(String pattern) {
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> ref = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> formats = ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                formats.put(pattern, format);
            }
            return format;
        }

        static void __staticInitializer__() {
            THREADLOCAL_FORMATS = new ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder_1$__constructor__() {
                }

                private final SoftReference<Map<String, SimpleDateFormat>> $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder_1$initialValue() {
                    return new SoftReference<Map<String, SimpleDateFormat>>(new HashMap());
                }

                private void __constructor__() {
                    this.$$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder_1$__constructor__(), 0, this);
                }

                @Override
                protected SoftReference<Map<String, SimpleDateFormat>> initialValue() {
                    return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder_1$initialValue(), 0, this);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder$__constructor__();
        }

        DateFormatHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder$__constructor__(), 0, this);
        }

        public static SimpleDateFormat formatFor(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("formatFor", $$robo$$org_apache_http_impl_cookie_DateUtils_DateFormatHolder$formatFor(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(DateFormatHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateFormatHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

