/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetscapeDomainHandler
extends BasicDomainHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$__constructor__() {
    }

    private final void $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        super.validate(cookie, origin);
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (host.contains(".")) {
            int domainParts = new StringTokenizer(domain, ".").countTokens();
            if (NetscapeDomainHandler.isSpecialDomain(domain)) {
                if (domainParts < 2) {
                    throw new MalformedCookieException("Domain attribute \"" + domain + "\" violates the Netscape cookie specification for " + "special domains");
                }
            } else if (domainParts < 3) {
                throw new MalformedCookieException("Domain attribute \"" + domain + "\" violates the Netscape cookie specification");
            }
        }
    }

    private static final boolean $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$isSpecialDomain(String domain) {
        String ucDomain = domain.toUpperCase(Locale.ENGLISH);
        return ucDomain.endsWith(".COM") || ucDomain.endsWith(".EDU") || ucDomain.endsWith(".NET") || ucDomain.endsWith(".GOV") || ucDomain.endsWith(".MIL") || ucDomain.endsWith(".ORG") || ucDomain.endsWith(".INT");
    }

    private final boolean $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        return host.endsWith(domain);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$__constructor__();
    }

    public NetscapeDomainHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$__constructor__(), 0, this);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$validate(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    private static boolean isSpecialDomain(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSpecialDomain", $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$isSpecialDomain(java.lang.String ), 0, (String)string2);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$org_apache_http_impl_cookie_NetscapeDomainHandler$match(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetscapeDomainHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

