/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RFC2109Spec
extends CookieSpecBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static CookiePathComparator PATH_COMPARATOR;
    private static String[] DATE_PATTERNS;
    private String[] datepatterns;
    private boolean oneHeader;

    private void $$robo$$org_apache_http_impl_cookie_RFC2109Spec$__constructor__(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns != null ? (String[])datepatterns.clone() : DATE_PATTERNS;
        this.oneHeader = oneHeader;
        this.registerAttribHandler("version", new RFC2109VersionHandler());
        this.registerAttribHandler("path", new BasicPathHandler());
        this.registerAttribHandler("domain", new RFC2109DomainHandler());
        this.registerAttribHandler("max-age", new BasicMaxAgeHandler());
        this.registerAttribHandler("secure", new BasicSecureHandler());
        this.registerAttribHandler("comment", new BasicCommentHandler());
        this.registerAttribHandler("expires", new BasicExpiresHandler(this.datepatterns));
    }

    private void $$robo$$org_apache_http_impl_cookie_RFC2109Spec$__constructor__() {
    }

    private final List<Cookie> $$robo$$org_apache_http_impl_cookie_RFC2109Spec$parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        HeaderElement[] elems = header.getElements();
        return this.parse(elems, origin);
    }

    private final void $$robo$$org_apache_http_impl_cookie_RFC2109Spec$validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        String name = cookie.getName();
        if (name.indexOf(32) != -1) {
            throw new MalformedCookieException("Cookie name may not contain blanks");
        }
        if (name.startsWith("$")) {
            throw new MalformedCookieException("Cookie name may not start with $");
        }
        super.validate(cookie, origin);
    }

    private final List<Header> $$robo$$org_apache_http_impl_cookie_RFC2109Spec$formatCookies(List<Cookie> cookies) {
        if (cookies == null) {
            throw new IllegalArgumentException("List of cookies may not be null");
        }
        if (cookies.isEmpty()) {
            throw new IllegalArgumentException("List of cookies may not be empty");
        }
        if (cookies.size() > 1) {
            cookies = new ArrayList<Cookie>(cookies);
            Collections.sort(cookies, PATH_COMPARATOR);
        }
        if (this.oneHeader) {
            return this.doFormatOneHeader(cookies);
        }
        return this.doFormatManyHeaders(cookies);
    }

    private final List<Header> $$robo$$org_apache_http_impl_cookie_RFC2109Spec$doFormatOneHeader(List<Cookie> cookies) {
        int version = Integer.MAX_VALUE;
        for (Cookie cookie : cookies) {
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        CharArrayBuffer buffer = new CharArrayBuffer(40 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        buffer.append("$Version=");
        buffer.append(Integer.toString(version));
        for (Cookie cooky : cookies) {
            buffer.append("; ");
            Cookie cookie = cooky;
            this.formatCookieAsVer(buffer, cookie, version);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    private final List<Header> $$robo$$org_apache_http_impl_cookie_RFC2109Spec$doFormatManyHeaders(List<Cookie> cookies) {
        ArrayList<Header> headers = new ArrayList<Header>(cookies.size());
        for (Cookie cookie : cookies) {
            int version = cookie.getVersion();
            CharArrayBuffer buffer = new CharArrayBuffer(40);
            buffer.append("Cookie: ");
            buffer.append("$Version=");
            buffer.append(Integer.toString(version));
            buffer.append("; ");
            this.formatCookieAsVer(buffer, cookie, version);
            headers.add(new BufferedHeader(buffer));
        }
        return headers;
    }

    private final void $$robo$$org_apache_http_impl_cookie_RFC2109Spec$formatParamAsVer(CharArrayBuffer buffer, String name, String value, int version) {
        buffer.append(name);
        buffer.append("=");
        if (value != null) {
            if (version > 0) {
                buffer.append('\"');
                buffer.append(value);
                buffer.append('\"');
            } else {
                buffer.append(value);
            }
        }
    }

    private final void $$robo$$org_apache_http_impl_cookie_RFC2109Spec$formatCookieAsVer(CharArrayBuffer buffer, Cookie cookie, int version) {
        this.formatParamAsVer(buffer, cookie.getName(), cookie.getValue(), version);
        if (cookie.getPath() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("path")) {
            buffer.append("; ");
            this.formatParamAsVer(buffer, "$Path", cookie.getPath(), version);
        }
        if (cookie.getDomain() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            buffer.append("; ");
            this.formatParamAsVer(buffer, "$Domain", cookie.getDomain(), version);
        }
    }

    private final int $$robo$$org_apache_http_impl_cookie_RFC2109Spec$getVersion() {
        return 1;
    }

    private final Header $$robo$$org_apache_http_impl_cookie_RFC2109Spec$getVersionHeader() {
        return null;
    }

    static void __staticInitializer__() {
        PATH_COMPARATOR = new CookiePathComparator();
        DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    }

    private void __constructor__(String[] stringArray, boolean bl) {
        this.$$robo$$org_apache_http_impl_cookie_RFC2109Spec$__constructor__(stringArray, bl);
    }

    public RFC2109Spec(String[] stringArray, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$__constructor__(java.lang.String[] boolean ), 0, this, stringArray, bl);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_RFC2109Spec$__constructor__();
    }

    public RFC2109Spec() {
        this(null, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$__constructor__(), 0, this);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$parse(org.apache.http.Header org.apache.http.cookie.CookieOrigin ), 0, this, header, cookieOrigin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$validate(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> list) {
        return InvokeDynamicSupport.bootstrap("formatCookies", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$formatCookies(java.util.List<org.apache.http.cookie.Cookie> ), 0, this, list);
    }

    private List<Header> doFormatOneHeader(List<Cookie> list) {
        return InvokeDynamicSupport.bootstrap("doFormatOneHeader", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$doFormatOneHeader(java.util.List<org.apache.http.cookie.Cookie> ), 0, this, list);
    }

    private List<Header> doFormatManyHeaders(List<Cookie> list) {
        return InvokeDynamicSupport.bootstrap("doFormatManyHeaders", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$doFormatManyHeaders(java.util.List<org.apache.http.cookie.Cookie> ), 0, this, list);
    }

    protected void formatParamAsVer(CharArrayBuffer charArrayBuffer, String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("formatParamAsVer", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$formatParamAsVer(org.apache.http.util.CharArrayBuffer java.lang.String java.lang.String int ), 0, this, charArrayBuffer, string2, string3, n);
    }

    protected void formatCookieAsVer(CharArrayBuffer charArrayBuffer, Cookie cookie, int n) {
        InvokeDynamicSupport.bootstrap("formatCookieAsVer", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$formatCookieAsVer(org.apache.http.util.CharArrayBuffer org.apache.http.cookie.Cookie int ), 0, this, charArrayBuffer, cookie, n);
    }

    @Override
    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$getVersion(), 0, this);
    }

    @Override
    public Header getVersionHeader() {
        return InvokeDynamicSupport.bootstrap("getVersionHeader", $$robo$$org_apache_http_impl_cookie_RFC2109Spec$getVersionHeader(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(RFC2109Spec.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RFC2109Spec)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

