/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.StringTokenizer;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.cookie.SetCookie2;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RFC2965PortAttributeHandler
implements CookieAttributeHandler,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$__constructor__() {
    }

    private static final int[] $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$parsePortAttribute(String portValue) throws MalformedCookieException {
        StringTokenizer st = new StringTokenizer(portValue, ",");
        int[] ports = new int[st.countTokens()];
        try {
            int i = 0;
            while (st.hasMoreTokens()) {
                ports[i] = Integer.parseInt(st.nextToken().trim());
                if (ports[i] < 0) {
                    throw new MalformedCookieException("Invalid Port attribute.");
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid Port attribute: " + e.getMessage());
        }
        return ports;
    }

    private static final boolean $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$portMatch(int port, int[] ports) {
        boolean portInList = false;
        int len = ports.length;
        for (int i = 0; i < len; ++i) {
            if (port != ports[i]) continue;
            portInList = true;
            break;
        }
        return portInList;
    }

    private final void $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$parse(SetCookie cookie, String portValue) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookie instanceof SetCookie2) {
            SetCookie2 cookie2 = (SetCookie2)cookie;
            if (portValue != null && portValue.trim().length() > 0) {
                int[] ports = RFC2965PortAttributeHandler.parsePortAttribute(portValue);
                cookie2.setPorts(ports);
            }
        }
    }

    private final void $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        int port = origin.getPort();
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("port") && !RFC2965PortAttributeHandler.portMatch(port, cookie.getPorts())) {
            throw new MalformedCookieException("Port attribute violates RFC 2965: Request port not found in cookie's port list.");
        }
    }

    private final boolean $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        int port = origin.getPort();
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("port")) {
            if (cookie.getPorts() == null) {
                return false;
            }
            if (!RFC2965PortAttributeHandler.portMatch(port, cookie.getPorts())) {
                return false;
            }
        }
        return true;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$__constructor__();
    }

    public RFC2965PortAttributeHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$__constructor__(), 0, this);
    }

    private static int[] parsePortAttribute(String string2) throws MalformedCookieException {
        return InvokeDynamicSupport.bootstrapStatic("parsePortAttribute", $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$parsePortAttribute(java.lang.String ), 0, (String)string2);
    }

    private static boolean portMatch(int n, int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("portMatch", $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$portMatch(int int[] ), 0, (int)n, (int[])nArray);
    }

    @Override
    public void parse(SetCookie setCookie, String string2) throws MalformedCookieException {
        InvokeDynamicSupport.bootstrap("parse", $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$parse(org.apache.http.cookie.SetCookie java.lang.String ), 0, this, setCookie, string2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$validate(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$org_apache_http_impl_cookie_RFC2965PortAttributeHandler$match(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RFC2965PortAttributeHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

