/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.impl.cookie.RFC2109Spec;
import org.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import org.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import org.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RFC2965Spec
extends RFC2109Spec
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$org_apache_http_impl_cookie_RFC2965Spec$__constructor__() {
    }

    private void $$robo$$org_apache_http_impl_cookie_RFC2965Spec$__constructor__(String[] datepatterns, boolean oneHeader) {
        this.registerAttribHandler("domain", new RFC2965DomainAttributeHandler());
        this.registerAttribHandler("port", new RFC2965PortAttributeHandler());
        this.registerAttribHandler("commenturl", new RFC2965CommentUrlAttributeHandler());
        this.registerAttribHandler("discard", new RFC2965DiscardAttributeHandler());
        this.registerAttribHandler("version", new RFC2965VersionAttributeHandler());
    }

    private final BasicClientCookie $$robo$$org_apache_http_impl_cookie_RFC2965Spec$createCookie(String name, String value, CookieOrigin origin) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setPath(RFC2965Spec.getDefaultPath(origin));
        cookie.setDomain(RFC2965Spec.getDefaultDomain(origin));
        return cookie;
    }

    private final BasicClientCookie $$robo$$org_apache_http_impl_cookie_RFC2965Spec$createCookie2(String name, String value, CookieOrigin origin) {
        BasicClientCookie2 cookie = new BasicClientCookie2(name, value);
        cookie.setPath(RFC2965Spec.getDefaultPath(origin));
        cookie.setDomain(RFC2965Spec.getDefaultDomain(origin));
        cookie.setPorts(new int[]{origin.getPort()});
        return cookie;
    }

    private final List<Cookie> $$robo$$org_apache_http_impl_cookie_RFC2965Spec$parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        origin = RFC2965Spec.adjustEffectiveHost(origin);
        HeaderElement[] elems = header.getElements();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(elems.length);
        for (HeaderElement headerelement : elems) {
            String name = headerelement.getName();
            String value = headerelement.getValue();
            if (name == null || name.length() == 0) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie cookie = header.getName().equals("Set-Cookie2") ? this.createCookie2(name, value, origin) : this.createCookie(name, value, origin);
            NameValuePair[] attribs = headerelement.getParameters();
            HashMap<String, NameValuePair> attribmap = new HashMap<String, NameValuePair>(attribs.length);
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair param = attribs[j];
                attribmap.put(param.getName().toLowerCase(Locale.ENGLISH), param);
            }
            for (Map.Entry entry : attribmap.entrySet()) {
                NameValuePair attrib = (NameValuePair)entry.getValue();
                String s = attrib.getName().toLowerCase(Locale.ENGLISH);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            cookies.add(cookie);
        }
        return cookies;
    }

    private final void $$robo$$org_apache_http_impl_cookie_RFC2965Spec$validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        origin = RFC2965Spec.adjustEffectiveHost(origin);
        super.validate(cookie, origin);
    }

    private final boolean $$robo$$org_apache_http_impl_cookie_RFC2965Spec$match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        origin = RFC2965Spec.adjustEffectiveHost(origin);
        return super.match(cookie, origin);
    }

    private final void $$robo$$org_apache_http_impl_cookie_RFC2965Spec$formatCookieAsVer(CharArrayBuffer buffer, Cookie cookie, int version) {
        String s;
        super.formatCookieAsVer(buffer, cookie, version);
        if (cookie instanceof ClientCookie && (s = ((ClientCookie)cookie).getAttribute("port")) != null) {
            int[] ports;
            buffer.append("; $Port");
            buffer.append("=\"");
            if (s.trim().length() > 0 && (ports = cookie.getPorts()) != null) {
                int len = ports.length;
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(Integer.toString(ports[i]));
                }
            }
            buffer.append("\"");
        }
    }

    private static final CookieOrigin $$robo$$org_apache_http_impl_cookie_RFC2965Spec$adjustEffectiveHost(CookieOrigin origin) {
        String host = origin.getHost();
        boolean isLocalHost = true;
        for (int i = 0; i < host.length(); ++i) {
            char ch = host.charAt(i);
            if (ch != '.' && ch != ':') continue;
            isLocalHost = false;
            break;
        }
        if (isLocalHost) {
            host = host + ".local";
            return new CookieOrigin(host, origin.getPort(), origin.getPath(), origin.isSecure());
        }
        return origin;
    }

    private final int $$robo$$org_apache_http_impl_cookie_RFC2965Spec$getVersion() {
        return 1;
    }

    private final Header $$robo$$org_apache_http_impl_cookie_RFC2965Spec$getVersionHeader() {
        CharArrayBuffer buffer = new CharArrayBuffer(40);
        buffer.append("Cookie2");
        buffer.append(": ");
        buffer.append("$Version=");
        buffer.append(Integer.toString(this.getVersion()));
        return new BufferedHeader(buffer);
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_cookie_RFC2965Spec$__constructor__();
    }

    public RFC2965Spec() {
        this(null, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$__constructor__(), 0, this);
    }

    private void __constructor__(String[] stringArray, boolean bl) {
        this.$$robo$$org_apache_http_impl_cookie_RFC2965Spec$__constructor__(stringArray, bl);
    }

    public RFC2965Spec(String[] stringArray, boolean bl) {
        super(stringArray, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$__constructor__(java.lang.String[] boolean ), 0, this, stringArray, bl);
    }

    private BasicClientCookie createCookie(String string2, String string3, CookieOrigin cookieOrigin) {
        return InvokeDynamicSupport.bootstrap("createCookie", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$createCookie(java.lang.String java.lang.String org.apache.http.cookie.CookieOrigin ), 0, this, string2, string3, cookieOrigin);
    }

    private BasicClientCookie createCookie2(String string2, String string3, CookieOrigin cookieOrigin) {
        return InvokeDynamicSupport.bootstrap("createCookie2", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$createCookie2(java.lang.String java.lang.String org.apache.http.cookie.CookieOrigin ), 0, this, string2, string3, cookieOrigin);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$parse(org.apache.http.Header org.apache.http.cookie.CookieOrigin ), 0, this, header, cookieOrigin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$validate(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$match(org.apache.http.cookie.Cookie org.apache.http.cookie.CookieOrigin ), 0, this, cookie, cookieOrigin);
    }

    @Override
    protected void formatCookieAsVer(CharArrayBuffer charArrayBuffer, Cookie cookie, int n) {
        InvokeDynamicSupport.bootstrap("formatCookieAsVer", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$formatCookieAsVer(org.apache.http.util.CharArrayBuffer org.apache.http.cookie.Cookie int ), 0, this, charArrayBuffer, cookie, n);
    }

    private static CookieOrigin adjustEffectiveHost(CookieOrigin cookieOrigin) {
        return InvokeDynamicSupport.bootstrapStatic("adjustEffectiveHost", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$adjustEffectiveHost(org.apache.http.cookie.CookieOrigin ), 0, (CookieOrigin)cookieOrigin);
    }

    @Override
    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$getVersion(), 0, this);
    }

    @Override
    public Header getVersionHeader() {
        return InvokeDynamicSupport.bootstrap("getVersionHeader", $$robo$$org_apache_http_impl_cookie_RFC2965Spec$getVersionHeader(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RFC2965Spec)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

