/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.io.SessionInputBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EntityDeserializer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ContentLengthStrategy lenStrategy;

    private void $$robo$$org_apache_http_impl_entity_EntityDeserializer$__constructor__(ContentLengthStrategy lenStrategy) {
        if (lenStrategy == null) {
            throw new IllegalArgumentException("Content length strategy may not be null");
        }
        this.lenStrategy = lenStrategy;
    }

    private final BasicHttpEntity $$robo$$org_apache_http_impl_entity_EntityDeserializer$doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    private final HttpEntity $$robo$$org_apache_http_impl_entity_EntityDeserializer$deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        if (inbuffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        return this.doDeserialize(inbuffer, message);
    }

    private void __constructor__(ContentLengthStrategy contentLengthStrategy) {
        this.$$robo$$org_apache_http_impl_entity_EntityDeserializer$__constructor__(contentLengthStrategy);
    }

    public EntityDeserializer(ContentLengthStrategy contentLengthStrategy) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_entity_EntityDeserializer$__constructor__(org.apache.http.entity.ContentLengthStrategy ), 0, this, contentLengthStrategy);
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer sessionInputBuffer, HttpMessage httpMessage) throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("doDeserialize", $$robo$$org_apache_http_impl_entity_EntityDeserializer$doDeserialize(org.apache.http.io.SessionInputBuffer org.apache.http.HttpMessage ), 0, this, sessionInputBuffer, httpMessage);
    }

    public HttpEntity deserialize(SessionInputBuffer sessionInputBuffer, HttpMessage httpMessage) throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("deserialize", $$robo$$org_apache_http_impl_entity_EntityDeserializer$deserialize(org.apache.http.io.SessionInputBuffer org.apache.http.HttpMessage ), 0, this, sessionInputBuffer, httpMessage);
    }

    public /* synthetic */ EntityDeserializer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntityDeserializer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

