/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.io.ChunkedOutputStream;
import org.apache.http.impl.io.ContentLengthOutputStream;
import org.apache.http.impl.io.IdentityOutputStream;
import org.apache.http.io.SessionOutputBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EntitySerializer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ContentLengthStrategy lenStrategy;

    private void $$robo$$org_apache_http_impl_entity_EntitySerializer$__constructor__(ContentLengthStrategy lenStrategy) {
        if (lenStrategy == null) {
            throw new IllegalArgumentException("Content length strategy may not be null");
        }
        this.lenStrategy = lenStrategy;
    }

    private final OutputStream $$robo$$org_apache_http_impl_entity_EntitySerializer$doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    private final void $$robo$$org_apache_http_impl_entity_EntitySerializer$serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        if (outbuffer == null) {
            throw new IllegalArgumentException("Session output buffer may not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        OutputStream outstream = this.doSerialize(outbuffer, message);
        entity.writeTo(outstream);
        outstream.close();
    }

    private void __constructor__(ContentLengthStrategy contentLengthStrategy) {
        this.$$robo$$org_apache_http_impl_entity_EntitySerializer$__constructor__(contentLengthStrategy);
    }

    public EntitySerializer(ContentLengthStrategy contentLengthStrategy) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_entity_EntitySerializer$__constructor__(org.apache.http.entity.ContentLengthStrategy ), 0, this, contentLengthStrategy);
    }

    protected OutputStream doSerialize(SessionOutputBuffer sessionOutputBuffer, HttpMessage httpMessage) throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrap("doSerialize", $$robo$$org_apache_http_impl_entity_EntitySerializer$doSerialize(org.apache.http.io.SessionOutputBuffer org.apache.http.HttpMessage ), 0, this, sessionOutputBuffer, httpMessage);
    }

    public void serialize(SessionOutputBuffer sessionOutputBuffer, HttpMessage httpMessage, HttpEntity httpEntity) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("serialize", $$robo$$org_apache_http_impl_entity_EntitySerializer$serialize(org.apache.http.io.SessionOutputBuffer org.apache.http.HttpMessage org.apache.http.HttpEntity ), 0, this, sessionOutputBuffer, httpMessage, httpEntity);
    }

    public /* synthetic */ EntitySerializer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntitySerializer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

