/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.params.HttpParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LaxContentLengthStrategy
implements ContentLengthStrategy,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$org_apache_http_impl_entity_LaxContentLengthStrategy$__constructor__() {
    }

    private final long $$robo$$org_apache_http_impl_entity_LaxContentLengthStrategy$determineLength(HttpMessage message) throws HttpException {
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        HttpParams params = message.getParams();
        boolean strict = params.isParameterTrue("http.protocol.strict-transfer-encoding");
        Header transferEncodingHeader = message.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = message.getFirstHeader("Content-Length");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings = null;
            try {
                encodings = transferEncodingHeader.getElements();
            }
            catch (ParseException px) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + transferEncodingHeader, px);
            }
            if (strict) {
                for (int i = 0; i < encodings.length; ++i) {
                    String encoding = encodings[i].getName();
                    if (encoding == null || encoding.length() <= 0 || encoding.equalsIgnoreCase("chunked") || encoding.equalsIgnoreCase("identity")) continue;
                    throw new ProtocolException("Unsupported transfer encoding: " + encoding);
                }
            }
            int len = encodings.length;
            if ("identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -1L;
            }
            if (len > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                return -2L;
            }
            if (strict) {
                throw new ProtocolException("Chunk-encoding must be the last one applied");
            }
            return -1L;
        }
        if (contentLengthHeader != null) {
            long contentlen = -1L;
            Header[] headers = message.getHeaders("Content-Length");
            if (strict && headers.length > 1) {
                throw new ProtocolException("Multiple content length headers");
            }
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    contentlen = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException e) {
                    if (!strict) continue;
                    throw new ProtocolException("Invalid content length: " + header.getValue());
                }
            }
            if (contentlen >= 0L) {
                return contentlen;
            }
            return -1L;
        }
        return -1L;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_entity_LaxContentLengthStrategy$__constructor__();
    }

    public LaxContentLengthStrategy() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_entity_LaxContentLengthStrategy$__constructor__(), 0, this);
    }

    @Override
    public long determineLength(HttpMessage httpMessage) throws HttpException {
        return (long)InvokeDynamicSupport.bootstrap("determineLength", $$robo$$org_apache_http_impl_entity_LaxContentLengthStrategy$determineLength(org.apache.http.HttpMessage ), 0, this, httpMessage);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LaxContentLengthStrategy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

