/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractMessageParser
implements HttpMessageParser,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SessionInputBuffer sessionBuffer;
    private int maxHeaderCount;
    private int maxLineLen;
    protected LineParser lineParser;

    private void $$robo$$org_apache_http_impl_io_AbstractMessageParser$__constructor__(SessionInputBuffer buffer, LineParser parser, HttpParams params) {
        if (buffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sessionBuffer = buffer;
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
        this.lineParser = parser != null ? parser : BasicLineParser.DEFAULT;
    }

    private static final Header[] $$robo$$org_apache_http_impl_io_AbstractMessageParser$parseHeaders(SessionInputBuffer inbuffer, int maxHeaderCount, int maxLineLen, LineParser parser) throws HttpException, IOException {
        int i;
        ArrayList<CharArrayBuffer> headerLines;
        block11: {
            if (inbuffer == null) {
                throw new IllegalArgumentException("Session input buffer may not be null");
            }
            if (parser == null) {
                parser = BasicLineParser.DEFAULT;
            }
            headerLines = new ArrayList<CharArrayBuffer>();
            CharArrayBuffer current = null;
            CharArrayBuffer previous = null;
            do {
                if (current == null) {
                    current = new CharArrayBuffer(64);
                } else {
                    current.clear();
                }
                int l = inbuffer.readLine(current);
                if (l == -1 || current.length() < 1) break block11;
                if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                    char ch;
                    for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                    }
                    if (maxLineLen > 0 && previous.length() + 1 + current.length() - i > maxLineLen) {
                        throw new IOException("Maximum line length limit exceeded");
                    }
                    previous.append(' ');
                    previous.append(current, i, current.length() - i);
                    continue;
                }
                headerLines.add(current);
                previous = current;
                current = null;
            } while (maxHeaderCount <= 0 || headerLines.size() < maxHeaderCount);
            throw new IOException("Maximum header count exceeded");
        }
        Header[] headers = new Header[headerLines.size()];
        for (i = 0; i < headerLines.size(); ++i) {
            CharArrayBuffer buffer = (CharArrayBuffer)headerLines.get(i);
            try {
                headers[i] = parser.parseHeader(buffer);
                continue;
            }
            catch (ParseException ex) {
                throw new ProtocolException(ex.getMessage());
            }
        }
        return headers;
    }

    protected abstract HttpMessage parseHead(SessionInputBuffer var1) throws IOException, HttpException, ParseException;

    private final HttpMessage $$robo$$org_apache_http_impl_io_AbstractMessageParser$parse() throws IOException, HttpException {
        HttpMessage message = null;
        try {
            message = this.parseHead(this.sessionBuffer);
        }
        catch (ParseException px) {
            throw new ProtocolException(px.getMessage(), px);
        }
        Header[] headers = AbstractMessageParser.parseHeaders(this.sessionBuffer, this.maxHeaderCount, this.maxLineLen, this.lineParser);
        message.setHeaders(headers);
        return message;
    }

    private void __constructor__(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpParams httpParams) {
        this.$$robo$$org_apache_http_impl_io_AbstractMessageParser$__constructor__(sessionInputBuffer, lineParser, httpParams);
    }

    public AbstractMessageParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpParams httpParams) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_AbstractMessageParser$__constructor__(org.apache.http.io.SessionInputBuffer org.apache.http.message.LineParser org.apache.http.params.HttpParams ), 0, this, sessionInputBuffer, lineParser, httpParams);
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, int n, int n2, LineParser lineParser) throws HttpException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("parseHeaders", $$robo$$org_apache_http_impl_io_AbstractMessageParser$parseHeaders(org.apache.http.io.SessionInputBuffer int int org.apache.http.message.LineParser ), 0, (SessionInputBuffer)sessionInputBuffer, (int)n, (int)n2, (LineParser)lineParser);
    }

    @Override
    public HttpMessage parse() throws IOException, HttpException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$org_apache_http_impl_io_AbstractMessageParser$parse(), 0, this);
    }

    public /* synthetic */ AbstractMessageParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractMessageParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

