/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractSessionInputBuffer
implements SessionInputBuffer,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private InputStream instream;
    private byte[] buffer;
    private int bufferpos;
    private int bufferlen;
    private ByteArrayBuffer linebuffer;
    private String charset;
    private boolean ascii;
    private int maxLineLen;
    private HttpTransportMetricsImpl metrics;

    private void $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$__constructor__() {
        this.linebuffer = null;
        this.charset = "US-ASCII";
        this.ascii = true;
        this.maxLineLen = -1;
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$init(InputStream instream, int buffersize, HttpParams params) {
        if (instream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (buffersize <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.instream = instream;
        this.buffer = new byte[buffersize];
        this.bufferpos = 0;
        this.bufferlen = 0;
        this.linebuffer = new ByteArrayBuffer(buffersize);
        this.charset = HttpProtocolParams.getHttpElementCharset(params);
        this.ascii = this.charset.equalsIgnoreCase("US-ASCII") || this.charset.equalsIgnoreCase("ASCII");
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
        this.metrics = new HttpTransportMetricsImpl();
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$fillBuffer() throws IOException {
        int len;
        int off;
        int l;
        if (this.bufferpos > 0) {
            int len2 = this.bufferlen - this.bufferpos;
            if (len2 > 0) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.buffer, (int)this.bufferpos, (byte[])this.buffer, (int)0, (int)len2);
            }
            this.bufferpos = 0;
            this.bufferlen = len2;
        }
        if ((l = this.instream.read(this.buffer, off = this.bufferlen, len = this.buffer.length - off)) == -1) {
            return -1;
        }
        this.bufferlen = off + l;
        this.metrics.incrementBytesTransferred(l);
        return l;
    }

    private final boolean $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$hasBufferedData() {
        return this.bufferpos < this.bufferlen;
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$read() throws IOException {
        int noRead = 0;
        while (!this.hasBufferedData()) {
            noRead = this.fillBuffer();
            if (noRead != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferpos++] & 0xFF;
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return 0;
        }
        int noRead = 0;
        while (!this.hasBufferedData()) {
            noRead = this.fillBuffer();
            if (noRead != -1) continue;
            return -1;
        }
        int chunk = this.bufferlen - this.bufferpos;
        if (chunk > len) {
            chunk = len;
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.buffer, (int)this.bufferpos, (byte[])b, (int)off, (int)chunk);
        this.bufferpos += chunk;
        return chunk;
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$read(byte[] b) throws IOException {
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, b.length);
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$locateLF() {
        for (int i = this.bufferpos; i < this.bufferlen; ++i) {
            if (this.buffer[i] != 10) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$readLine(CharArrayBuffer charbuffer) throws IOException {
        if (charbuffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        this.linebuffer.clear();
        int noRead = 0;
        boolean retry = true;
        while (retry) {
            int len;
            int i = this.locateLF();
            if (i != -1) {
                if (this.linebuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charbuffer, i);
                }
                retry = false;
                len = i + 1 - this.bufferpos;
                this.linebuffer.append(this.buffer, this.bufferpos, len);
                this.bufferpos = i + 1;
            } else {
                if (this.hasBufferedData()) {
                    len = this.bufferlen - this.bufferpos;
                    this.linebuffer.append(this.buffer, this.bufferpos, len);
                    this.bufferpos = this.bufferlen;
                }
                if ((noRead = this.fillBuffer()) == -1) {
                    retry = false;
                }
            }
            if (this.maxLineLen <= 0 || this.linebuffer.length() < this.maxLineLen) continue;
            throw new IOException("Maximum line length limit exceeded");
        }
        if (noRead == -1 && this.linebuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charbuffer);
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$lineFromLineBuffer(CharArrayBuffer charbuffer) throws IOException {
        int l = this.linebuffer.length();
        if (l > 0) {
            if (this.linebuffer.byteAt(l - 1) == 10) {
                this.linebuffer.setLength(--l);
            }
            if (l > 0 && this.linebuffer.byteAt(l - 1) == 13) {
                this.linebuffer.setLength(--l);
            }
        }
        l = this.linebuffer.length();
        if (this.ascii) {
            charbuffer.append(this.linebuffer, 0, l);
        } else {
            String s = new String(this.linebuffer.buffer(), 0, l, this.charset);
            charbuffer.append(s);
        }
        return l;
    }

    private final int $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$lineFromReadBuffer(CharArrayBuffer charbuffer, int pos) throws IOException {
        int off = this.bufferpos;
        this.bufferpos = pos + 1;
        if (pos > off && this.buffer[pos - 1] == 13) {
            --pos;
        }
        int len = pos - off;
        if (this.ascii) {
            charbuffer.append(this.buffer, off, len);
        } else {
            String s = new String(this.buffer, off, len, this.charset);
            charbuffer.append(s);
        }
        return len;
    }

    private final String $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$readLine() throws IOException {
        CharArrayBuffer charbuffer = new CharArrayBuffer(64);
        int l = this.readLine(charbuffer);
        if (l != -1) {
            return charbuffer.toString();
        }
        return null;
    }

    private final HttpTransportMetrics $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$getMetrics() {
        return this.metrics;
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$__constructor__();
    }

    public AbstractSessionInputBuffer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$__constructor__(), 0, this);
    }

    protected void init(InputStream inputStream, int n, HttpParams httpParams) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$init(java.io.InputStream int org.apache.http.params.HttpParams ), 0, this, inputStream, n, httpParams);
    }

    protected int fillBuffer() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("fillBuffer", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$fillBuffer(), 0, this);
    }

    protected boolean hasBufferedData() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBufferedData", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$hasBufferedData(), 0, this);
    }

    @Override
    public int read() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$read(), 0, this);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$read(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$read(byte[] ), 0, this, byArray);
    }

    private int locateLF() {
        return (int)InvokeDynamicSupport.bootstrap("locateLF", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$locateLF(), 0, this);
    }

    @Override
    public int readLine(CharArrayBuffer charArrayBuffer) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("readLine", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$readLine(org.apache.http.util.CharArrayBuffer ), 0, this, charArrayBuffer);
    }

    private int lineFromLineBuffer(CharArrayBuffer charArrayBuffer) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("lineFromLineBuffer", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$lineFromLineBuffer(org.apache.http.util.CharArrayBuffer ), 0, this, charArrayBuffer);
    }

    private int lineFromReadBuffer(CharArrayBuffer charArrayBuffer, int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("lineFromReadBuffer", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$lineFromReadBuffer(org.apache.http.util.CharArrayBuffer int ), 0, this, charArrayBuffer, n);
    }

    @Override
    public String readLine() throws IOException {
        return InvokeDynamicSupport.bootstrap("readLine", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$readLine(), 0, this);
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$org_apache_http_impl_io_AbstractSessionInputBuffer$getMetrics(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractSessionInputBuffer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

