/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractSessionOutputBuffer
implements SessionOutputBuffer,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static byte[] CRLF;
    private static int MAX_CHUNK = 256;
    private OutputStream outstream;
    private ByteArrayBuffer buffer;
    private String charset;
    private boolean ascii;
    private HttpTransportMetricsImpl metrics;

    private void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$__constructor__() {
        this.charset = "US-ASCII";
        this.ascii = true;
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$init(OutputStream outstream, int buffersize, HttpParams params) {
        if (outstream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (buffersize <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.outstream = outstream;
        this.buffer = new ByteArrayBuffer(buffersize);
        this.charset = HttpProtocolParams.getHttpElementCharset(params);
        this.ascii = this.charset.equalsIgnoreCase("US-ASCII") || this.charset.equalsIgnoreCase("ASCII");
        this.metrics = new HttpTransportMetricsImpl();
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$flushBuffer() throws IOException {
        int len = this.buffer.length();
        if (len > 0) {
            this.outstream.write(this.buffer.buffer(), 0, len);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(len);
        }
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$flush() throws IOException {
        this.flushBuffer();
        this.outstream.flush();
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return;
        }
        if (len > 256 || len > this.buffer.capacity()) {
            this.flushBuffer();
            this.outstream.write(b, off, len);
            this.metrics.incrementBytesTransferred(len);
        } else {
            int freecapacity = this.buffer.capacity() - this.buffer.length();
            if (len > freecapacity) {
                this.flushBuffer();
            }
            this.buffer.append(b, off, len);
        }
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$write(int b) throws IOException {
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
        this.buffer.append(b);
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$writeLine(String s) throws IOException {
        if (s == null) {
            return;
        }
        if (s.length() > 0) {
            this.write(s.getBytes(this.charset));
        }
        this.write(CRLF);
    }

    private final void $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$writeLine(CharArrayBuffer s) throws IOException {
        if (s == null) {
            return;
        }
        if (this.ascii) {
            int chunk;
            int off = 0;
            for (int remaining = s.length(); remaining > 0; remaining -= chunk) {
                chunk = this.buffer.capacity() - this.buffer.length();
                if ((chunk = Math.min(chunk, remaining)) > 0) {
                    this.buffer.append(s, off, chunk);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                off += chunk;
            }
        } else {
            byte[] tmp = s.toString().getBytes(this.charset);
            this.write(tmp);
        }
        this.write(CRLF);
    }

    private final HttpTransportMetrics $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$getMetrics() {
        return this.metrics;
    }

    static void __staticInitializer__() {
        CRLF = new byte[]{13, 10};
    }

    private void __constructor__() {
        this.$$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$__constructor__();
    }

    public AbstractSessionOutputBuffer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$__constructor__(), 0, this);
    }

    protected void init(OutputStream outputStream, int n, HttpParams httpParams) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$init(java.io.OutputStream int org.apache.http.params.HttpParams ), 0, this, outputStream, n, httpParams);
    }

    protected void flushBuffer() throws IOException {
        InvokeDynamicSupport.bootstrap("flushBuffer", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$flushBuffer(), 0, this);
    }

    @Override
    public void flush() throws IOException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$flush(), 0, this);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$write(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$write(byte[] ), 0, this, byArray);
    }

    @Override
    public void write(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$write(int ), 0, this, n);
    }

    @Override
    public void writeLine(String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("writeLine", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$writeLine(java.lang.String ), 0, this, string2);
    }

    @Override
    public void writeLine(CharArrayBuffer charArrayBuffer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeLine", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$writeLine(org.apache.http.util.CharArrayBuffer ), 0, this, charArrayBuffer);
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$org_apache_http_impl_io_AbstractSessionOutputBuffer$getMetrics(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AbstractSessionOutputBuffer.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractSessionOutputBuffer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

