/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.ExceptionUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChunkedInputStream
extends InputStream
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private SessionInputBuffer in;
    private CharArrayBuffer buffer;
    private int chunkSize;
    private int pos;
    private boolean bof;
    private boolean eof;
    private boolean closed;
    private Header[] footers;

    private void $$robo$$org_apache_http_impl_io_ChunkedInputStream$__constructor__(SessionInputBuffer in) {
        this.bof = true;
        this.eof = false;
        this.closed = false;
        this.footers = new Header[0];
        if (in == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        this.in = in;
        this.pos = 0;
        this.buffer = new CharArrayBuffer(16);
    }

    private final int $$robo$$org_apache_http_impl_io_ChunkedInputStream$read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    private final int $$robo$$org_apache_http_impl_io_ChunkedInputStream$read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        len = Math.min(len, this.chunkSize - this.pos);
        int count = this.in.read(b, off, len);
        this.pos += count;
        return count;
    }

    private final int $$robo$$org_apache_http_impl_io_ChunkedInputStream$read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedInputStream$nextChunk() throws IOException {
        this.chunkSize = this.getChunkSize();
        if (this.chunkSize < 0) {
            throw new MalformedChunkCodingException("Negative chunk size");
        }
        this.bof = false;
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseTrailerHeaders();
        }
    }

    private final int $$robo$$org_apache_http_impl_io_ChunkedInputStream$getChunkSize() throws IOException {
        if (!this.bof) {
            int cr = this.in.read();
            int lf = this.in.read();
            if (cr != 13 || lf != 10) {
                throw new MalformedChunkCodingException("CRLF expected at end of chunk");
            }
        }
        this.buffer.clear();
        int i = this.in.readLine(this.buffer);
        if (i == -1) {
            throw new MalformedChunkCodingException("Chunked stream ended unexpectedly");
        }
        int separator = this.buffer.indexOf(59);
        if (separator < 0) {
            separator = this.buffer.length();
        }
        try {
            return Integer.parseInt(this.buffer.substringTrimmed(0, separator), 16);
        }
        catch (NumberFormatException e) {
            throw new MalformedChunkCodingException("Bad chunk header");
        }
    }

    private final void $$robo$$org_apache_http_impl_io_ChunkedInputStream$parseTrailerHeaders() throws IOException {
        try {
            this.footers = AbstractMessageParser.parseHeaders(this.in, -1, -1, null);
        }
        catch (HttpException e) {
            MalformedChunkCodingException ioe = new MalformedChunkCodingException("Invalid footer: " + e.getMessage());
            ExceptionUtils.initCause(ioe, e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$org_apache_http_impl_io_ChunkedInputStream$close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof) {
                    ChunkedInputStream.exhaustInputStream(this);
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    private final Header[] $$robo$$org_apache_http_impl_io_ChunkedInputStream$getFooters() {
        return (Header[])this.footers.clone();
    }

    private static final void $$robo$$org_apache_http_impl_io_ChunkedInputStream$exhaustInputStream(InputStream inStream) throws IOException {
        byte[] buffer = new byte[1024];
        while (inStream.read(buffer) >= 0) {
        }
    }

    private void __constructor__(SessionInputBuffer sessionInputBuffer) {
        this.$$robo$$org_apache_http_impl_io_ChunkedInputStream$__constructor__(sessionInputBuffer);
    }

    public ChunkedInputStream(SessionInputBuffer sessionInputBuffer) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_apache_http_impl_io_ChunkedInputStream$__constructor__(org.apache.http.io.SessionInputBuffer ), 0, this, sessionInputBuffer);
    }

    @Override
    public int read() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_ChunkedInputStream$read(), 0, this);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_ChunkedInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$org_apache_http_impl_io_ChunkedInputStream$read(byte[] ), 0, this, byArray);
    }

    private void nextChunk() throws IOException {
        InvokeDynamicSupport.bootstrap("nextChunk", $$robo$$org_apache_http_impl_io_ChunkedInputStream$nextChunk(), 0, this);
    }

    private int getChunkSize() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("getChunkSize", $$robo$$org_apache_http_impl_io_ChunkedInputStream$getChunkSize(), 0, this);
    }

    private void parseTrailerHeaders() throws IOException {
        InvokeDynamicSupport.bootstrap("parseTrailerHeaders", $$robo$$org_apache_http_impl_io_ChunkedInputStream$parseTrailerHeaders(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_apache_http_impl_io_ChunkedInputStream$close(), 0, this);
    }

    public Header[] getFooters() {
        return InvokeDynamicSupport.bootstrap("getFooters", $$robo$$org_apache_http_impl_io_ChunkedInputStream$getFooters(), 0, this);
    }

    static void exhaustInputStream(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("exhaustInputStream", $$robo$$org_apache_http_impl_io_ChunkedInputStream$exhaustInputStream(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public /* synthetic */ ChunkedInputStream() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChunkedInputStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

